/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.simulation.physicsEngine.JointStateProvider;

public class CombinedJointStateProviders
implements JointStateProvider {
    private final JointStateType state;
    private final List<JointStateProvider> jointStateProviders = new ArrayList<JointStateProvider>();
    private final DMatrixRMaj combinedJointState = new DMatrixRMaj(6, 1);

    public CombinedJointStateProviders(JointStateType state) {
        this.state = state;
    }

    public CombinedJointStateProviders(CombinedJointStateProviders other) {
        this.state = other.state;
        this.jointStateProviders.addAll(other.jointStateProviders);
    }

    public void addAll(CombinedJointStateProviders other) {
        if (other.getState() != this.state) {
            throw new IllegalArgumentException("State mismatch: expected " + String.valueOf(this.state) + ", was " + String.valueOf(other.getState()));
        }
        this.jointStateProviders.addAll(other.jointStateProviders);
    }

    public void addAll(Collection<? extends JointStateProvider> jointStateProviders) {
        jointStateProviders.forEach(this::add);
    }

    public void add(JointStateProvider jointStateProvider) {
        if (jointStateProvider == null) {
            return;
        }
        if (jointStateProvider.getState() != this.state) {
            throw new IllegalArgumentException("State mismatch: expected " + String.valueOf(this.state) + ", was " + String.valueOf(jointStateProvider.getState()));
        }
        this.jointStateProviders.add(jointStateProvider);
    }

    public void removeAll(CombinedJointStateProviders other) {
        this.jointStateProviders.removeAll(other.jointStateProviders);
    }

    public void removeJointSateProviders(Collection<? extends JointStateProvider> jointStateProviders) {
        jointStateProviders.forEach(this::add);
    }

    public void removeJointSateProvider(JointStateProvider jointStateProvider) {
        if (jointStateProvider == null) {
            return;
        }
        this.jointStateProviders.remove(jointStateProvider);
    }

    @Override
    public JointStateType getState() {
        return this.state;
    }

    @Override
    public DMatrixRMaj getJointState(JointReadOnly joint) {
        this.combinedJointState.zero();
        this.combinedJointState.reshape(joint.getDegreesOfFreedom(), 1);
        for (JointStateProvider jointStateProvider : this.jointStateProviders) {
            DMatrixRMaj jointState = jointStateProvider.getJointState(joint);
            if (jointState == null) continue;
            CommonOps_DDRM.addEquals((DMatrixD1)this.combinedJointState, (DMatrixD1)jointState);
        }
        return this.combinedJointState;
    }

    @Override
    public double getJointState(OneDoFJointReadOnly joint) {
        double combinedJointState = 0.0;
        for (JointStateProvider jointStateProvider : this.jointStateProviders) {
            double jointState = jointStateProvider.getJointState(joint);
            if (!Double.isFinite(jointState)) continue;
            combinedJointState += jointState;
        }
        return combinedJointState;
    }
}

