/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimCameraSensor;
import us.ihmc.scs2.simulation.robot.sensors.SimIMUSensor;
import us.ihmc.scs2.simulation.robot.sensors.SimWrenchSensor;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.scs2.simulation.robot.trackers.GroundContactPoint;
import us.ihmc.scs2.simulation.robot.trackers.KinematicPoint;

public class SimJointAuxiliaryData {
    private final SimJointBasics joint;
    private final List<KinematicPoint> kinematicPoints = new ArrayList<KinematicPoint>();
    private final List<ExternalWrenchPoint> externalWrenchPoints = new ArrayList<ExternalWrenchPoint>();
    private final List<GroundContactPoint> groundContactPoints = new ArrayList<GroundContactPoint>();
    private final List<SimIMUSensor> imuSensors = new ArrayList<SimIMUSensor>();
    private final List<SimWrenchSensor> wrenchSensors = new ArrayList<SimWrenchSensor>();
    private final List<SimCameraSensor> cameraSensors = new ArrayList<SimCameraSensor>();

    public SimJointAuxiliaryData(SimJointBasics joint) {
        this.joint = joint;
    }

    public void updateFrames() {
        this.kinematicPoints.forEach(kp -> kp.getFrame().update());
        this.externalWrenchPoints.forEach(ewp -> ewp.getFrame().update());
        this.groundContactPoints.forEach(gcp -> gcp.getFrame().update());
        this.imuSensors.forEach(imu -> imu.getFrame().update());
        this.wrenchSensors.forEach(wrench -> wrench.getFrame().update());
        this.cameraSensors.forEach(camera -> camera.getFrame().update());
    }

    public void update(RobotPhysicsOutput physicsOutput) {
        int i;
        for (i = 0; i < this.kinematicPoints.size(); ++i) {
            this.kinematicPoints.get(i).update();
        }
        for (i = 0; i < this.externalWrenchPoints.size(); ++i) {
            this.externalWrenchPoints.get(i).update();
        }
        for (i = 0; i < this.groundContactPoints.size(); ++i) {
            this.groundContactPoints.get(i).update();
        }
        for (i = 0; i < this.imuSensors.size(); ++i) {
            this.imuSensors.get(i).update(physicsOutput);
        }
        for (i = 0; i < this.wrenchSensors.size(); ++i) {
            this.wrenchSensors.get(i).update(physicsOutput);
        }
        for (i = 0; i < this.cameraSensors.size(); ++i) {
            this.cameraSensors.get(i).update(physicsOutput);
        }
    }

    public KinematicPoint addKinematicPoint(String name) {
        return this.addKinematicPoint(new KinematicPointDefinition(name));
    }

    public KinematicPoint addKinematicPoint(String name, Tuple3DReadOnly offset) {
        return this.addKinematicPoint(new KinematicPointDefinition(name, offset));
    }

    public KinematicPoint addKinematicPoint(KinematicPointDefinition definition) {
        KinematicPoint kinematicPoint = new KinematicPoint(definition, this.joint);
        this.kinematicPoints.add(kinematicPoint);
        return kinematicPoint;
    }

    public ExternalWrenchPoint addExternalWrenchPoint(String name) {
        return this.addExternalWrenchPoint(new ExternalWrenchPointDefinition(name));
    }

    public ExternalWrenchPoint addExternalWrenchPoint(String name, Tuple3DReadOnly offset) {
        return this.addExternalWrenchPoint(new ExternalWrenchPointDefinition(name, offset));
    }

    public ExternalWrenchPoint addExternalWrenchPoint(ExternalWrenchPointDefinition definition) {
        ExternalWrenchPoint externalWrenchPoint = new ExternalWrenchPoint(definition, this.joint);
        this.externalWrenchPoints.add(externalWrenchPoint);
        return externalWrenchPoint;
    }

    public GroundContactPoint addGroundContactPoint(String name) {
        return this.addGroundContactPoint(new GroundContactPointDefinition(name));
    }

    public GroundContactPoint addGroundContactPoint(String name, Tuple3DReadOnly offset) {
        return this.addGroundContactPoint(new GroundContactPointDefinition(name, offset));
    }

    public GroundContactPoint addGroundContactPoint(GroundContactPointDefinition definition) {
        GroundContactPoint groundContactPoint = new GroundContactPoint((KinematicPointDefinition)definition, this.joint);
        this.groundContactPoints.add(groundContactPoint);
        return groundContactPoint;
    }

    public SimIMUSensor addIMUSensor(String name) {
        return this.addIMUSensor(new IMUSensorDefinition(name));
    }

    public SimIMUSensor addIMUSensor(String name, Tuple3DReadOnly offset) {
        return this.addIMUSensor(new IMUSensorDefinition(name, offset));
    }

    public SimIMUSensor addIMUSensor(IMUSensorDefinition definition) {
        SimIMUSensor newSensor = new SimIMUSensor(definition, this.joint);
        this.imuSensors.add(newSensor);
        return newSensor;
    }

    public SimWrenchSensor addWrenchSensor(String name) {
        return this.addWrenchSensor(new WrenchSensorDefinition(name));
    }

    public SimWrenchSensor addWrenchSensor(String name, Tuple3DReadOnly offset) {
        return this.addWrenchSensor(new WrenchSensorDefinition(name, offset));
    }

    public SimWrenchSensor addWrenchSensor(WrenchSensorDefinition definition) {
        SimWrenchSensor newSensor = new SimWrenchSensor(definition, this.joint);
        this.wrenchSensors.add(newSensor);
        return newSensor;
    }

    public SimCameraSensor addCameraSensor(String name) {
        return this.addCameraSensor(new CameraSensorDefinition(name));
    }

    public SimCameraSensor addCameraSensor(String name, Tuple3DReadOnly offset) {
        return this.addCameraSensor(new CameraSensorDefinition(name, offset));
    }

    public SimCameraSensor addCameraSensor(CameraSensorDefinition definition) {
        SimCameraSensor newSensor = new SimCameraSensor(definition, this.joint);
        this.cameraSensors.add(newSensor);
        return newSensor;
    }

    public SimJointBasics getJoint() {
        return this.joint;
    }

    public List<KinematicPoint> getKinematicPoints() {
        return this.kinematicPoints;
    }

    public List<ExternalWrenchPoint> getExternalWrenchPoints() {
        return this.externalWrenchPoints;
    }

    public List<GroundContactPoint> getGroundContactPoints() {
        return this.groundContactPoints;
    }

    public List<SimIMUSensor> getIMUSensors() {
        return this.imuSensors;
    }

    public List<SimWrenchSensor> getWrenchSensors() {
        return this.wrenchSensors;
    }

    public List<SimCameraSensor> getCameraSensors() {
        return this.cameraSensors;
    }
}

