/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.SessionInformationDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimulationDataSession
extends Session {
    private final String sessionName;
    private final List<Robot> robots = new ArrayList<Robot>();
    private final List<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();

    public SimulationDataSession(File sessionInfoFile) throws FileNotFoundException, JAXBException, IOException {
        Path resourceDirectory;
        File robotFile;
        SessionInformationDefinition sessionInfo = DefinitionIOTools.loadSessionInformationDefinition((InputStream)new FileInputStream(sessionInfoFile));
        this.sessionName = sessionInfo.getSessionName();
        this.setSessionDTSeconds(sessionInfo.getRecordDTSeconds());
        File dataDirectory = sessionInfoFile.getParentFile();
        for (String robotFileName : sessionInfo.getRobotFileNames()) {
            robotFile = new File(dataDirectory, robotFileName);
            RobotDefinition robotDefinition = DefinitionIOTools.loadRobotDefinition((InputStream)new FileInputStream(robotFile));
            resourceDirectory = Paths.get(dataDirectory.getAbsolutePath(), "resources", robotDefinition.getName());
            robotDefinition.setResourceClassLoader((ClassLoader)new URLClassLoader(new URL[]{resourceDirectory.toUri().toURL()}));
            this.robotDefinitions.add(robotDefinition);
            this.robots.add(new Robot(robotDefinition, this.getInertialFrame()));
        }
        for (String terrainFileName : sessionInfo.getTerrainFileNames()) {
            robotFile = new File(dataDirectory, terrainFileName);
            TerrainObjectDefinition terrainObjectDefinition = DefinitionIOTools.loadTerrainObjectDefinition((InputStream)new FileInputStream(robotFile));
            resourceDirectory = Paths.get(dataDirectory.getAbsolutePath(), "resources", terrainFileName.replace(".scs2.terrain", ""));
            terrainObjectDefinition.setResourceClassLoader((ClassLoader)new URLClassLoader(new URL[]{resourceDirectory.toUri().toURL()}));
            this.terrainObjectDefinitions.add(terrainObjectDefinition);
        }
        if (sessionInfo.getGraphicFileName() != null) {
            File graphicFile = new File(dataDirectory, sessionInfo.getGraphicFileName());
            this.yoGraphicDefinitions.addAll(DefinitionIOTools.loadYoGraphicListDefinition((File)graphicFile).getYoGraphics());
        }
        if (sessionInfo.getRegistryFileName() != null) {
            File registryFile = new File(dataDirectory, sessionInfo.getRegistryFileName());
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFile)), (YoRegistry)this.rootRegistry);
        }
        if (sessionInfo.getDataFileName() != null) {
            Objects.requireNonNull(sessionInfo.getRegistryFileName());
            File dataFile = new File(dataDirectory, sessionInfo.getDataFileName());
            this.sharedBuffer.resizeBuffer(1);
            switch (SharedMemoryIOTools.DataFormat.fromFilename((String)dataFile.getName())) {
                case ASCII: {
                    SharedMemoryIOTools.importDataASCII((InputStream)new FileInputStream(dataFile), (YoSharedBuffer)this.sharedBuffer);
                    break;
                }
                case CSV: {
                    SharedMemoryIOTools.importDataCSV((InputStream)new FileInputStream(dataFile), (YoSharedBuffer)this.sharedBuffer);
                    break;
                }
                case MATLAB: {
                    SharedMemoryIOTools.importDataMatlab((File)dataFile, (YoSharedBuffer)this.sharedBuffer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data format: " + dataFile.getName());
                }
            }
        }
        this.hasBufferSizeBeenInitialized = true;
        this.hasBufferRecordPeriodBeenInitialized = true;
        this.setSessionModeTask(SessionMode.RUNNING, () -> this.setSessionMode(SessionMode.PAUSE));
        this.startSessionThread();
    }

    protected double doSpecificRunTick() {
        return 0.0;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<Robot> getRobots() {
        return this.robots;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return this.robots.stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }
}

