/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.concurrent.TimeUnit;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.simulation.robot.controller.RobotControllerManager;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimMultiBodySystemBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;

public interface RobotInterface
extends SimMultiBodySystemBasics {
    public String getName();

    public RobotDefinition getRobotDefinition();

    public RobotControllerManager getControllerManager();

    default public ControllerInput getControllerInput() {
        return this.getControllerManager().getControllerInput();
    }

    default public ControllerOutput getControllerOutput() {
        return this.getControllerManager().getControllerOutput();
    }

    default public void addController(Controller controller) {
        this.getControllerManager().addController(controller);
    }

    default public void addThrottledController(Controller controller, double periodInSeconds) {
        this.getControllerManager().addThrottledController(controller, periodInSeconds);
    }

    default public void addThrottledController(Controller controller, long period, TimeUnit timeUnit) {
        this.getControllerManager().addThrottledController(controller, period, timeUnit);
    }

    default public void addController(ControllerDefinition controllerDefinition) {
        this.getControllerManager().addController(controllerDefinition);
    }

    default public void addThrottledController(ControllerDefinition controllerDefinition, double periodInSeconds) {
        this.getControllerManager().addThrottledController(controllerDefinition, periodInSeconds);
    }

    default public void addThrottledController(ControllerDefinition controllerDefinition, long period, TimeUnit timeUnit) {
        this.getControllerManager().addThrottledController(controllerDefinition, period, timeUnit);
    }

    public void resetState();

    public void initializeState();

    default public void updateFrames() {
        this.getRootBody().updateFramesRecursively();
    }

    public SimRigidBodyBasics getRigidBody(String var1);

    public SimJointBasics getJoint(String var1);

    default public SimOneDoFJointBasics getOneDoFJoint(String name) {
        SimJointBasics joint = this.getJoint(name);
        if (joint instanceof SimOneDoFJointBasics) {
            return (SimOneDoFJointBasics)joint;
        }
        return null;
    }
}

