/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.io.PrintStream;
import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.MatrixIO;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoMatrix
implements DMatrix,
ReshapeMatrix {
    private static final long serialVersionUID = 2156411740647948028L;
    private final int maxNumberOfRows;
    private final int maxNumberOfColumns;
    private final YoInteger numberOfRows;
    private final YoInteger numberOfColumns;
    private final YoDouble[][] variables;

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, null, null, registry);
    }

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, rowNames, null, registry);
    }

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, String[] columnNames, YoRegistry registry) {
        this(name, null, maxNumberOfRows, maxNumberOfColumns, rowNames, columnNames, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        this(name, description, maxNumberOfRows, maxNumberOfColumns, null, null, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, YoRegistry registry) {
        this(name, description, maxNumberOfRows, maxNumberOfColumns, rowNames, null, registry);
    }

    public YoMatrix(String name, String description, int maxNumberOfRows, int maxNumberOfColumns, String[] rowNames, String[] columnNames, YoRegistry registry) {
        this.maxNumberOfRows = maxNumberOfRows;
        this.maxNumberOfColumns = maxNumberOfColumns;
        this.numberOfRows = new YoInteger(name + "NumRows", registry);
        this.numberOfColumns = new YoInteger(name + "NumCols", registry);
        this.numberOfRows.set(maxNumberOfRows);
        this.numberOfColumns.set(maxNumberOfColumns);
        this.variables = new YoDouble[maxNumberOfRows][maxNumberOfColumns];
        for (int row = 0; row < maxNumberOfRows; ++row) {
            block6: for (int column = 0; column < maxNumberOfColumns; ++column) {
                switch (this.checkNames(rowNames, columnNames)) {
                    case NONE: {
                        this.variables[row][column] = new YoDouble(name + "_" + row + "_" + column, description, registry);
                        continue block6;
                    }
                    case ROWS: {
                        if (maxNumberOfColumns > 1) {
                            throw new IllegalArgumentException("The YoMatrix must be a column vector if only row names are provided, else unique names cannot be generated.");
                        }
                        this.variables[row][column] = new YoDouble(name + "_" + rowNames[row], description, registry);
                        continue block6;
                    }
                    case ROWS_AND_COLUMNS: {
                        this.variables[row][column] = new YoDouble(name + "_" + rowNames[row] + "_" + columnNames[column], description, registry);
                    }
                }
            }
        }
    }

    private NamesProvided checkNames(String[] rowNames, String[] columnNames) {
        if (rowNames == null && columnNames == null) {
            return NamesProvided.NONE;
        }
        if (rowNames != null && columnNames == null) {
            return NamesProvided.ROWS;
        }
        return NamesProvided.ROWS_AND_COLUMNS;
    }

    public void reshape(int numRows, int numCols) {
        int col;
        int row;
        if (numRows > this.maxNumberOfRows) {
            throw new IllegalArgumentException("Too many rows. Expected less or equal to " + this.maxNumberOfRows + ", was " + numRows);
        }
        if (numCols > this.maxNumberOfColumns) {
            throw new IllegalArgumentException("Too many columns. Expected less or equal to " + this.maxNumberOfColumns + ", was " + numCols);
        }
        if (numRows < 0 || numCols < 0) {
            throw new IllegalArgumentException("Cannot reshape with a negative number of rows or columns.");
        }
        this.numberOfRows.set(numRows);
        this.numberOfColumns.set(numCols);
        for (row = 0; row < numRows; ++row) {
            for (col = numCols; col < this.maxNumberOfColumns; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
        for (row = numRows; row < this.maxNumberOfRows; ++row) {
            for (col = 0; col < this.maxNumberOfColumns; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
    }

    public void set(Matrix original) {
        if (original instanceof DMatrix) {
            DMatrix otherMatrix = (DMatrix)original;
            this.reshape(otherMatrix.getNumRows(), otherMatrix.getNumRows());
            for (int row = 0; row < this.getNumRows(); ++row) {
                for (int col = 0; col < this.getNumCols(); ++col) {
                    this.set(row, col, otherMatrix.unsafe_get(row, col));
                }
            }
        }
    }

    public void set(int row, int col, double val) {
        if (col < 0 || col >= this.getNumCols() || row < 0 || row >= this.getNumRows()) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        this.unsafe_set(row, col, val);
    }

    public void unsafe_set(int row, int col, double val) {
        this.variables[row][col].set(val);
    }

    public double get(int row, int col) {
        if (col < 0 || col >= this.getNumCols() || row < 0 || row >= this.getNumRows()) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        return this.unsafe_get(row, col);
    }

    public double unsafe_get(int row, int col) {
        return this.variables[row][col].getValue();
    }

    public void zero() {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.variables[row][col].set(0.0);
            }
        }
    }

    public void setToNaN(int numRows, int numCols) {
        this.reshape(numRows, numCols);
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                this.unsafe_set(row, col, Double.NaN);
            }
        }
    }

    public void add(DMatrix otherMatrix) {
        if (otherMatrix.getNumRows() != this.getNumRows() || otherMatrix.getNumCols() != this.getNumCols()) {
            throw new IllegalArgumentException("Incompatible matrix sizes.");
        }
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                this.unsafe_set(row, col, this.unsafe_get(row, col) + otherMatrix.unsafe_get(row, col));
            }
        }
    }

    public int getNumRows() {
        return this.numberOfRows.getValue();
    }

    public int getNumCols() {
        return this.numberOfColumns.getValue();
    }

    public int getNumElements() {
        return this.getNumRows() * this.getNumCols();
    }

    public MatrixType getType() {
        return MatrixType.UNSPECIFIED;
    }

    public void print() {
        MatrixIO.printFancy((PrintStream)System.out, (DMatrix)this, (int)11);
    }

    public void print(String format) {
        MatrixIO.print((PrintStream)System.out, (DMatrix)this, (String)format);
    }

    public <T extends Matrix> T createLike() {
        throw new UnsupportedOperationException();
    }

    public <T extends Matrix> T create(int numRows, int numCols) {
        throw new UnsupportedOperationException();
    }

    public <T extends Matrix> T copy() {
        throw new UnsupportedOperationException();
    }

    private static enum NamesProvided {
        NONE,
        ROWS,
        ROWS_AND_COLUMNS;

    }
}

