/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.Map;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.simulation.physicsEngine.MultiRobotCollisionGroup;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobot;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.MultiContactImpulseCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoMultiContactImpulseCalculator
extends MultiContactImpulseCalculator {
    private final YoDouble alphaMin;
    private final YoDouble gamma;
    private final YoDouble tolerance;
    private final YoInteger maxNumberOfIterations;
    private final YoInteger iterationCounter;
    private final YoInteger numberOfCollisions;
    private final YoDouble maxUpdateMagnitude;
    private final YoInteger noConvergenceCounter;

    public YoMultiContactImpulseCalculator(int identifier, ReferenceFrame rootFrame, YoRegistry registry) {
        super(rootFrame);
        this.alphaMin = new YoDouble("alphaMin" + identifier, registry);
        this.gamma = new YoDouble("gamma" + identifier, registry);
        this.tolerance = new YoDouble("tolerance" + identifier, registry);
        this.maxNumberOfIterations = new YoInteger("maxNumberOfIterations" + identifier, registry);
        this.iterationCounter = new YoInteger("iterationCounter" + identifier, registry);
        this.numberOfCollisions = new YoInteger("numberOfCollisions" + identifier, registry);
        this.maxUpdateMagnitude = new YoDouble("maxUpdateMagnitude" + identifier, registry);
        this.noConvergenceCounter = new YoInteger("noConvergenceCounter" + identifier, registry);
        this.alphaMin.set(this.getAlphaMin());
        this.gamma.set(this.getGamma());
        this.tolerance.set(this.getTolerance());
        this.maxNumberOfIterations.set(this.getMaxNumberOfIterations());
    }

    @Override
    public void setAlphaMin(double alphaMin) {
        this.alphaMin.set(alphaMin);
    }

    @Override
    public void setGamma(double gamma) {
        this.gamma.set(gamma);
    }

    @Override
    public void setTolerance(double tolerance) {
        this.tolerance.set(tolerance);
    }

    @Override
    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations.set(maxNumberOfIterations);
    }

    public void clear() {
        this.numberOfCollisions.set(-1);
        this.iterationCounter.set(-1);
    }

    @Override
    public void configure(Map<RigidBodyBasics, ImpulseBasedRobot> robots, MultiRobotCollisionGroup collisionGroup) {
        super.configure(robots, collisionGroup);
        this.numberOfCollisions.set(collisionGroup.getNumberOfCollisions());
    }

    @Override
    public double computeImpulses(double time, double dt, boolean verbose) {
        super.setAlphaMin(this.alphaMin.getValue());
        super.setGamma(this.gamma.getValue());
        super.setTolerance(this.tolerance.getValue());
        super.setMaxNumberOfIterations(this.maxNumberOfIterations.getValue());
        this.maxUpdateMagnitude.set(super.computeImpulses(time, dt, verbose));
        this.iterationCounter.set(this.getNumberOfIterations());
        if (this.iterationCounter.getValue() > this.maxNumberOfIterations.getValue()) {
            this.noConvergenceCounter.increment();
        }
        return this.maxUpdateMagnitude.getValue();
    }
}

