/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.physicsEngine.JointStateProvider;

public class ImpulseBasedJointTwistProvider
implements JointStateProvider {
    private final RigidBodyBasics rootBody;
    private int impulseDimension;
    private boolean isImpulseZero = true;
    private final DMatrixRMaj impulse = new DMatrixRMaj(6, 1);
    private final List<JointBasics> joints = new ArrayList<JointBasics>();
    private final Map<JointBasics, DMatrixRMaj> apparentInertiaMatrixInverseMap = new HashMap<JointBasics, DMatrixRMaj>();
    private final DMatrixRMaj jointTwist = new DMatrixRMaj(6, 1);

    public ImpulseBasedJointTwistProvider(RigidBodyBasics rootBody) {
        this.rootBody = rootBody;
    }

    public void clear(int impulseDimension) {
        this.isImpulseZero = true;
        this.impulseDimension = impulseDimension;
        this.impulse.reshape(impulseDimension, 1);
        this.impulse.zero();
        this.joints.clear();
        this.apparentInertiaMatrixInverseMap.clear();
    }

    public void addAll(Collection<? extends JointBasics> joints) {
        for (JointBasics jointBasics : joints) {
            this.add(jointBasics);
        }
    }

    public void add(JointBasics joint) {
        if (MultiBodySystemTools.getRootBody((RigidBodyBasics)joint.getPredecessor()) != this.rootBody) {
            return;
        }
        this.joints.add(joint);
        this.apparentInertiaMatrixInverseMap.put(joint, new DMatrixRMaj(joint.getDegreesOfFreedom(), this.impulseDimension));
    }

    public List<JointBasics> getJoints() {
        return this.joints;
    }

    public DMatrixRMaj getApparentInertiaMatrixInverse(JointBasics joint) {
        return this.apparentInertiaMatrixInverseMap.get(joint);
    }

    public void setImpulseToZero() {
        this.isImpulseZero = true;
        this.impulse.zero();
    }

    public void setImpulse(double impulse) {
        this.isImpulseZero = false;
        this.impulse.set(0, impulse);
    }

    public void setImpulse(DMatrixRMaj impulse) {
        this.isImpulseZero = false;
        this.impulse.set((DMatrixD1)impulse);
    }

    public void setImpulse(Vector3DReadOnly impulse) {
        this.isImpulseZero = false;
        impulse.get((DMatrix)this.impulse);
    }

    public void setImpulse(Vector3DReadOnly impulseLinear, double impulseAngular) {
        this.isImpulseZero = false;
        impulseLinear.get((DMatrix)this.impulse);
        this.impulse.set(3, 0, impulseAngular);
    }

    @Override
    public JointStateType getState() {
        return JointStateType.VELOCITY;
    }

    @Override
    public DMatrixRMaj getJointState(JointReadOnly joint) {
        if (this.isImpulseZero) {
            return null;
        }
        DMatrixRMaj apparentInertiaMatrixInverse = this.apparentInertiaMatrixInverseMap.get(joint);
        if (apparentInertiaMatrixInverse == null) {
            return null;
        }
        this.jointTwist.reshape(joint.getDegreesOfFreedom(), 1);
        CommonOps_DDRM.mult((DMatrix1Row)apparentInertiaMatrixInverse, (DMatrix1Row)this.impulse, (DMatrix1Row)this.jointTwist);
        return this.jointTwist;
    }
}

