/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimulationEnergyStatistics {
    public static void setupSimulationEnergyStatistics(SimulationSession simulationSession) {
        YoRegistry registry = new YoRegistry(SimulationEnergyStatistics.class.getSimpleName());
        simulationSession.getPhysicsEngine().getPhysicsEngineRegistry().addChild(registry);
        for (Robot robot : simulationSession.getPhysicsEngine().getRobots()) {
            simulationSession.addAfterPhysicsCallback(new RobotEnergyStatistics(robot, (Vector3DReadOnly)simulationSession.getGravity(), registry));
        }
    }

    private static class RobotEnergyStatistics
    implements TimeConsumer {
        private final YoDouble kineticEnergy;
        private final YoDouble potentialEnergy;
        private final YoDouble orbitalEnergy;
        private final Vector3DReadOnly gravity;
        private List<? extends RigidBodyReadOnly> allRigidBodies;

        public RobotEnergyStatistics(Robot robot, Vector3DReadOnly gravity, YoRegistry registry) {
            this.gravity = gravity;
            this.kineticEnergy = new YoDouble(robot.getName() + "KineticEnergy", registry);
            this.potentialEnergy = new YoDouble(robot.getName() + "PotentialEnergy", registry);
            this.orbitalEnergy = new YoDouble(robot.getName() + "OrbitalEnergy", registry);
            this.allRigidBodies = robot.getRootBody().subtreeStream().filter(body -> !body.isRootBody()).collect(Collectors.toList());
        }

        @Override
        public void accept(double time) {
            double kinetic = 0.0;
            double potential = 0.0;
            for (RigidBodyReadOnly rigidBodyReadOnly : this.allRigidBodies) {
                SpatialInertiaReadOnly inertia = rigidBodyReadOnly.getInertia();
                MovingReferenceFrame bodyFixedFrame = rigidBodyReadOnly.getBodyFixedFrame();
                kinetic += inertia.computeKineticCoEnergy(bodyFixedFrame.getTwistOfFrame());
                potential += -inertia.getMass() * this.gravity.dot((Tuple3DReadOnly)bodyFixedFrame.getTransformToRoot().getTranslation());
            }
            this.kineticEnergy.set(kinetic);
            this.potentialEnergy.set(potential);
            this.orbitalEnergy.set(kinetic + potential);
        }
    }
}

