/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.PlanarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.CrossFourBarJointDefinition;
import us.ihmc.scs2.definition.robot.FixedJointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.LoopClosureDefinition;
import us.ihmc.scs2.definition.robot.PlanarJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.SphericalJointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.definition.state.JointState;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.PlanarJointState;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.SphericalJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.controller.LoopClosureSoftConstraintController;
import us.ihmc.scs2.simulation.robot.controller.RobotControllerManager;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimCrossFourBarJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFixedJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPlanarJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimPrismaticJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRevoluteJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRigidBody;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSphericalJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class Robot
implements RobotInterface {
    public static final JointBuilderFromDefinition DEFAULT_JOINT_BUILDER = new JointBuilderFromDefinition(){};
    public static final RigidBodyBuilderFromDefinition DEFAULT_BODY_BUILDER = new RigidBodyBuilderFromDefinition(){};
    protected final YoRegistry registry;
    protected final RobotDefinition robotDefinition;
    protected final String name;
    protected final SimRigidBody rootBody;
    protected final ReferenceFrame inertialFrame;
    protected final ReferenceFrame robotRootFrame;
    protected final List<SimJointBasics> allJoints;
    protected final List<SimRigidBodyBasics> allRigidBodies;
    protected final List<SimJointBasics> jointsToIgnore;
    protected final List<SimJointBasics> jointsToConsider;
    protected final Map<String, SimJointBasics> nameToJointMap;
    protected final Map<String, SimRigidBodyBasics> nameToBodyMap;
    protected final JointMatrixIndexProvider jointMatrixIndexProvider;
    protected final List<JointStateReadOnly> allJointInitialStates;
    protected final RobotControllerManager controllerManager;

    public Robot(RobotDefinition robotDefinition, ReferenceFrame inertialFrame) {
        this(robotDefinition, inertialFrame, true);
    }

    public Robot(RobotDefinition robotDefinition, ReferenceFrame inertialFrame, boolean loadControllers) {
        this.robotDefinition = robotDefinition;
        this.inertialFrame = inertialFrame;
        this.robotRootFrame = Robot.createRobotRootFrame(robotDefinition, inertialFrame);
        this.name = robotDefinition.getName();
        this.registry = new YoRegistry(this.name);
        this.rootBody = Robot.createRobot(robotDefinition.getRootBodyDefinition(), this.robotRootFrame, DEFAULT_JOINT_BUILDER, DEFAULT_BODY_BUILDER, this.registry);
        this.allJoints = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)this.rootBody).collect(Collectors.toList());
        this.allRigidBodies = new ArrayList<SimRigidBody>(this.rootBody.subtreeList());
        this.nameToJointMap = this.allJoints.stream().collect(Collectors.toMap(JointReadOnly::getName, Function.identity()));
        this.nameToBodyMap = this.allRigidBodies.stream().collect(Collectors.toMap(RigidBodyReadOnly::getName, Function.identity()));
        this.jointsToIgnore = robotDefinition.getNameOfJointsToIgnore().stream().map(this.nameToJointMap::get).collect(Collectors.toList());
        this.jointsToConsider = this.allJoints.stream().filter(joint -> !this.jointsToIgnore.contains(joint)).collect(Collectors.toList());
        this.jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(this.getJointsToConsider());
        this.allJointInitialStates = this.allJoints.stream().map(joint -> robotDefinition.getJointDefinition(joint.getName()).getInitialJointState()).collect(Collectors.toList());
        this.controllerManager = new RobotControllerManager(this, this.registry);
        if (loadControllers) {
            Robot.createSoftConstraintControllerDefinitions(robotDefinition).forEach(this.controllerManager::addController);
            robotDefinition.getControllerDefinitions().forEach(this.controllerManager::addController);
        }
    }

    public static ReferenceFrame createRobotRootFrame(RobotDefinition robotDefinition, ReferenceFrame inertialFrame) {
        return MovingReferenceFrame.constructFrameFixedInParent((String)(robotDefinition.getName() + "RootFrame"), (ReferenceFrame)inertialFrame, (RigidBodyTransformReadOnly)new RigidBodyTransform());
    }

    public static SimRigidBody createRobot(RigidBodyDefinition rootBodyDefinition, ReferenceFrame inertialFrame, JointBuilderFromDefinition jointBuilder, RigidBodyBuilderFromDefinition bodyBuilder, YoRegistry registry) {
        SimRigidBody rootBody = bodyBuilder.rootFromDefinition(rootBodyDefinition, inertialFrame, registry);
        Robot.createJointsRecursive(rootBody, rootBodyDefinition, jointBuilder, bodyBuilder, registry);
        RobotDefinition.closeLoops((RigidBodyBasics)rootBody, (RigidBodyDefinition)rootBodyDefinition);
        return rootBody;
    }

    public static void createJointsRecursive(SimRigidBody rigidBody, RigidBodyDefinition rigidBodyDefinition, JointBuilderFromDefinition jointBuilder, RigidBodyBuilderFromDefinition bodyBuilder, YoRegistry registry) {
        for (JointDefinition childJointDefinition : rigidBodyDefinition.getChildrenJoints()) {
            SimJointBasics childJoint = jointBuilder.fromDefinition(childJointDefinition, rigidBody);
            if (childJointDefinition.isLoopClosure()) continue;
            SimRigidBody childSuccessor = bodyBuilder.fromDefinition(childJointDefinition.getSuccessor(), childJoint);
            childJointDefinition.getKinematicPointDefinitions().forEach(childJoint.getAuxiliaryData()::addKinematicPoint);
            childJointDefinition.getExternalWrenchPointDefinitions().forEach(childJoint.getAuxiliaryData()::addExternalWrenchPoint);
            childJointDefinition.getGroundContactPointDefinitions().forEach(childJoint.getAuxiliaryData()::addGroundContactPoint);
            for (SensorDefinition sensorDefinition : childJointDefinition.getSensorDefinitions()) {
                if (sensorDefinition instanceof IMUSensorDefinition) {
                    childJoint.getAuxiliaryData().addIMUSensor((IMUSensorDefinition)sensorDefinition);
                    continue;
                }
                if (sensorDefinition instanceof WrenchSensorDefinition) {
                    childJoint.getAuxiliaryData().addWrenchSensor((WrenchSensorDefinition)sensorDefinition);
                    continue;
                }
                if (sensorDefinition instanceof CameraSensorDefinition) {
                    childJoint.getAuxiliaryData().addCameraSensor((CameraSensorDefinition)sensorDefinition);
                    continue;
                }
                LogTools.warn((String)("Unsupported sensor: " + sensorDefinition));
            }
            Robot.createJointsRecursive(childSuccessor, childJointDefinition.getSuccessor(), jointBuilder, bodyBuilder, registry);
        }
    }

    public static List<ControllerDefinition> createSoftConstraintControllerDefinitions(RobotDefinition robotDefinition) {
        ArrayList<ControllerDefinition> controllerDefinitions = new ArrayList<ControllerDefinition>();
        for (JointDefinition jointDefinition : robotDefinition.getAllJoints()) {
            if (!jointDefinition.isLoopClosure()) continue;
            controllerDefinitions.add((controllerInput, controllerOutput) -> {
                String name = jointDefinition.getName();
                LoopClosureDefinition loopClosureDefinition = jointDefinition.getLoopClosureDefinition();
                YawPitchRollTransformDefinition transformToParentJoint = jointDefinition.getTransformToParent();
                YawPitchRollTransformDefinition transformToSuccessorParentJoint = loopClosureDefinition.getTransformToSuccessorParent();
                Matrix3D constraintForceSubSpace = LoopClosureDefinition.jointForceSubSpace((JointDefinition)jointDefinition);
                Matrix3D constraintMomentSubSpace = LoopClosureDefinition.jointMomentSubSpace((JointDefinition)jointDefinition);
                if (constraintForceSubSpace == null || constraintMomentSubSpace == null) {
                    throw new UnsupportedOperationException("Loop closure not supported for " + jointDefinition);
                }
                LoopClosureSoftConstraintController constraint = new LoopClosureSoftConstraintController(name, (RigidBodyTransformReadOnly)transformToParentJoint, (RigidBodyTransformReadOnly)transformToSuccessorParentJoint, (Matrix3DReadOnly)constraintForceSubSpace, (Matrix3DReadOnly)constraintMomentSubSpace);
                constraint.setParentJoint((SimJointBasics)controllerInput.getInput().findJoint(jointDefinition.getParentJoint().getName()));
                constraint.setSuccessor((SimRigidBodyBasics)controllerInput.getInput().findRigidBody(jointDefinition.getSuccessor().getName()));
                constraint.setGains((Tuple3DReadOnly)loopClosureDefinition.getKpSoftConstraint(), (Tuple3DReadOnly)loopClosureDefinition.getKdSoftConstraint());
                return constraint;
            });
        }
        return controllerDefinitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RobotDefinition getRobotDefinition() {
        return this.robotDefinition;
    }

    @Override
    public RobotControllerManager getControllerManager() {
        return this.controllerManager;
    }

    @Override
    public void initializeState() {
        for (int i = 0; i < this.allJoints.size(); ++i) {
            SimJointBasics jointToUpdate = this.allJoints.get(i);
            JointStateReadOnly initialState = this.allJointInitialStates.get(i);
            if (initialState == null) continue;
            initialState.getAllStates((JointBasics)jointToUpdate);
        }
        this.rootBody.updateFramesRecursively();
    }

    @Override
    public SimRigidBodyBasics getRootBody() {
        return this.rootBody;
    }

    @Override
    public SimRigidBodyBasics getRigidBody(String name) {
        return this.nameToBodyMap.get(name);
    }

    @Override
    public SimJointBasics getJoint(String name) {
        return this.nameToJointMap.get(name);
    }

    @Override
    public List<? extends SimJointBasics> getAllJoints() {
        return this.allJoints;
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public JointMatrixIndexProvider getJointMatrixIndexProvider() {
        return this.jointMatrixIndexProvider;
    }

    @Override
    public List<? extends SimJointBasics> getJointsToConsider() {
        return this.jointsToConsider;
    }

    @Override
    public List<? extends SimJointBasics> getJointsToIgnore() {
        return this.jointsToIgnore;
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    public RobotStateDefinition getCurrentRobotStateDefinition() {
        RobotStateDefinition definition = new RobotStateDefinition();
        definition.setRobotName(this.name);
        ArrayList<RobotStateDefinition.JointStateEntry> jointStateEntries = new ArrayList<RobotStateDefinition.JointStateEntry>();
        for (JointReadOnly jointReadOnly : this.rootBody.childrenSubtreeIterable()) {
            jointStateEntries.add(new RobotStateDefinition.JointStateEntry(jointReadOnly.getName(), (JointStateBasics)Robot.extractJointState(jointReadOnly)));
        }
        definition.setJointStateEntries(jointStateEntries);
        return definition;
    }

    private static JointStateBase extractJointState(JointReadOnly joint) {
        if (joint == null) {
            return null;
        }
        Object state = joint instanceof OneDoFJointReadOnly ? new OneDoFJointState() : (joint instanceof SixDoFJointReadOnly ? new SixDoFJointState() : (joint instanceof SphericalJointReadOnly ? new SphericalJointState() : (joint instanceof PlanarJointReadOnly ? new PlanarJointState() : new JointState(joint.getConfigurationMatrixSize(), joint.getDegreesOfFreedom()))));
        state.setConfiguration(joint);
        state.setVelocity(joint);
        state.setAcceleration(joint);
        state.setEffort(joint);
        return state;
    }

    public static interface JointBuilderFromDefinition {
        default public SimJointBasics fromDefinition(JointDefinition definition, SimRigidBody predecessor) {
            if (definition instanceof FixedJointDefinition) {
                return new SimFixedJoint((FixedJointDefinition)definition, (SimRigidBodyBasics)predecessor);
            }
            if (definition instanceof PlanarJointDefinition) {
                return new SimPlanarJoint((PlanarJointDefinition)definition, (SimRigidBodyBasics)predecessor);
            }
            if (definition instanceof SixDoFJointDefinition) {
                if (definition.getParentJoint() == null) {
                    return new SimFloatingRootJoint((SixDoFJointDefinition)definition, (SimRigidBodyBasics)predecessor);
                }
                return new SimSixDoFJoint((SixDoFJointDefinition)definition, (SimRigidBodyBasics)predecessor);
            }
            if (definition instanceof PrismaticJointDefinition) {
                return new SimPrismaticJoint((PrismaticJointDefinition)definition, predecessor);
            }
            if (definition instanceof RevoluteJointDefinition) {
                return new SimRevoluteJoint((RevoluteJointDefinition)definition, predecessor);
            }
            if (definition instanceof SphericalJointDefinition) {
                return new SimSphericalJoint((SphericalJointDefinition)definition, predecessor);
            }
            if (definition instanceof CrossFourBarJointDefinition) {
                return new SimCrossFourBarJoint((CrossFourBarJointDefinition)definition, predecessor);
            }
            throw new UnsupportedOperationException("Unsupported joint definition: " + definition.getClass().getSimpleName());
        }
    }

    public static interface RigidBodyBuilderFromDefinition {
        default public SimRigidBody rootFromDefinition(RigidBodyDefinition rootBodyDefinition, ReferenceFrame inertialFrame, YoRegistry registry) {
            return new SimRigidBody(rootBodyDefinition, inertialFrame, registry);
        }

        default public SimRigidBody fromDefinition(RigidBodyDefinition rigidBodyDefinition, SimJointBasics parentJoint) {
            return new SimRigidBody(rigidBodyDefinition, parentJoint);
        }
    }
}

