/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimMultiBodySystemReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemFactories;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface SimMultiBodySystemBasics
extends MultiBodySystemBasics,
SimMultiBodySystemReadOnly {
    @Override
    public YoRegistry getRegistry();

    @Override
    public SimRigidBodyBasics getRootBody();

    default public SimFloatingJointBasics getFloatingRootJoint() {
        if (this.getRootBody() == null || this.getRootBody().getChildrenJoints().isEmpty()) {
            return null;
        }
        JointBasics rootJoint = (JointBasics)this.getRootBody().getChildrenJoints().get(0);
        if (rootJoint instanceof SimFloatingJointBasics) {
            return (SimFloatingJointBasics)rootJoint;
        }
        return null;
    }

    default public List<? extends SimJointBasics> getAllJoints() {
        return SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)this.getRootBody()).collect(Collectors.toList());
    }

    default public List<? extends SimJointBasics> getJointsToConsider() {
        return this.getAllJoints();
    }

    default public List<? extends SimJointBasics> getJointsToIgnore() {
        return this.getAllJoints().stream().filter(joint -> !this.getJointsToConsider().contains(joint)).collect(Collectors.toList());
    }

    @Override
    default public SimJointBasics findJoint(String jointName) {
        return (SimJointBasics)super.findJoint(jointName);
    }

    @Override
    default public SimRigidBodyBasics findRigidBody(String rigidBodyName) {
        return (SimRigidBodyBasics)super.findRigidBody(rigidBodyName);
    }

    public static SimMultiBodySystemBasics toMultiBodySystemInput(SimRigidBodyBasics rootBody) {
        return SimMultiBodySystemBasics.toMultiBodySystemInput(rootBody, Collections.emptyList());
    }

    public static SimMultiBodySystemBasics toMultiBodySystemInput(SimRigidBodyBasics rootBody, SimJointBasics[] jointsToIgnore) {
        return SimMultiBodySystemBasics.toMultiBodySystemInput(rootBody, Arrays.asList(jointsToIgnore));
    }

    public static SimMultiBodySystemBasics toMultiBodySystemInput(final SimRigidBodyBasics rootBody, final List<? extends SimJointBasics> jointsToIgnore) {
        final List allJoints = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)rootBody).collect(Collectors.toList());
        final List<? extends SimJointBasics> jointsToConsider = SimMultiBodySystemBasics.extractJointsToConsider(rootBody, jointsToIgnore);
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new SimMultiBodySystemBasics(){

            @Override
            public YoRegistry getRegistry() {
                return rootBody.getRegistry();
            }

            @Override
            public SimRigidBodyBasics getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends SimJointBasics> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends SimJointBasics> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends SimJointBasics> getJointsToIgnore() {
                return jointsToIgnore;
            }

            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static SimMultiBodySystemBasics toMultiBodySystemBasics(SimJointBasics[] jointsToConsider) {
        return SimMultiBodySystemBasics.toMultiBodySystemInput(Arrays.asList(jointsToConsider));
    }

    public static SimMultiBodySystemBasics toMultiBodySystemInput(final List<? extends SimJointBasics> jointsToConsider) {
        final SimRigidBodyBasics rootBody = (SimRigidBodyBasics)MultiBodySystemReadOnly.getClosestJointToRoot(jointsToConsider).getPredecessor();
        final List allJoints = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)rootBody).collect(Collectors.toList());
        final List jointsToIgnore = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)rootBody).filter(joint -> !jointsToConsider.contains(joint)).collect(Collectors.toList());
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new SimMultiBodySystemBasics(){

            @Override
            public YoRegistry getRegistry() {
                return rootBody.getRegistry();
            }

            @Override
            public SimRigidBodyBasics getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends SimJointBasics> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends SimJointBasics> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends SimJointBasics> getJointsToIgnore() {
                return jointsToIgnore;
            }

            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static List<? extends SimJointBasics> extractJointsToConsider(SimRigidBodyBasics rootBody, List<? extends SimJointBasics> jointsToIgnore) {
        return SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)rootBody).filter(candidate -> !MultiBodySystemReadOnly.isJointToBeIgnored((JointReadOnly)candidate, (List)jointsToIgnore)).collect(Collectors.toList());
    }

    public static SimMultiBodySystemBasics clone(MultiBodySystemReadOnly original, ReferenceFrame cloneRootFrame, YoRegistry cloneRegistry) {
        SimRigidBodyBasics cloneRootBody = (SimRigidBodyBasics)MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)original.getRootBody(), (ReferenceFrame)cloneRootFrame, (String)"", (MultiBodySystemFactories.RigidBodyBuilder)new SimMultiBodySystemFactories.SimRigidBodyBuilder(cloneRegistry), (MultiBodySystemFactories.JointBuilder)new SimMultiBodySystemFactories.SimJointBuilder());
        Set namesOfJointsToConsider = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)original.getRootBody()).map(JointReadOnly::getName).collect(Collectors.toSet());
        List jointsToConsider = SubtreeStreams.fromChildren(SimJointBasics.class, (RigidBodyReadOnly)cloneRootBody).filter(joint -> namesOfJointsToConsider.contains(joint.getName())).collect(Collectors.toList());
        return SimMultiBodySystemBasics.toMultiBodySystemInput(jointsToConsider);
    }
}

