/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import us.ihmc.euclid.tools.EuclidCoreTools;

public class ContactImpulseTools {
    public static DMatrixRMaj cross(DMatrixRMaj v1, DMatrixRMaj v2) {
        DMatrixRMaj cross = new DMatrixRMaj(3, 1);
        ContactImpulseTools.cross(v1, v2, cross);
        return cross;
    }

    public static void cross(DMatrixRMaj v1, DMatrixRMaj v2, DMatrixRMaj crossToPack) {
        if (!MatrixFeatures_DDRM.isVector((Matrix)v1) || v1.getNumElements() != 3) {
            throw new IllegalArgumentException("Improper argument");
        }
        if (!MatrixFeatures_DDRM.isVector((Matrix)v2) || v2.getNumElements() != 3) {
            throw new IllegalArgumentException("Improper argument");
        }
        double x = v1.get(1) * v2.get(2) - v1.get(2) * v2.get(1);
        double y = v1.get(2) * v2.get(0) - v1.get(0) * v2.get(2);
        double z = v1.get(0) * v2.get(1) - v1.get(1) * v2.get(0);
        crossToPack.reshape(3, 1);
        crossToPack.set(0, x);
        crossToPack.set(1, y);
        crossToPack.set(2, z);
    }

    public static void scaleAdd(double scale, DMatrix3 a, DMatrix3 b, DMatrix3 c) {
        double c1 = scale * a.a1 + b.a1;
        double c2 = scale * a.a2 + b.a2;
        double c3 = scale * a.a3 + b.a3;
        c.set(c1, c2, c3);
    }

    public static DMatrixRMaj invert(DMatrixRMaj M) {
        DMatrixRMaj M_inv = new DMatrixRMaj(M.getNumCols(), M.getNumRows());
        CommonOps_DDRM.invert((DMatrixRMaj)M, (DMatrixRMaj)M_inv);
        return M_inv;
    }

    public static double multQuad(DMatrixRMaj x, DMatrixRMaj H) {
        if (!MatrixFeatures_DDRM.isVector((Matrix)x)) {
            throw new IllegalArgumentException("x is not a vector.");
        }
        if (x.getNumRows() != H.getNumRows()) {
            throw new IllegalArgumentException("x and H are not compatible.");
        }
        if (!MatrixFeatures_DDRM.isSquare((DMatrixD1)H)) {
            throw new IllegalArgumentException("H is not square.");
        }
        double result = 0.0;
        for (int row = 0; row < H.getNumRows(); ++row) {
            double rowValue = 0.0;
            for (int col = 0; col < H.getNumCols(); ++col) {
                rowValue += H.unsafe_get(row, col) * x.get(col);
            }
            result += x.get(row) * rowValue;
        }
        return result;
    }

    public static DMatrixRMaj addMult(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c) {
        DMatrixRMaj d = new DMatrixRMaj(b.getNumRows(), c.getNumCols());
        ContactImpulseTools.addMult(a, b, c, d);
        return d;
    }

    public static void addMult(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj d) {
        CommonOps_DDRM.mult((DMatrix1Row)b, (DMatrix1Row)c, (DMatrix1Row)d);
        CommonOps_DDRM.addEquals((DMatrixD1)d, (DMatrixD1)a);
    }

    public static DMatrixRMaj negateMult(DMatrixRMaj a, DMatrixRMaj b) {
        DMatrixRMaj c = new DMatrixRMaj(a.getNumRows(), b.getNumCols());
        ContactImpulseTools.negateMult(a, b, c);
        return c;
    }

    public static void negateMult(DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c) {
        CommonOps_DDRM.mult((DMatrix1Row)a, (DMatrix1Row)b, (DMatrix1Row)c);
        CommonOps_DDRM.changeSign((DMatrixD1)c);
    }

    public static void extract(DMatrix source, int startRow, int startColumn, DMatrix3x3 destination) {
        EuclidCoreTools.checkMatrixMinimumSize((int)(startRow + 3), (int)(startColumn + 3), (Matrix)source);
        destination.a11 = source.unsafe_get(startRow, startColumn);
        destination.a12 = source.unsafe_get(startRow, startColumn + 1);
        destination.a13 = source.unsafe_get(startRow++, startColumn + 2);
        destination.a21 = source.unsafe_get(startRow, startColumn);
        destination.a22 = source.unsafe_get(startRow, startColumn + 1);
        destination.a23 = source.unsafe_get(startRow++, startColumn + 2);
        destination.a31 = source.unsafe_get(startRow, startColumn);
        destination.a32 = source.unsafe_get(startRow, startColumn + 1);
        destination.a33 = source.unsafe_get(startRow, startColumn + 2);
    }

    public static double computeR(double mu, double theta, DMatrixRMaj M_inv, DMatrixRMaj c) {
        return ContactImpulseTools.computeR(mu, Math.cos(theta), Math.sin(theta), (DMatrix)M_inv, (DMatrix)c);
    }

    public static double computeR(double mu, double cosTheta, double sinTheta, DMatrix M_inv, DMatrix c) {
        double r = M_inv.unsafe_get(2, 2) / mu + M_inv.unsafe_get(2, 0) * cosTheta + M_inv.unsafe_get(2, 1) * sinTheta;
        r = -c.unsafe_get(2, 0) / r;
        return r;
    }

    public static double computeLambdaZ(double r, double theta, DMatrix M_inv, DMatrix c) {
        return ContactImpulseTools.computeLambdaZ(r, Math.cos(theta), Math.sin(theta), M_inv, c);
    }

    public static double computeLambdaZ(double r, double cosTheta, double sinTheta, DMatrix M_inv, DMatrix c) {
        return -(c.unsafe_get(2, 0) + r * (M_inv.unsafe_get(2, 0) * cosTheta + M_inv.unsafe_get(2, 1) * sinTheta)) / M_inv.unsafe_get(2, 2);
    }

    public static DMatrixRMaj computePostImpulseVelocity(DMatrixRMaj c, DMatrixRMaj M_inv, DMatrixRMaj lambda) {
        return ContactImpulseTools.addMult(c, M_inv, lambda);
    }

    public static double computeE1(DMatrixRMaj v, DMatrixRMaj M) {
        return 0.5 * ContactImpulseTools.multQuad(v, M);
    }

    public static double computeE2(DMatrixRMaj M_inv, DMatrixRMaj c, DMatrixRMaj lambda) {
        return 0.5 * ContactImpulseTools.multQuad(lambda, M_inv) + CommonOps_DDRM.dot((DMatrixD1)lambda, (DMatrixD1)c);
    }

    public static double computeE3(DMatrixRMaj M, DMatrixRMaj M_inv, DMatrixRMaj c, DMatrixRMaj lambda) {
        return ContactImpulseTools.computeE2(M_inv, c, lambda) + 0.5 * ContactImpulseTools.multQuad(c, M);
    }

    public static DMatrixRMaj nablaH1(DMatrixRMaj M_inv) {
        DMatrixRMaj nablaH1 = new DMatrixRMaj(3, 1);
        nablaH1.set(0, M_inv.get(2, 0));
        nablaH1.set(1, M_inv.get(2, 1));
        nablaH1.set(2, M_inv.get(2, 2));
        return nablaH1;
    }

    public static DMatrixRMaj nablaH2(DMatrixRMaj lambda, double mu) {
        DMatrixRMaj nablaH2 = new DMatrixRMaj(3, 1);
        nablaH2.set(0, 2.0 * lambda.get(0));
        nablaH2.set(1, 2.0 * lambda.get(1));
        nablaH2.set(2, -2.0 * mu * mu * lambda.get(2));
        return nablaH2;
    }

    public static DMatrixRMaj eta(DMatrixRMaj M_inv, DMatrixRMaj lambda, double mu) {
        DMatrixRMaj nablaH1 = ContactImpulseTools.nablaH1(M_inv);
        DMatrixRMaj nablaH2 = ContactImpulseTools.nablaH2(lambda, mu);
        DMatrixRMaj eta = ContactImpulseTools.cross(nablaH1, nablaH2);
        NormOps_DDRM.normalizeF((DMatrixRMaj)eta);
        return eta;
    }

    public static double computeProjectedGradient(double mu, DMatrixRMaj M_inv, DMatrixRMaj c, DMatrixRMaj lambda) {
        return ContactImpulseTools.computeProjectedGradient(mu, M_inv, c, EuclidCoreTools.norm((double)lambda.get(0), (double)lambda.get(1)), Math.atan2(lambda.get(1), lambda.get(0)));
    }

    public static double computeProjectedGradient(double mu, DMatrixRMaj M_inv, DMatrixRMaj c, double theta) {
        return ContactImpulseTools.computeProjectedGradient(mu, M_inv, c, ContactImpulseTools.computeR(mu, theta, M_inv, c), theta);
    }

    public static double computeProjectedGradient(double mu, DMatrixRMaj M_inv, DMatrixRMaj c, double r, double theta) {
        return ContactImpulseTools.computeProjectedGradient(mu, (DMatrix)M_inv, (DMatrix)c, r, Math.cos(theta), Math.sin(theta));
    }

    public static double computeProjectedGradient(double mu, DMatrix M_inv, DMatrix c, double r, double cosTheta, double sinTheta) {
        double nablaH1_x = M_inv.unsafe_get(2, 0);
        double nablaH1_y = M_inv.unsafe_get(2, 1);
        double nablaH1_z = M_inv.unsafe_get(2, 2);
        double nablaH2_x = cosTheta;
        double nablaH2_y = sinTheta;
        double nablaH2_z = -mu;
        double eta_x = nablaH1_y * nablaH2_z - nablaH1_z * nablaH2_y;
        double eta_y = nablaH1_z * nablaH2_x - nablaH1_x * nablaH2_z;
        double eta_z = nablaH1_x * nablaH2_y - nablaH1_y * nablaH2_x;
        double r_inv = 1.0 / r;
        double c_x = c.unsafe_get(0, 0) * r_inv;
        double c_y = c.unsafe_get(1, 0) * r_inv;
        double c_z = c.unsafe_get(2, 0) * r_inv;
        double lambda_z_prime = (M_inv.unsafe_get(2, 0) * cosTheta + M_inv.unsafe_get(2, 1) * sinTheta + c_z) / M_inv.unsafe_get(2, 2);
        double dE_dLambda_0 = M_inv.unsafe_get(0, 0) * cosTheta + M_inv.unsafe_get(0, 1) * sinTheta + c_x - M_inv.unsafe_get(0, 2) * lambda_z_prime;
        double dE_dLambda_1 = M_inv.unsafe_get(1, 0) * cosTheta + M_inv.unsafe_get(1, 1) * sinTheta + c_y - M_inv.unsafe_get(1, 2) * lambda_z_prime;
        double dE_dLambda_2 = M_inv.unsafe_get(2, 0) * cosTheta + M_inv.unsafe_get(2, 1) * sinTheta + c_z - M_inv.unsafe_get(2, 2) * lambda_z_prime;
        return dE_dLambda_0 * eta_x + dE_dLambda_1 * eta_y + dE_dLambda_2 * eta_z;
    }

    public static double computeProjectedGradientInefficient(DMatrixRMaj M_inv, DMatrixRMaj lambda, DMatrixRMaj c, double mu) {
        DMatrixRMaj gradient = ContactImpulseTools.addMult(c, M_inv, lambda);
        DMatrixRMaj eta = ContactImpulseTools.eta(M_inv, lambda, mu);
        return CommonOps_DDRM.dot((DMatrixD1)gradient, (DMatrixD1)eta);
    }

    public static double computeEThetaNumericalDerivative(double theta, double dtheta, double mu, DMatrixRMaj M_inv, DMatrixRMaj c) {
        double costMinus = ContactImpulseTools.computeE2(M_inv, c, ContactImpulseTools.computeLambda(theta - 0.5 * dtheta, mu, M_inv, c));
        double costPlus = ContactImpulseTools.computeE2(M_inv, c, ContactImpulseTools.computeLambda(theta + 0.5 * dtheta, mu, M_inv, c));
        return (costPlus - costMinus) / dtheta;
    }

    public static DMatrixRMaj computeLambda(double theta, double mu, DMatrixRMaj M_inv, DMatrixRMaj c) {
        return ContactImpulseTools.computeLambda(theta, ContactImpulseTools.computeR(mu, theta, M_inv, c), mu, M_inv, c);
    }

    public static DMatrixRMaj computeLambda(double theta, double r, double mu, DMatrixRMaj M_inv, DMatrixRMaj c) {
        DMatrixRMaj lambda = new DMatrixRMaj(3, 1);
        lambda.set(0, r * Math.cos(theta));
        lambda.set(1, r * Math.sin(theta));
        lambda.set(2, ContactImpulseTools.computeLambdaZ(r, theta, (DMatrix)M_inv, (DMatrix)c));
        return lambda;
    }

    public static boolean isInsideFrictionCone(double mu, DMatrix lambda) {
        return ContactImpulseTools.isInsideFrictionCone(mu, lambda, 0.0);
    }

    public static boolean isInsideFrictionCone(double mu, DMatrix lambda, double epsilon) {
        return ContactImpulseTools.isInsideFrictionCone(mu, lambda.unsafe_get(0, 0), lambda.unsafe_get(1, 0), lambda.unsafe_get(2, 0), epsilon);
    }

    public static boolean isInsideFrictionCone(double mu, double lambda_x, double lambda_y, double lambda_z, double epsilon) {
        return EuclidCoreTools.square((double)(mu * lambda_z)) + epsilon >= EuclidCoreTools.normSquared((double)lambda_x, (double)lambda_y);
    }

    public static boolean isInsideFrictionEllipsoid(double mu, DMatrix lambda, double e_zz) {
        return ContactImpulseTools.isInsideFrictionEllipsoid(mu, lambda.unsafe_get(0, 0), lambda.unsafe_get(1, 0), lambda.unsafe_get(2, 0), lambda.unsafe_get(3, 0), e_zz);
    }

    public static boolean isInsideFrictionEllipsoid(double mu, DMatrix3 lambda_linear, double lambda_angular, double e_zz) {
        return ContactImpulseTools.isInsideFrictionEllipsoid(mu, lambda_linear, lambda_angular, e_zz, 0.0);
    }

    public static boolean isInsideFrictionEllipsoid(double mu, DMatrix3 lambda_linear, double lambda_angular, double e_zz, double epsilon) {
        return ContactImpulseTools.isInsideFrictionEllipsoid(mu, lambda_linear.a1, lambda_linear.a2, lambda_linear.a3, lambda_angular, e_zz, epsilon);
    }

    public static boolean isInsideFrictionEllipsoid(double mu, double lambda_x, double lambda_y, double lambda_z, double lambda_zz, double e_zz) {
        return ContactImpulseTools.isInsideFrictionEllipsoid(mu, lambda_x, lambda_y, lambda_z, lambda_zz, e_zz, 0.0);
    }

    public static boolean isInsideFrictionEllipsoid(double mu, double lambda_x, double lambda_y, double lambda_z, double lambda_zz, double e_zz, double epsilon) {
        return EuclidCoreTools.square((double)(mu * lambda_z)) + epsilon >= EuclidCoreTools.normSquared((double)lambda_x, (double)lambda_y, (double)(lambda_zz / e_zz));
    }

    public static boolean lineOfSightTest(double mu, DMatrix lambda, DMatrix lambda_v_0) {
        double theta = Math.atan2(lambda.unsafe_get(1, 0), lambda.unsafe_get(0, 0));
        return ContactImpulseTools.lineOfSightTest(mu, EuclidCoreTools.norm((double)lambda.unsafe_get(0, 0), (double)lambda.unsafe_get(1, 0)), Math.cos(theta), Math.sin(theta), lambda_v_0);
    }

    public static boolean lineOfSightTest(double mu, double r, double cosTheta, double sinTheta, DMatrix lambda_v_0) {
        return cosTheta * lambda_v_0.unsafe_get(0, 0) + sinTheta * lambda_v_0.unsafe_get(1, 0) - mu * lambda_v_0.unsafe_get(2, 0) > 0.0;
    }

    public static DMatrixRMaj computeSlipLambda(double beta1, double beta2, double beta3, double gamma, double mu, DMatrix M_inv, DMatrix lambda_v_0, DMatrix c, boolean verbose) {
        DMatrixRMaj lambdaOptMatrix = new DMatrixRMaj(3, 1);
        ContactImpulseTools.computeSlipLambda(beta1, beta2, beta3, gamma, mu, M_inv, lambda_v_0, c, (DMatrix)lambdaOptMatrix, verbose);
        return lambdaOptMatrix;
    }

    public static void computeSlipLambda(double beta1, double beta2, double beta3, double gamma, double mu, DMatrix M_inv, DMatrix lambda_v_0, DMatrix c, DMatrix lambdaToPack, boolean verbose) {
        double sinThetaMid;
        double cosThetaMid;
        double rMid;
        block12: {
            double thetaHi0;
            int iteration;
            double gradient_v_0;
            double thetaLo0;
            block11: {
                thetaLo0 = Math.atan2(lambda_v_0.unsafe_get(1, 0), lambda_v_0.unsafe_get(0, 0));
                double cosTheta = Math.cos(thetaLo0);
                double sinTheta = Math.sin(thetaLo0);
                double rLo0 = ContactImpulseTools.computeR(mu, cosTheta, sinTheta, M_inv, c);
                gradient_v_0 = ContactImpulseTools.computeProjectedGradient(mu, M_inv, c, rLo0, cosTheta, sinTheta);
                double alpha = -beta1 * Math.signum(gradient_v_0);
                iteration = 0;
                if (verbose) {
                    System.out.println("Initial stepping, theta 0: " + thetaLo0);
                }
                do {
                    thetaHi0 = thetaLo0;
                    double rHi0 = rLo0;
                    thetaLo0 += alpha;
                    if (verbose) {
                        System.out.println("Stepping theta " + thetaLo0);
                    }
                    if ((rLo0 = ContactImpulseTools.computeR(mu, cosTheta = Math.cos(thetaLo0), sinTheta = Math.sin(thetaLo0), M_inv, c)) < 0.0) {
                        alpha = beta2 * alpha;
                        if (verbose) {
                            System.out.println("r negative: " + rLo0 + ", alpha " + alpha);
                        }
                        thetaLo0 = thetaHi0;
                        rLo0 = rHi0;
                        continue;
                    }
                    if (ContactImpulseTools.computeLambdaZ(rLo0, cosTheta, sinTheta, M_inv, c) < 0.0) {
                        System.err.println(ContactImpulseTools.toStringForUnitTest(beta1, beta2, beta3, gamma, mu, M_inv, lambda_v_0, c));
                        throw new IllegalStateException("Malformed impule");
                    }
                    if (!ContactImpulseTools.lineOfSightTest(mu, rLo0, cosTheta, sinTheta, lambda_v_0)) {
                        alpha *= beta2;
                        thetaLo0 = thetaHi0;
                        rLo0 = rHi0;
                        if (!verbose) continue;
                        System.out.println("out of line-of-sight, alpha " + alpha);
                        continue;
                    }
                    double gradientLo0 = ContactImpulseTools.computeProjectedGradient(mu, M_inv, c, rLo0, cosTheta, sinTheta);
                    if (verbose) {
                        System.out.println("Gradient " + gradientLo0 + " (D0=" + gradient_v_0 + ")");
                    }
                    if (!(gradientLo0 * gradient_v_0 > 0.0)) break block11;
                    alpha *= beta3;
                    if (!verbose) continue;
                    System.out.println("same sign gradient, alpha " + alpha);
                } while (++iteration <= 1000);
                System.err.println(ContactImpulseTools.toStringForUnitTest(beta1, beta2, beta3, gamma, mu, M_inv, lambda_v_0, c));
                throw new IllegalStateException("Unable to converge during initialization of the bisection");
            }
            double thetaLo = thetaLo0;
            double thetaHi = thetaHi0;
            iteration = 0;
            do {
                double thetaMid;
                double gradientMid;
                if ((gradientMid = ContactImpulseTools.computeProjectedGradient(mu, M_inv, c, rMid = ContactImpulseTools.computeR(mu, cosThetaMid = Math.cos(thetaMid = 0.5 * (thetaLo + thetaHi)), sinThetaMid = Math.sin(thetaMid), M_inv, c), cosThetaMid, sinThetaMid)) * gradient_v_0 > 0.0) {
                    thetaHi = thetaMid;
                } else {
                    thetaLo = thetaMid;
                }
                if (Math.abs(thetaLo - thetaHi) < gamma) break block12;
            } while (++iteration <= 1000);
            System.err.println(ContactImpulseTools.toStringForUnitTest(beta1, beta2, beta3, gamma, mu, M_inv, lambda_v_0, c));
            throw new IllegalStateException("Unable to converge during bisection");
        }
        lambdaToPack.unsafe_set(0, 0, rMid * cosThetaMid);
        lambdaToPack.unsafe_set(1, 0, rMid * sinThetaMid);
        lambdaToPack.unsafe_set(2, 0, ContactImpulseTools.computeLambdaZ(rMid, cosThetaMid, sinThetaMid, M_inv, c));
    }

    public static String toStringForUnitTest(double beta1, double beta2, double beta3, double gamma, double mu, DMatrix M_inv, DMatrix lambda_v_0, DMatrix c) {
        return beta1 + ", " + beta2 + ", " + beta3 + ", " + gamma + ", " + mu + ", " + ContactImpulseTools.matrixToString(M_inv) + ", " + ContactImpulseTools.matrixToString(c);
    }

    private static String matrixToString(DMatrix m) {
        String ret = "new DMatrixRMaj(" + m.getNumRows() + ", " + m.getNumCols() + ", true";
        for (int row = 0; row < m.getNumRows(); ++row) {
            for (int col = 0; col < m.getNumCols(); ++col) {
                ret = ret + ", " + m.get(row, col);
            }
        }
        ret = ret + ")";
        return ret;
    }

    public static double cube(double value) {
        return value * value * value;
    }
}

