/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameShape3DPoseBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRampPolytope3DView;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DPoseReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeIOTools;
import us.ihmc.euclid.shape.primitives.interfaces.IntermediateVariableSupplier;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.simulation.shapes.STPShape3DTools;
import us.ihmc.scs2.simulation.shapes.interfaces.FrameSTPRamp3DBasics;
import us.ihmc.scs2.simulation.shapes.interfaces.FrameSTPRamp3DReadOnly;
import us.ihmc.scs2.simulation.shapes.interfaces.STPRamp3DReadOnly;

public class FrameSTPRamp3D
implements FrameSTPRamp3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final FrameRamp3D rawRamp3D = new FrameRamp3D();
    private final STPShape3DTools.STPRamp3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPRamp3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public FrameSTPRamp3D() {
        this(ReferenceFrame.getWorldFrame());
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame) {
        this(referenceFrame, 1.0, 1.0, 1.0);
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, double sizeX, double sizeY, double sizeZ) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set(sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Vector3DReadOnly size) {
        this.setReferenceFrame(referenceFrame);
        this.getSize().set((Tuple3DReadOnly)size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Point3DReadOnly position, Orientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(position, orientation, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, Vector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly size) {
        this.setIncludingFrame(position, orientation, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Pose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePose3DReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePose3DReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FramePose3DReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(referenceFrame, pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, RigidBodyTransformReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(referenceFrame, pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FrameShape3DPoseReadOnly pose, double sizeX, double sizeY, double sizeZ) {
        this.setIncludingFrame(pose, sizeX, sizeY, sizeZ);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FrameShape3DPoseReadOnly pose, Vector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FrameShape3DPoseReadOnly pose, FrameVector3DReadOnly size) {
        this.setIncludingFrame(pose, size);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, Ramp3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPRamp3D(ReferenceFrame referenceFrame, STPRamp3DReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FrameRamp3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    public FrameSTPRamp3D(FrameSTPRamp3DReadOnly other) {
        this.setIncludingFrame(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.rawRamp3D.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.rawRamp3D.getReferenceFrame();
    }

    public FixedFrameShape3DPoseBasics getPose() {
        return this.rawRamp3D.getPose();
    }

    public FixedFrameVector3DBasics getSize() {
        return this.rawRamp3D.getSize();
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeRamp3DMaximumEdgeLengthSquared((Vector3DReadOnly)this.getSize()));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex((Ramp3DReadOnly)this.rawRamp3D, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public FramePoint3DReadOnly getCentroid() {
        return this.rawRamp3D.getCentroid();
    }

    public FrameVector3DReadOnly getRampSurfaceNormal() {
        return this.rawRamp3D.getRampSurfaceNormal();
    }

    public void getRampSurfaceNormal(Vector3DBasics surfaceNormalToPack) {
        this.rawRamp3D.getRampSurfaceNormal(surfaceNormalToPack);
    }

    public void getRampSurfaceNormal(FixedFrameVector3DBasics surfaceNormalToPack) {
        this.rawRamp3D.getRampSurfaceNormal(surfaceNormalToPack);
    }

    public void getRampSurfaceNormal(FrameVector3DBasics surfaceNormalToPack) {
        this.rawRamp3D.getRampSurfaceNormal(surfaceNormalToPack);
    }

    public void notifyChangeListeners() {
        this.rawRamp3D.notifyChangeListeners();
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        this.rawRamp3D.addChangeListeners(listeners);
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.rawRamp3D.addChangeListener(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.rawRamp3D.removeChangeListener(listener);
    }

    public IntermediateVariableSupplier getIntermediateVariableSupplier() {
        return this.rawRamp3D.getIntermediateVariableSupplier();
    }

    public void setIntermediateVariableSupplier(IntermediateVariableSupplier newSupplier) {
        this.rawRamp3D.setIntermediateVariableSupplier(newSupplier);
    }

    public double getRampLength() {
        return this.rawRamp3D.getRampLength();
    }

    public double getRampIncline() {
        return this.rawRamp3D.getRampIncline();
    }

    public FrameSTPRamp3D copy() {
        return new FrameSTPRamp3D(this);
    }

    public FrameRampPolytope3DView asConvexPolytope() {
        return this.rawRamp3D.asConvexPolytope();
    }

    public boolean equals(Object object) {
        if (object instanceof FrameSTPRamp3DReadOnly) {
            return FrameSTPRamp3DBasics.super.equals((FrameSTPRamp3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawRamp3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidFrameShapeIOTools.getFrameRamp3DString((FrameRamp3DReadOnly)this).replace("]", stpSuffix);
    }
}

