/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class LinearComplementarityProblemSolver {
    private final TIntSet clampedIndexSet = new TIntHashSet(10, 0.5f, -1);
    private final TIntSet notClampedIndexSet = new TIntHashSet(10, 0.5f, -1);
    private final DMatrixRMaj A_CC = new DMatrixRMaj(10, 10);
    private final DMatrixRMaj A_Cd = new DMatrixRMaj(10, 10);
    private final DMatrixRMaj delta_f_C = new DMatrixRMaj(10, 1);
    private final DMatrixRMaj f = new DMatrixRMaj(10, 1);
    private final DMatrixRMaj a = new DMatrixRMaj(10, 1);
    private final DMatrixRMaj delta_f = new DMatrixRMaj(10, 1);
    private final DMatrixRMaj delta_a = new DMatrixRMaj(10, 1);
    private final LinearSolverDense<DMatrixRMaj> linearSolver = LinearSolverFactory_DDRM.chol((int)10);
    private double tolerance = 1.0E-12;

    public DMatrixRMaj solve(DMatrixRMaj A, DMatrixRMaj b) {
        int problemSize = LinearComplementarityProblemSolver.checkInputSize(A, b);
        this.f.reshape(problemSize, 1);
        this.f.zero();
        this.a.set((DMatrixD1)b);
        this.delta_f.reshape(problemSize, 1);
        this.delta_a.reshape(problemSize, 1);
        this.A_CC.reshape(0, 0);
        this.A_Cd.reshape(0, 1);
        this.delta_f_C.reshape(0, 1);
        this.clampedIndexSet.clear();
        this.notClampedIndexSet.clear();
        while (true) {
            int d = -1;
            for (int i = 0; i < problemSize; ++i) {
                if (!(this.a.get(i) < -this.tolerance)) continue;
                d = i;
                break;
            }
            if (d == -1) break;
            this.driveToZeroFrictionless(d, A);
        }
        return this.f;
    }

    public void driveToZeroFrictionless(int d, DMatrixRMaj A) {
        MaxStepResult maxStep;
        while (true) {
            this.fDirection(d, A);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)this.delta_f, (DMatrix1Row)this.delta_a);
            maxStep = this.maxStep(d);
            CommonOps_DDRM.addEquals((DMatrixD1)this.f, (double)maxStep.scale, (DMatrixD1)this.delta_f);
            CommonOps_DDRM.addEquals((DMatrixD1)this.a, (double)maxStep.scale, (DMatrixD1)this.delta_a);
            if (this.clampedIndexSet.remove(maxStep.j)) {
                this.notClampedIndexSet.add(maxStep.j);
                continue;
            }
            if (!this.notClampedIndexSet.remove(maxStep.j)) break;
            this.clampedIndexSet.add(maxStep.j);
        }
        this.clampedIndexSet.add(maxStep.j);
    }

    public void fDirection(int d, DMatrixRMaj A) {
        this.delta_f.zero();
        if (!this.clampedIndexSet.isEmpty()) {
            int clampedRow;
            int row;
            int[] clampedIndices = this.clampedIndexSet.toArray();
            int numberOfClampedContacts = this.clampedIndexSet.size();
            this.A_CC.reshape(numberOfClampedContacts, numberOfClampedContacts);
            this.A_Cd.reshape(numberOfClampedContacts, 1);
            this.delta_f_C.reshape(numberOfClampedContacts, 1);
            for (row = 0; row < numberOfClampedContacts; ++row) {
                clampedRow = clampedIndices[row];
                for (int column = 0; column < numberOfClampedContacts; ++column) {
                    int clampedColumn = clampedIndices[column];
                    this.A_CC.set(row, column, A.get(clampedRow, clampedColumn));
                }
                this.A_Cd.set(row, A.get(clampedRow, d));
            }
            CommonOps_DDRM.changeSign((DMatrixD1)this.A_Cd);
            this.linearSolver.setA((Matrix)this.A_CC);
            this.linearSolver.solve((Matrix)this.A_Cd, (Matrix)this.delta_f_C);
            for (row = 0; row < numberOfClampedContacts; ++row) {
                clampedRow = clampedIndices[row];
                this.delta_f.set(clampedRow, this.delta_f_C.get(row));
            }
        }
        this.delta_f.set(d, 0, 1.0);
    }

    public MaxStepResult maxStep(int d) {
        double scale = Double.POSITIVE_INFINITY;
        int j = -1;
        if (this.delta_a.get(d) > 0.0) {
            scale = -this.a.get(d) / this.delta_a.get(d);
            assert (scale > 0.0);
            assert (Double.isFinite(scale));
            j = d;
        }
        for (int i : this.clampedIndexSet) {
            if (!(this.delta_f.get(i) < 0.0)) continue;
            double scale2 = -this.f.get(i) / this.delta_f.get(i);
            assert (scale2 > 0.0);
            assert (Double.isFinite(scale2));
            if (!(scale2 < scale)) continue;
            scale = scale2;
            j = i;
        }
        for (int i : this.notClampedIndexSet) {
            if (!(this.delta_a.get(i) < 0.0)) continue;
            double scale2 = -this.a.get(i) / this.delta_a.get(i);
            assert (scale2 > 0.0);
            assert (Double.isFinite(scale2));
            if (!(scale2 < scale)) continue;
            scale = scale2;
            j = i;
        }
        return new MaxStepResult(scale, j);
    }

    private static int checkInputSize(DMatrixRMaj A, DMatrixRMaj b) {
        int problemSize = b.getNumRows();
        if (b.getNumCols() != 1) {
            throw new IllegalArgumentException("b is not a vector, numCols: " + b.getNumCols());
        }
        if (A.getNumCols() != A.getNumRows()) {
            throw new IllegalArgumentException("A is not square, numRows: " + A.getNumRows() + ", numCols: " + A.getNumCols());
        }
        if (A.getNumRows() != problemSize) {
            throw new IllegalArgumentException("Size of A does not match problem size, problem size: " + problemSize + ", size A: " + A.getNumRows());
        }
        return problemSize;
    }

    public static class MaxStepResult {
        public final double scale;
        public final int j;

        public MaxStepResult(double scale, int j) {
            this.scale = scale;
            this.j = j;
        }
    }
}

