/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class DoNothingPhysicsEngine
implements PhysicsEngine {
    private final ReferenceFrame inertialFrame;
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final List<Robot> robotList = new ArrayList<Robot>();
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private boolean initialize = true;

    public DoNothingPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        this.rootRegistry = rootRegistry;
        this.inertialFrame = inertialFrame;
    }

    @Override
    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
    }

    @Override
    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        this.rootRegistry.addChild(robot.getRegistry());
        this.robotList.add(robot);
    }

    @Override
    public boolean initialize(Vector3DReadOnly gravity) {
        if (!this.initialize) {
            return false;
        }
        for (Robot robot : this.robotList) {
            robot.initializeState();
            robot.getControllerManager().initializeControllers();
        }
        this.initialize = false;
        return true;
    }

    @Override
    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        if (this.initialize(gravity)) {
            return;
        }
        for (Robot robot : this.robotList) {
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutputForAllJoints(JointStateType.values());
            robot.updateFrames();
        }
    }

    @Override
    public void pause() {
        for (Robot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    @Override
    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<Robot> getRobots() {
        return this.robotList;
    }

    @Override
    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(Robot::getRobotDefinition).collect(Collectors.toList());
    }

    @Override
    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    @Override
    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions() {
        return null;
    }

    @Override
    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }
}

