/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;

public interface SimulationSessionControls {
    public double getDT();

    public void setDT(double var1);

    public boolean isSimulationThreadRunning();

    public boolean isRealTimeRateSimulation();

    public double getPlaybackRealTimeRate();

    public boolean isSimulating();

    public boolean isPlaying();

    public boolean isPaused();

    public boolean isSessionShutdown();

    public boolean startSimulationThread();

    public boolean stopSimulationThread();

    public void shutdownSession();

    public void addSessionShutdownListener(Runnable var1);

    public void setRealTimeRateSimulation(boolean var1);

    public void setPlaybackRealTimeRate(double var1);

    default public void simulate() {
        this.simulate(Double.POSITIVE_INFINITY);
    }

    public void simulate(double var1);

    public void simulate(int var1);

    default public boolean simulateNow(double duration) {
        return this.simulateNow((long)(duration / this.getDT()));
    }

    public boolean simulateNow(long var1);

    default public boolean simulateNow() {
        return this.simulateNow(-1L);
    }

    public void addSimulationThrowableListener(Consumer<Throwable> var1);

    public void addExternalTerminalCondition(BooleanSupplier ... var1);

    public boolean removeExternalTerminalCondition(BooleanSupplier var1);

    public void clearExternalTerminalConditions();

    public void play();

    public void pause();

    public YoBufferPropertiesReadOnly getBufferProperties();

    default public int getBufferSize() {
        return this.getBufferProperties().getSize();
    }

    default public int getBufferCurrentIndex() {
        return this.getBufferProperties().getCurrentIndex();
    }

    default public int getBufferInPoint() {
        return this.getBufferProperties().getInPoint();
    }

    default public int getBufferOutPoint() {
        return this.getBufferProperties().getOutPoint();
    }

    public int getBufferRecordTickPeriod();

    default public double getBufferRecordTimePeriod() {
        return (double)this.getBufferRecordTickPeriod() * this.getDT();
    }

    public YoSharedBuffer getBuffer();

    public boolean initializeBufferRecordTickPeriod(int var1);

    public void setBufferRecordTickPeriod(int var1);

    default public void setBufferRecordTimePeriod(double bufferRecordTimePeriod) {
        this.setBufferRecordTickPeriod((int)(bufferRecordTimePeriod / this.getDT()));
    }

    @Deprecated
    public void tick();

    @Deprecated
    default public void tickAndWrite() {
        if (!this.isPaused()) {
            return;
        }
        if (this.isSimulationThreadRunning()) {
            this.stopSimulationThread();
            this.tick();
            this.getBuffer().writeBuffer();
            this.getBuffer().prepareLinkedBuffersForPull();
            this.startSimulationThread();
        } else {
            this.tick();
            this.getBuffer().writeBuffer();
            this.getBuffer().prepareLinkedBuffersForPull();
        }
    }

    @Deprecated
    default public void writeAndTick() {
        if (!this.isPaused()) {
            return;
        }
        if (this.isSimulationThreadRunning()) {
            this.stopSimulationThread();
            this.getBuffer().writeBuffer();
            this.tick();
            this.getBuffer().prepareLinkedBuffersForPull();
            this.startSimulationThread();
        } else {
            this.getBuffer().writeBuffer();
            this.tick();
            this.getBuffer().prepareLinkedBuffersForPull();
        }
    }

    public void gotoBufferIndex(int var1);

    default public void gotoBufferInPoint() {
        this.gotoBufferIndex(this.getBufferInPoint());
    }

    default public void gotoBufferOutPoint() {
        this.gotoBufferIndex(this.getBufferOutPoint());
    }

    default public void setBufferInPoint() {
        this.setBufferInPoint(this.getBufferCurrentIndex());
    }

    public void setBufferInPoint(int var1);

    default public void setBufferOutPoint() {
        this.setBufferOutPoint(this.getBufferCurrentIndex());
    }

    public void setBufferOutPoint(int var1);

    default public void stepBufferIndexBackward() {
        this.stepBufferIndexBackward(1);
    }

    public void stepBufferIndexBackward(int var1);

    default public void stepBufferIndexForward() {
        this.stepBufferIndexForward(1);
    }

    public void stepBufferIndexForward(int var1);

    default public void cropBuffer() {
        this.cropBuffer(new CropBufferRequest(this.getBufferInPoint(), this.getBufferOutPoint()));
    }

    public void cropBuffer(CropBufferRequest var1);

    public boolean initializeBufferSize(int var1);

    public void changeBufferSize(int var1);

    public void applyBufferProcessor(YoBufferProcessor var1);

    public String getSimulationName();

    public void exportData(SessionDataExportRequest var1);

    public void addBeforePhysicsCallback(TimeConsumer var1);

    public boolean removeBeforePhysicsCallback(TimeConsumer var1);

    public void addAfterPhysicsCallback(TimeConsumer var1);

    public boolean removeAfterPhysicsCallback(TimeConsumer var1);
}

