/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionListResult;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.physicsEngine.MultiRobotCollisionGroup;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRigidBody;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemRandomTools;

public class MultiRobotCollisionGroupTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testRetrieveCollisionGroups() {
        CollisionListResult collisionListResult;
        RigidBodyBasics rootBody2;
        RigidBodyBasics rootBody1;
        int i;
        Random random = new Random(4365L);
        List collisionGroups = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)new CollisionListResult());
        Assertions.assertTrue((boolean)collisionGroups.isEmpty());
        RigidBodyBasics rootBody = MultiRobotCollisionGroupTest.nextRobot(random, "Toto");
        Collidable collidable = MultiRobotCollisionGroupTest.nextCollidable(random, rootBody);
        CollisionListResult collisionListResult2 = new CollisionListResult();
        collisionListResult2.add(MultiRobotCollisionGroupTest.toCollisionResult(collidable, MultiRobotCollisionGroupTest.emptyCollidable()));
        List collisionGroups2 = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)collisionListResult2);
        Assertions.assertEquals((int)1, (int)collisionGroups2.size());
        MultiRobotCollisionGroup firstGroup = (MultiRobotCollisionGroup)collisionGroups2.get(0);
        Assertions.assertEquals((int)1, (int)firstGroup.getNumberOfRobots());
        Assertions.assertTrue((boolean)firstGroup.contains(rootBody));
        Assertions.assertEquals((int)1, (int)firstGroup.getNumberOfCollisions());
        Assertions.assertTrue((collisionListResult2.get(0) == firstGroup.getGroupCollisions().get(0) ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            RigidBodyBasics rootBody3 = MultiRobotCollisionGroupTest.nextRobot(random, "Toto");
            int numberOfCollisions = random.nextInt(10) + 1;
            CollisionListResult collisionListResult3 = new CollisionListResult();
            for (int j = 0; j < numberOfCollisions; ++j) {
                if (random.nextBoolean()) {
                    collisionListResult3.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody3), MultiRobotCollisionGroupTest.emptyCollidable()));
                    continue;
                }
                collisionListResult3.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody3)));
            }
            List collisionGroups3 = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)collisionListResult3);
            Assertions.assertEquals((int)1, (int)collisionGroups3.size());
            MultiRobotCollisionGroup firstGroup2 = (MultiRobotCollisionGroup)collisionGroups3.get(0);
            Assertions.assertEquals((int)1, (int)firstGroup2.getNumberOfRobots());
            Assertions.assertTrue((boolean)firstGroup2.contains(rootBody3));
            Assertions.assertEquals((int)numberOfCollisions, (int)firstGroup2.getNumberOfCollisions());
            Assertions.assertTrue((boolean)firstGroup2.getGroupCollisions().containsAll((Collection)collisionListResult3));
        }
        for (i = 0; i < 1000; ++i) {
            rootBody1 = MultiRobotCollisionGroupTest.nextRobot(random, "rob1");
            rootBody2 = MultiRobotCollisionGroupTest.nextRobot(random, "rob2");
            int numberOfCollisions = random.nextInt(10) + 1;
            collisionListResult = new CollisionListResult();
            for (int j = 0; j < numberOfCollisions; ++j) {
                if (random.nextBoolean()) {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1), MultiRobotCollisionGroupTest.emptyCollidable()));
                } else {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1)));
                }
                if (random.nextBoolean()) {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2), MultiRobotCollisionGroupTest.emptyCollidable()));
                    continue;
                }
                collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2)));
            }
            List collisionGroups4 = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)collisionListResult);
            Assertions.assertEquals((int)2, (int)collisionGroups4.size());
            Assertions.assertTrue((boolean)collisionGroups4.stream().allMatch(group -> group.getNumberOfRobots() == 1));
            Set allRootBodies = collisionGroups4.stream().flatMap(group -> group.getRootBodies().stream()).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)allRootBodies.contains(rootBody1));
            Assertions.assertTrue((boolean)allRootBodies.contains(rootBody2));
            CollisionListResult allCollisions = (CollisionListResult)collisionGroups4.stream().flatMap(group -> group.getGroupCollisions().stream()).collect(CollisionListResult.collector());
            Assertions.assertEquals((int)collisionListResult.size(), (int)allCollisions.size());
            Assertions.assertTrue((boolean)collisionListResult.containsAll((Collection)allCollisions));
            for (MultiRobotCollisionGroup group2 : collisionGroups4) {
                RigidBodyBasics rootBody4 = (RigidBodyBasics)group2.getRootBodies().iterator().next();
                for (CollisionResult collision : group2.getGroupCollisions()) {
                    Assertions.assertTrue((collision.getCollidableA().getRootBody() == rootBody4 || collision.getCollidableB().getRootBody() == rootBody4 ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            rootBody1 = MultiRobotCollisionGroupTest.nextRobot(random, "rob1");
            rootBody2 = MultiRobotCollisionGroupTest.nextRobot(random, "rob2");
            int numberOfSeparateCollisions = random.nextInt(10) + 1;
            collisionListResult = new CollisionListResult();
            for (int j = 0; j < numberOfSeparateCollisions; ++j) {
                if (random.nextBoolean()) {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1), MultiRobotCollisionGroupTest.emptyCollidable()));
                } else {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1)));
                }
                if (random.nextBoolean()) {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2), MultiRobotCollisionGroupTest.emptyCollidable()));
                    continue;
                }
                collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2)));
            }
            int numberOfInterCollisions = random.nextInt(5) + 1;
            for (int j = 0; j < numberOfInterCollisions; ++j) {
                if (random.nextBoolean()) {
                    collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2)));
                    continue;
                }
                collisionListResult.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody2), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody1)));
            }
            List collisionGroups5 = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)collisionListResult);
            Assertions.assertEquals((int)1, (int)collisionGroups5.size());
            MultiRobotCollisionGroup firstGroup3 = (MultiRobotCollisionGroup)collisionGroups5.get(0);
            Assertions.assertEquals((int)2, (int)firstGroup3.getNumberOfRobots());
            Assertions.assertTrue((boolean)firstGroup3.contains(rootBody1));
            Assertions.assertTrue((boolean)firstGroup3.contains(rootBody2));
            CollisionListResult groupCollisions = firstGroup3.getGroupCollisions();
            Assertions.assertEquals((int)collisionListResult.size(), (int)groupCollisions.size());
            Assertions.assertTrue((boolean)collisionListResult.containsAll((Collection)groupCollisions));
        }
        for (i = 0; i < 1000; ++i) {
            int numberOfRobots = random.nextInt(15) + 1;
            List<RigidBodyBasics> rootBodies = MultiRobotCollisionGroupTest.nextRobots(random, "blop", numberOfRobots);
            int numberOfCollisions = random.nextInt(50) + 1;
            HashSet<RigidBodyBasics> collidingRobots = new HashSet<RigidBodyBasics>();
            HashSet<RigidBodyBasics> notCollidingRobots = new HashSet<RigidBodyBasics>(rootBodies);
            CollisionListResult input = new CollisionListResult();
            for (int j = 0; j < numberOfCollisions; ++j) {
                if (numberOfRobots == 1 || random.nextBoolean()) {
                    RigidBodyBasics rootBody5 = MultiRobotCollisionGroupTest.nextElementIn(random, rootBodies);
                    collidingRobots.add(rootBody5);
                    notCollidingRobots.remove(rootBody5);
                    if (random.nextBoolean()) {
                        input.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootBody5), MultiRobotCollisionGroupTest.emptyCollidable()));
                        continue;
                    }
                    input.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.emptyCollidable(), MultiRobotCollisionGroupTest.nextCollidable(random, rootBody5)));
                    continue;
                }
                RigidBodyBasics rootA = MultiRobotCollisionGroupTest.nextElementIn(random, rootBodies);
                RigidBodyBasics rootB = MultiRobotCollisionGroupTest.nextElementIn(random, rootBodies);
                collidingRobots.add(rootA);
                collidingRobots.add(rootB);
                notCollidingRobots.remove(rootA);
                notCollidingRobots.remove(rootB);
                input.add(MultiRobotCollisionGroupTest.toCollisionResult(MultiRobotCollisionGroupTest.nextCollidable(random, rootA), MultiRobotCollisionGroupTest.nextCollidable(random, rootB)));
            }
            List collisionGroups6 = MultiRobotCollisionGroup.toCollisionGroups((CollisionListResult)input);
            List groupedRobots = collisionGroups6.stream().flatMap(group -> group.getRootBodies().stream()).collect(Collectors.toList());
            Assertions.assertEquals((int)collidingRobots.size(), (int)groupedRobots.size());
            Assertions.assertTrue((boolean)groupedRobots.containsAll(collidingRobots));
            Assertions.assertTrue((boolean)notCollidingRobots.stream().noneMatch(root -> groupedRobots.contains(root)));
            CollisionListResult groupedCollisions = (CollisionListResult)collisionGroups6.stream().flatMap(group -> group.getGroupCollisions().stream()).collect(CollisionListResult.collector());
            Assertions.assertEquals((int)input.size(), (int)groupedCollisions.size());
            Assertions.assertTrue((boolean)groupedCollisions.containsAll((Collection)input));
            for (MultiRobotCollisionGroup group3 : collisionGroups6) {
                HashSet<RigidBodyBasics> rootBodiesFromCollisions = new HashSet<RigidBodyBasics>();
                for (CollisionResult collision : group3.getGroupCollisions()) {
                    if (collision.getCollidableA().getRootBody() != null) {
                        rootBodiesFromCollisions.add(collision.getCollidableA().getRootBody());
                    }
                    if (collision.getCollidableB().getRootBody() == null) continue;
                    rootBodiesFromCollisions.add(collision.getCollidableB().getRootBody());
                }
                Assertions.assertEquals((int)group3.getRootBodies().size(), (int)rootBodiesFromCollisions.size());
                Assertions.assertTrue((boolean)rootBodiesFromCollisions.containsAll(group3.getRootBodies()));
            }
        }
    }

    private static List<RigidBodyBasics> nextRobots(Random random, String robotName, int numberOfRobots) {
        ArrayList<RigidBodyBasics> rootBodies = new ArrayList<RigidBodyBasics>();
        for (int i = 0; i < numberOfRobots; ++i) {
            rootBodies.add(MultiRobotCollisionGroupTest.nextRobot(random, robotName + i));
        }
        return rootBodies;
    }

    private static RigidBodyBasics nextRobot(Random random, String robotName) {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimRigidBody rootBody = new SimRigidBody(robotName + "RootBody", worldFrame, null, null);
        SimMultiBodySystemRandomTools.nextJointChain((Random)random, (String)robotName, (SimRigidBodyBasics)rootBody, (int)5);
        return rootBody;
    }

    private static Collidable emptyCollidable() {
        return new Collidable(null, -1L, -1L, null);
    }

    private static Collidable nextCollidable(Random random, RigidBodyBasics rootBody) {
        RigidBodyBasics rigidBody = (RigidBodyBasics)MultiRobotCollisionGroupTest.nextElementIn(random, rootBody.subtreeList());
        return new Collidable(rigidBody, -1L, -1L, null);
    }

    @SafeVarargs
    public static <E> E nextElementIn(Random random, E ... elements) {
        return elements[random.nextInt(elements.length)];
    }

    public static <E> E nextElementIn(Random random, List<E> list) {
        return list.get(random.nextInt(list.size()));
    }

    private static CollisionResult toCollisionResult(Collidable collidableA, Collidable collidableB) {
        CollisionResult collisionResult = new CollisionResult();
        collisionResult.setCollidableA(collidableA);
        collisionResult.setCollidableB(collidableB);
        return collisionResult;
    }
}

