/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ContactImpulseRandomTools;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ContactImpulseTools;

public class ContactImpulseToolsTest {
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-12;
    private static final double PROJ_GRADIENT_EPSILON = 1.0E-9;
    private static final double COST_VS_NAIVE_EPSILON = 1.0E-7;

    @Test
    public void testCross() {
        Random random = new Random(36457L);
        for (int i = 0; i < 5000; ++i) {
            DMatrixRMaj v1 = RandomMatrices_DDRM.rectangle((int)3, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj v2 = RandomMatrices_DDRM.rectangle((int)3, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj actualCross = ContactImpulseTools.cross((DMatrixRMaj)v1, (DMatrixRMaj)v2);
            Vector3D euclidV1 = new Vector3D();
            Vector3D euclidV2 = new Vector3D();
            Vector3D euclidCross = new Vector3D();
            euclidV1.set((DMatrix)v1);
            euclidV2.set((DMatrix)v2);
            euclidCross.cross((Tuple3DReadOnly)euclidV1, (Tuple3DReadOnly)euclidV2);
            DMatrixRMaj expectedCross = new DMatrixRMaj(3, 1);
            euclidCross.get((DMatrix)expectedCross);
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedCross, (DMatrixD1)actualCross, (double)1.0E-12));
        }
    }

    @Test
    public void testMultQuad() {
        Random random = new Random(46456L);
        for (int i = 0; i < 5000; ++i) {
            int xSize = random.nextInt(50) + 1;
            DMatrixRMaj x = RandomMatrices_DDRM.rectangle((int)xSize, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj H = RandomMatrices_DDRM.rectangle((int)xSize, (int)xSize, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj intermediate = new DMatrixRMaj(xSize, 1);
            CommonOps_DDRM.mult((DMatrix1Row)H, (DMatrix1Row)x, (DMatrix1Row)intermediate);
            double expectedResult = CommonOps_DDRM.dot((DMatrixD1)x, (DMatrixD1)intermediate);
            double actualResult = ContactImpulseTools.multQuad((DMatrixRMaj)x, (DMatrixRMaj)H);
            Assertions.assertEquals((double)expectedResult, (double)actualResult, (double)1.0E-12);
        }
    }

    @Test
    public void testComputeLambdaZ() {
        Random random = new Random(46457L);
        for (int i = 0; i < 5000; ++i) {
            double r = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            DMatrixRMaj M_inv = ContactImpulseRandomTools.nextSquareFullRank((Random)random);
            DMatrixRMaj c = RandomMatrices_DDRM.rectangle((int)3, (int)1, (Random)random);
            double lambda_x = r * cosTheta;
            double lambda_y = r * sinTheta;
            double lambda_z = ContactImpulseTools.computeLambdaZ((double)r, (double)cosTheta, (double)sinTheta, (DMatrix)M_inv, (DMatrix)c);
            DMatrixRMaj lambda = new DMatrixRMaj(3, 1);
            lambda.set(0, 0, lambda_x);
            lambda.set(1, 0, lambda_y);
            lambda.set(2, 0, lambda_z);
            DMatrixRMaj v = new DMatrixRMaj(c);
            CommonOps_DDRM.multAdd((DMatrix1Row)M_inv, (DMatrix1Row)lambda, (DMatrix1Row)v);
            Assertions.assertEquals((double)0.0, (double)v.get(2, 0), (double)1.0E-12, (String)("Iteration: " + i));
        }
    }

    @Test
    public void testComputeR() {
        Random random = new Random(463578L);
        for (int i = 0; i < 5000; ++i) {
            double mu = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            DMatrixRMaj M_inv = ContactImpulseRandomTools.nextSquareFullRank((Random)random);
            DMatrixRMaj c = RandomMatrices_DDRM.rectangle((int)3, (int)1, (Random)random);
            double r = ContactImpulseTools.computeR((double)mu, (double)cosTheta, (double)sinTheta, (DMatrix)M_inv, (DMatrix)c);
            double lambda_x = Math.abs(r * cosTheta);
            double lambda_y = Math.abs(r * sinTheta);
            double lambda_z = Math.abs(ContactImpulseTools.computeLambdaZ((double)r, (double)cosTheta, (double)sinTheta, (DMatrix)M_inv, (DMatrix)c));
            double delta = Math.max(1.0, mu * lambda_z) * 1.0E-12;
            Assertions.assertEquals((double)EuclidCoreTools.norm((double)lambda_x, (double)lambda_y), (double)(mu * lambda_z), (double)delta, (String)("Iteration: " + i));
        }
    }

    @Test
    public void testComputeE() {
        Random random = new Random(6547L);
        for (int i = 0; i < 5000; ++i) {
            DMatrixRMaj M = ContactImpulseRandomTools.nextPositiveDefiniteSymmetricMatrix((Random)random, (double)0.001, (double)10.0);
            DMatrixRMaj M_inv = ContactImpulseTools.invert((DMatrixRMaj)M);
            DMatrixRMaj c = RandomMatrices_DDRM.rectangle((int)3, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj lambda = RandomMatrices_DDRM.rectangle((int)3, (int)1, (double)-10.0, (double)10.0, (Random)random);
            DMatrixRMaj v = ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)lambda);
            double E1 = ContactImpulseTools.computeE1((DMatrixRMaj)v, (DMatrixRMaj)M);
            double E3 = ContactImpulseTools.computeE3((DMatrixRMaj)M, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)lambda);
            Assertions.assertEquals((double)E1, (double)E3, (double)(Math.max(1.0, Math.abs(E1)) * 1.0E-12));
        }
    }

    @Test
    public void testComputeProjectedGradient() {
        double mu;
        int i;
        Random random = new Random(97245L);
        for (i = 0; i < 5000; ++i) {
            DMatrixRMaj M = ContactImpulseRandomTools.nextSquareFullRank((Random)random);
            DMatrixRMaj M_inv = new DMatrixRMaj(3, 3);
            CommonOps_DDRM.invert((DMatrixRMaj)M, (DMatrixRMaj)M_inv);
            DMatrixRMaj c = RandomMatrices_DDRM.rectangle((int)3, (int)1, (Random)random);
            DMatrixRMaj lambda = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            mu = Math.sqrt(lambda.get(0) * lambda.get(0) + lambda.get(1) * lambda.get(1)) / Math.abs(lambda.get(2));
            double projectedGradient = ContactImpulseTools.computeProjectedGradient((double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)lambda);
            Assertions.assertEquals((double)0.0, (double)projectedGradient, (double)1.0E-9, (String)("Iteration " + i));
            double cost = ContactImpulseTools.computeE1((DMatrixRMaj)ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)lambda), (DMatrixRMaj)M);
            Assertions.assertEquals((double)0.0, (double)cost, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            double theta = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            DMatrixRMaj M = ContactImpulseRandomTools.nextPositiveDefiniteSymmetricMatrix((Random)random, (double)0.001, (double)10.0);
            DMatrixRMaj M_inv = ContactImpulseTools.invert((DMatrixRMaj)M);
            mu = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            DMatrixRMaj c = ContactImpulseRandomTools.nextSlippingClosingVelocity((Random)random, (DMatrixRMaj)M_inv, (double)mu);
            double dtheta = 1.0E-6;
            double numericalDerivative = ContactImpulseTools.computeEThetaNumericalDerivative((double)theta, (double)dtheta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
            DMatrixRMaj lambda_v_0 = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            if (lambda_v_0.get(2) < 0.0) {
                --i;
                continue;
            }
            Assertions.assertFalse((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)lambda_v_0));
            DMatrixRMaj lambda = ContactImpulseTools.computeLambda((double)theta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
            if (lambda.get(2) < 0.0) {
                --i;
                continue;
            }
            double projectedDerivative = ContactImpulseTools.computeProjectedGradient((double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)lambda);
            Assertions.assertTrue((numericalDerivative * projectedDerivative > 0.0 ? 1 : 0) != 0, (String)("Iteration " + i + ": expected " + numericalDerivative + " was " + projectedDerivative));
        }
    }

    @Test
    public void testLineOfSight() {
        Random random = new Random(34563L);
        for (int i = 0; i < 5000; ++i) {
            double mu;
            DMatrixRMaj M = ContactImpulseRandomTools.nextPositiveDefiniteSymmetricMatrix((Random)random, (double)0.001, (double)10.0);
            DMatrixRMaj M_inv = ContactImpulseTools.invert((DMatrixRMaj)M);
            DMatrixRMaj c = ContactImpulseRandomTools.nextSlippingClosingVelocity((Random)random, (DMatrixRMaj)M_inv, (double)(mu = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0)));
            Assertions.assertTrue((c.get(2) < 0.0 ? 1 : 0) != 0);
            DMatrixRMaj lambda_v_0 = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            Assertions.assertTrue((lambda_v_0.get(2) > 0.0 ? 1 : 0) != 0);
            double theta = Math.atan2(lambda_v_0.get(1), lambda_v_0.get(0));
            Assertions.assertTrue((boolean)ContactImpulseTools.lineOfSightTest((double)mu, (DMatrix)ContactImpulseTools.computeLambda((double)theta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c), (DMatrix)lambda_v_0), (String)("Iteration " + i));
        }
    }

    @Test
    public void testNextSlippingClosingVelocity() {
        Random random = new Random(4252465L);
        for (int i = 0; i < 5000; ++i) {
            DMatrixRMaj M = ContactImpulseRandomTools.nextPositiveDefiniteSymmetricMatrix((Random)random, (double)0.001, (double)10.0);
            DMatrixRMaj M_inv = ContactImpulseTools.invert((DMatrixRMaj)M);
            double mu = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            DMatrixRMaj c = ContactImpulseRandomTools.nextSlippingClosingVelocity((Random)random, (DMatrixRMaj)M_inv, (double)mu);
            DMatrixRMaj lambda_v_0 = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            Assertions.assertFalse((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)lambda_v_0), (String)("Iteration " + i));
            Assertions.assertTrue((c.get(2) < 0.0 ? 1 : 0) != 0, (String)("Iteration " + i));
        }
    }

    @Test
    public void testComputeSlipLambda() {
        Random random = new Random(4353466L);
        double beta1 = 0.1;
        double beta2 = 0.95;
        double beta3 = 1.15;
        double gamma = 1.0E-12;
        for (int i = 0; i < 5000; ++i) {
            DMatrixRMaj actualLambda;
            DMatrixRMaj M = ContactImpulseRandomTools.nextPositiveDefiniteSymmetricMatrix((Random)random, (double)0.001, (double)10.0);
            DMatrixRMaj M_inv = ContactImpulseTools.invert((DMatrixRMaj)M);
            double mu = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)1.0);
            DMatrixRMaj c = ContactImpulseRandomTools.nextSlippingClosingVelocity((Random)random, (DMatrixRMaj)M_inv, (double)mu);
            DMatrixRMaj lambda_v_0 = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            Assertions.assertFalse((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)lambda_v_0));
            Assertions.assertTrue((c.get(2) < 0.0 ? 1 : 0) != 0);
            double dTheta = 0.01;
            double thetaNaiveOpt = EuclidCoreTools.trimAngleMinusPiToPi((double)ContactImpulseToolsTest.findOptimalTheta(M, M_inv, c, mu, gamma, dTheta, false));
            DMatrixRMaj expectedLambda = ContactImpulseTools.computeLambda((double)thetaNaiveOpt, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
            double expectedCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)expectedLambda);
            try {
                actualLambda = ContactImpulseTools.computeSlipLambda((double)beta1, (double)beta2, (double)beta3, (double)gamma, (double)mu, (DMatrix)M_inv, (DMatrix)lambda_v_0, (DMatrix)c, (boolean)false);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new AssertionFailedError("Iteration " + i, (Throwable)e);
            }
            DMatrixRMaj vPlusActual = ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)actualLambda);
            Assertions.assertEquals((double)0.0, (double)vPlusActual.get(2), (double)1.0E-12);
            double actualCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)actualLambda);
            while (!EuclidCoreTools.epsilonEquals((double)expectedCost, (double)actualCost, (double)(Math.max(Math.abs(expectedCost), 1.0) * 1.0E-12))) {
                dTheta = 0.5 * dTheta;
                System.out.println("Iteration " + i + " dTheta " + dTheta);
                thetaNaiveOpt = EuclidCoreTools.trimAngleMinusPiToPi((double)ContactImpulseToolsTest.findOptimalTheta(M, M_inv, c, mu, gamma, dTheta, false));
                expectedLambda = ContactImpulseTools.computeLambda((double)thetaNaiveOpt, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
                expectedCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)expectedLambda);
            }
            DMatrixRMaj vPlusExpected = ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)expectedLambda);
            Assertions.assertTrue((actualLambda.get(0) * vPlusExpected.get(0) + actualLambda.get(1) * vPlusExpected.get(1) < 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)ContactImpulseTools.lineOfSightTest((double)mu, (DMatrix)expectedLambda, (DMatrix)lambda_v_0));
            Assertions.assertTrue((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)actualLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)actualLambda)) * 1.0E-12)));
            Assertions.assertTrue((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)expectedLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)expectedLambda)) * 1.0E-12)));
            Assertions.assertEquals((double)expectedCost, (double)actualCost, (double)(Math.max(Math.abs(expectedCost), 1.0) * 1.0E-12), (String)("Iteration " + i));
            boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedLambda, (DMatrixD1)actualLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)expectedLambda)) * 1.0E-7));
            if (!areEqual) {
                System.out.println("iteration: " + i);
                System.out.println("Cost: " + expectedCost + ", " + actualCost);
                double maxError = 0.0;
                DMatrixRMaj output = new DMatrixRMaj(3, 3);
                for (int row = 0; row < 3; ++row) {
                    double error = expectedLambda.get(row, 0) - actualLambda.get(row, 0);
                    output.set(row, 0, expectedLambda.get(row, 0));
                    output.set(row, 1, actualLambda.get(row, 0));
                    output.set(row, 2, error);
                    maxError = Math.max(maxError, Math.abs(error));
                }
                output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
                System.out.println("Max error: " + maxError);
                System.out.println("c: " + String.valueOf(c));
                System.out.println("v+:");
                DMatrixRMaj vPluses = new DMatrixRMaj(3, 2);
                CommonOps_DDRM.insert((DMatrix)vPlusExpected, (DMatrix)vPluses, (int)0, (int)0);
                CommonOps_DDRM.insert((DMatrix)vPlusActual, (DMatrix)vPluses, (int)0, (int)1);
                System.out.println(vPluses);
            }
            Assertions.assertTrue((boolean)areEqual);
        }
    }

    static double polarGradient(DMatrixRMaj M_inv, double theta, DMatrixRMaj c, double lambda_z, double mu) {
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double Minv_xx = M_inv.get(0, 0);
        double Minv_yy = M_inv.get(1, 1);
        double Minv_xy = M_inv.get(0, 1);
        double Minv_zy = M_inv.get(2, 1);
        double Minv_zx = M_inv.get(2, 0);
        double c_x = c.get(0);
        double c_y = c.get(1);
        double dE_dTheta = (Minv_xy * cosTheta * cosTheta + (Minv_yy - Minv_xx) * sinTheta * cosTheta - Minv_xy * sinTheta * sinTheta) * EuclidCoreTools.square((double)(mu * lambda_z));
        return dE_dTheta += ((c_y + Minv_zy * lambda_z) * cosTheta - (c_x + Minv_zx * lambda_z) * sinTheta) * mu * lambda_z;
    }

    public static double polarGradient2(DMatrixRMaj M_inv, DMatrixRMaj c, double theta, double mu) {
        double c_x = c.get(0);
        double c_y = c.get(1);
        double c_z = c.get(2);
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double Mxx = M_inv.get(0, 0);
        double Mxy = M_inv.get(0, 1);
        double Myy = M_inv.get(1, 1);
        double Mzx = M_inv.get(2, 0);
        double Mzy = M_inv.get(2, 1);
        double Mzz = M_inv.get(2, 2);
        double Mtheta = Mzx * cosTheta + Mzy * sinTheta;
        return -c_z * mu * (((-Mzy * c_x + Mzx * c_y) * Mtheta + (Mzy * (Mxx * cosTheta + Mxy * sinTheta) - Mzx * (Mxy * cosTheta + Myy * sinTheta)) * c_z) * mu * mu + Mzz * (-(sinTheta * Mtheta + Mzy) * c_x + (cosTheta * Mtheta + Mzx) * c_y + (cosTheta * sinTheta * Mxx - Mxy + 2.0 * sinTheta * sinTheta * Mxy - sinTheta * cosTheta * Myy) * c_z) * mu + Mzz * ((-sinTheta * c_x + cosTheta * c_y) * Mzz + c_z * (Mzx * sinTheta - Mzy * cosTheta))) / ContactImpulseTools.cube((double)(Mzz + Mtheta * mu));
    }

    public static double findOptimalTheta(DMatrixRMaj M, DMatrixRMaj M_inv, DMatrixRMaj c, double mu, double tolerance, double dTheta, boolean verbose) {
        double thetaStart;
        double thetaSubOpt = thetaStart = 0.0;
        double costSubOpt = Double.POSITIVE_INFINITY;
        double thetaOpt = thetaSubOpt;
        double costOpt = Double.POSITIVE_INFINITY;
        do {
            DMatrixRMaj lambdaSubOpt;
            if (!((costSubOpt = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)(lambdaSubOpt = ContactImpulseTools.computeLambda((double)(thetaSubOpt = ContactImpulseToolsTest.findNextSubOptimalTheta(thetaSubOpt, M_inv, c, mu, tolerance, dTheta, verbose)), (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c)))) < costOpt) || !(lambdaSubOpt.get(2) > 0.0)) continue;
            costOpt = costSubOpt;
            thetaOpt = thetaSubOpt;
        } while (thetaSubOpt - thetaStart < Math.PI * 2);
        return thetaOpt;
    }

    public static double findNextSubOptimalTheta(double thetaStart, DMatrixRMaj M_inv, DMatrixRMaj c, double mu, double tolerance, double dTheta, boolean verbose) {
        double thetaMid;
        double previousTheta;
        double previousCost;
        double currentTheta = thetaStart;
        double currentCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)ContactImpulseTools.computeLambda((double)currentTheta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c));
        double currentGradient = ContactImpulseTools.computeEThetaNumericalDerivative((double)currentTheta, (double)1.0E-6, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
        do {
            previousTheta = currentTheta;
            previousCost = currentCost;
            currentTheta = previousTheta + dTheta;
            currentCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)ContactImpulseTools.computeLambda((double)currentTheta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c));
            currentGradient = ContactImpulseToolsTest.polarGradient2(M_inv, c, currentTheta, mu);
            if (!verbose) continue;
            System.out.println("going up, theta: " + currentTheta + ", cost: " + currentCost + ", grad: " + ContactImpulseTools.computeProjectedGradient((double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (double)currentTheta));
        } while (currentCost - previousCost > 0.0);
        double bisectionTheta = currentTheta;
        double bisectionCost = currentCost;
        double bisectionGradient = currentGradient;
        do {
            previousTheta = currentTheta;
            previousCost = currentCost;
            currentTheta = previousTheta + dTheta;
            currentCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)ContactImpulseTools.computeLambda((double)currentTheta, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c));
            currentGradient = ContactImpulseToolsTest.polarGradient2(M_inv, c, currentTheta, mu);
            if (!verbose) continue;
            System.out.println("going down, theta: " + currentTheta + ", cost: " + currentCost + ", grad: " + ContactImpulseTools.computeProjectedGradient((double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (double)currentTheta));
        } while (currentCost - previousCost < 0.0);
        do {
            thetaMid = 0.5 * (bisectionTheta + currentTheta);
            double costMid = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)ContactImpulseTools.computeLambda((double)thetaMid, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c));
            double gradientMid = ContactImpulseToolsTest.polarGradient2(M_inv, c, thetaMid, mu);
            if (bisectionGradient * gradientMid > 0.0) {
                bisectionTheta = thetaMid;
                bisectionCost = costMid;
                bisectionGradient = gradientMid;
            } else {
                currentTheta = thetaMid;
                currentCost = costMid;
            }
            if (!verbose) continue;
            System.out.println("theta [" + bisectionTheta + ", " + currentTheta + "], cost [" + bisectionCost + ", " + currentCost + "]");
        } while (!(Math.abs(bisectionTheta - currentTheta) < tolerance));
        return thetaMid;
    }

    @Test
    public void testDatasets() {
        List<Dataset> datasets = ContactImpulseToolsTest.datasets();
        for (int i = 0; i < datasets.size(); ++i) {
            DMatrixRMaj actualLambda;
            Dataset dataset = datasets.get(i);
            double beta1 = dataset.beta1;
            double beta2 = dataset.beta2;
            double beta3 = dataset.beta3;
            double gamma = dataset.gamma;
            double mu = dataset.mu;
            DMatrixRMaj M_inv = dataset.M_inv;
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isSymmetric((DMatrixRMaj)M_inv, (double)1.0E-12));
            Assertions.assertTrue((boolean)MatrixFeatures_DDRM.isPositiveSemidefinite((DMatrixRMaj)M_inv));
            DMatrixRMaj M = ContactImpulseTools.invert((DMatrixRMaj)M_inv);
            DMatrixRMaj c = dataset.c;
            Assertions.assertTrue((c.get(2) < 0.0 ? 1 : 0) != 0);
            DMatrixRMaj lambda_v_0 = ContactImpulseTools.negateMult((DMatrixRMaj)M, (DMatrixRMaj)c);
            Assertions.assertFalse((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)lambda_v_0));
            double dTheta = 0.01;
            double thetaNaiveOpt = EuclidCoreTools.trimAngleMinusPiToPi((double)ContactImpulseToolsTest.findOptimalTheta(M, M_inv, c, mu, gamma, dTheta, false));
            DMatrixRMaj expectedLambda = ContactImpulseTools.computeLambda((double)thetaNaiveOpt, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
            double expectedCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)expectedLambda);
            try {
                actualLambda = ContactImpulseTools.computeSlipLambda((double)beta1, (double)beta2, (double)beta3, (double)gamma, (double)mu, (DMatrix)M_inv, (DMatrix)lambda_v_0, (DMatrix)c, (i == 2 ? 1 : 0) != 0);
                System.out.println(ContactImpulseTools.computeProjectedGradient((double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)actualLambda));
                System.out.println(ContactImpulseTools.computeProjectedGradientInefficient((DMatrixRMaj)M_inv, (DMatrixRMaj)actualLambda, (DMatrixRMaj)c, (double)mu));
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                throw new AssertionFailedError("Iteration " + i, (Throwable)e);
            }
            DMatrixRMaj vPlusActual = ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)actualLambda);
            Assertions.assertEquals((double)0.0, (double)vPlusActual.get(2), (double)1.0E-12, (String)("Iteration " + i));
            Assertions.assertTrue((boolean)ContactImpulseTools.lineOfSightTest((double)mu, (DMatrix)actualLambda, (DMatrix)lambda_v_0), (String)("Iteration " + i));
            Assertions.assertTrue((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)actualLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)actualLambda)) * 1.0E-12)), (String)("Iteration " + i));
            Assertions.assertTrue((actualLambda.get(0) * vPlusActual.get(0) + actualLambda.get(1) * vPlusActual.get(1) < 0.0 ? 1 : 0) != 0, (String)("Iteration " + i));
            double actualCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)actualLambda);
            while (!EuclidCoreTools.epsilonEquals((double)expectedCost, (double)actualCost, (double)(Math.max(Math.abs(expectedCost), 1.0) * 1.0E-12))) {
                dTheta = 0.5 * dTheta;
                System.out.println("Iteration " + i + " dTheta " + dTheta);
                thetaNaiveOpt = EuclidCoreTools.trimAngleMinusPiToPi((double)ContactImpulseToolsTest.findOptimalTheta(M, M_inv, c, mu, gamma, dTheta, false));
                expectedLambda = ContactImpulseTools.computeLambda((double)thetaNaiveOpt, (double)mu, (DMatrixRMaj)M_inv, (DMatrixRMaj)c);
                expectedCost = ContactImpulseTools.computeE2((DMatrixRMaj)M_inv, (DMatrixRMaj)c, (DMatrixRMaj)expectedLambda);
            }
            DMatrixRMaj vPlusExpected = ContactImpulseTools.computePostImpulseVelocity((DMatrixRMaj)c, (DMatrixRMaj)M_inv, (DMatrixRMaj)expectedLambda);
            Assertions.assertTrue((boolean)ContactImpulseTools.lineOfSightTest((double)mu, (DMatrix)expectedLambda, (DMatrix)lambda_v_0), (String)("Iteration " + i));
            Assertions.assertTrue((boolean)ContactImpulseTools.isInsideFrictionCone((double)mu, (DMatrix)expectedLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)expectedLambda)) * 1.0E-12)), (String)("Iteration " + i));
            Assertions.assertEquals((double)expectedCost, (double)actualCost, (double)(Math.max(Math.abs(expectedCost), 1.0) * 1.0E-12), (String)("Iteration " + i));
            boolean areEqual = MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedLambda, (DMatrixD1)actualLambda, (double)(Math.max(1.0, CommonOps_DDRM.elementMaxAbs((DMatrixD1)expectedLambda)) * 1.0E-7));
            if (!areEqual) {
                System.out.println("iteration: " + i);
                System.out.println("Cost: " + expectedCost + ", " + actualCost);
                double maxError = 0.0;
                DMatrixRMaj output = new DMatrixRMaj(3, 3);
                for (int row = 0; row < 3; ++row) {
                    double error = expectedLambda.get(row, 0) - actualLambda.get(row, 0);
                    output.set(row, 0, expectedLambda.get(row, 0));
                    output.set(row, 1, actualLambda.get(row, 0));
                    output.set(row, 2, error);
                    maxError = Math.max(maxError, Math.abs(error));
                }
                output.print(EuclidCoreIOTools.getStringFormat((int)9, (int)6));
                System.out.println("Max error: " + maxError);
                System.out.println("c: " + String.valueOf(c));
                System.out.println("v+:");
                DMatrixRMaj vPluses = new DMatrixRMaj(3, 2);
                CommonOps_DDRM.insert((DMatrix)vPlusExpected, (DMatrix)vPluses, (int)0, (int)0);
                CommonOps_DDRM.insert((DMatrix)vPlusActual, (DMatrix)vPluses, (int)0, (int)1);
                System.out.println(vPluses);
            }
            Assertions.assertTrue((boolean)areEqual);
        }
    }

    private static List<Dataset> datasets() {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        datasets.add(new Dataset(0.1, 0.95, 1.05, 1.0E-12, 0.7, new DMatrixRMaj(3, 3, true, new double[]{0.12177228584776682, -0.006490285501662073, -0.0198942344541152, -0.0064902855016620966, 0.03749206992467399, -0.020817228276444992, -0.019894234454115235, -0.020817228276444992, 0.06819326854414993}), new DMatrixRMaj(3, 1, true, new double[]{-0.9626403389842907, -0.36649553510266114, -1.2699859622739815})));
        datasets.add(new Dataset(0.35, 0.95, 1.15, 1.0E-6, 0.7, new DMatrixRMaj(3, 3, true, new double[]{0.5377939246837216, 0.07285205074934606, 0.1410180601120504, 0.07285205074934609, 0.31156159306905296, 0.37755617516622175, 0.14101806011205031, 0.37755617516622164, 0.6485524022866964}), new DMatrixRMaj(3, 1, true, new double[]{-0.4009147394246455, 0.48869427996462383, -1.5083682060883388})));
        return datasets;
    }

    private static class Dataset {
        private double beta1;
        private double beta2;
        private double beta3;
        private double gamma;
        private double mu;
        private DMatrixRMaj M_inv;
        private DMatrixRMaj c;

        public Dataset(double beta1, double beta2, double beta3, double gamma, double mu, DMatrixRMaj M_inv, DMatrixRMaj c) {
            this.beta1 = beta1;
            this.beta2 = beta2;
            this.beta3 = beta3;
            this.gamma = gamma;
            this.mu = mu;
            this.M_inv = M_inv;
            this.c = c;
        }
    }
}

