/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.simulation.SpyList;

public class SpyListTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testSet() {
        Random random = new Random(453L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(100);
            SpyList<Long> spyList = SpyListTest.nextSpyList(random, size);
            ArrayList changes = new ArrayList();
            spyList.addListener(changes::add);
            Long newElement = random.nextLong();
            if (size == 0) {
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> spyList.set(0, (Object)newElement));
                continue;
            }
            int index = random.nextInt(size);
            Long oldElement = (Long)spyList.set(index, (Object)newElement);
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)false, (Object)change.wasAdded());
            Assertions.assertEquals((Object)false, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)true, (Object)change.wasReplaced());
            Assertions.assertEquals((int)index, (int)change.getIndex());
            Assertions.assertEquals((int)1, (int)change.getSize());
            Assertions.assertEquals((int)1, (int)change.getNewElements().size());
            Assertions.assertTrue((newElement == change.getNewElements().get(0) ? 1 : 0) != 0);
            Assertions.assertEquals((int)1, (int)change.getOldElements().size());
            Assertions.assertTrue((oldElement == change.getOldElements().get(0) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAdd() {
        ArrayList changes;
        SpyList<Long> spyList;
        int size;
        int i;
        Random random = new Random(453L);
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(100);
            spyList = SpyListTest.nextSpyList(random, size);
            changes = new ArrayList();
            spyList.addListener(changes::add);
            Long newElement = random.nextLong();
            spyList.add((Object)newElement);
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)true, (Object)change.wasAdded());
            Assertions.assertEquals((Object)false, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)(spyList.size() - 1), (int)change.getIndex());
            Assertions.assertEquals((int)1, (int)change.getSize());
            Assertions.assertEquals((int)1, (int)change.getNewElements().size());
            Assertions.assertTrue((newElement == change.getNewElements().get(0) ? 1 : 0) != 0);
            Assertions.assertNull((Object)change.getOldElements());
        }
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(100);
            spyList = SpyListTest.nextSpyList(random, size);
            changes = new ArrayList();
            spyList.addListener(changes::add);
            int index = random.nextInt(size + 1);
            Long newElement = random.nextLong();
            spyList.add(index, (Object)newElement);
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)true, (Object)change.wasAdded());
            Assertions.assertEquals((Object)false, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)index, (int)change.getIndex());
            Assertions.assertEquals((int)1, (int)change.getSize());
            Assertions.assertEquals((int)1, (int)change.getNewElements().size());
            Assertions.assertTrue((newElement == change.getNewElements().get(0) ? 1 : 0) != 0);
            Assertions.assertNull((Object)change.getOldElements());
        }
    }

    @Test
    public void testRemoved() {
        Random random = new Random(453L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(100);
            SpyList<Long> spyList = SpyListTest.nextSpyList(random, size);
            ArrayList changes = new ArrayList();
            spyList.addListener(changes::add);
            if (size == 0) {
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> spyList.remove(0));
                continue;
            }
            int index = random.nextInt(size);
            Long oldElement = (Long)spyList.remove(index);
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)false, (Object)change.wasAdded());
            Assertions.assertEquals((Object)true, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)index, (int)change.getIndex());
            Assertions.assertEquals((int)1, (int)change.getSize());
            Assertions.assertNull((Object)change.getNewElements());
            Assertions.assertEquals((int)1, (int)change.getOldElements().size());
            Assertions.assertTrue((oldElement == change.getOldElements().get(0) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testClear() {
        Random random = new Random(453L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(100);
            SpyList<Long> spyList = SpyListTest.nextSpyList(random, size);
            ArrayList changes = new ArrayList();
            spyList.addListener(changes::add);
            ArrayList<Long> oldElements = new ArrayList<Long>((Collection<Long>)spyList);
            spyList.clear();
            if (size == 0) {
                Assertions.assertEquals((int)0, (int)changes.size());
                continue;
            }
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)false, (Object)change.wasAdded());
            Assertions.assertEquals((Object)true, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)0, (int)change.getIndex());
            Assertions.assertEquals((int)oldElements.size(), (int)change.getSize());
            Assertions.assertNull((Object)change.getNewElements());
            Assertions.assertEquals(oldElements, (Object)change.getOldElements());
        }
    }

    @Test
    public void testAddAll() {
        ArrayList changes;
        SpyList<Long> spyList;
        int size;
        int i;
        Random random = new Random(453L);
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(100);
            spyList = SpyListTest.nextSpyList(random, size);
            changes = new ArrayList();
            spyList.addListener(changes::add);
            List<Long> newElements = SpyListTest.nextList(random, random.nextInt(100));
            spyList.addAll(newElements);
            if (newElements.isEmpty()) {
                Assertions.assertEquals((int)0, (int)changes.size());
                continue;
            }
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)true, (Object)change.wasAdded());
            Assertions.assertEquals((Object)false, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)(spyList.size() - newElements.size()), (int)change.getIndex());
            Assertions.assertEquals((int)newElements.size(), (int)change.getSize());
            Assertions.assertEquals(newElements, (Object)change.getNewElements());
            Assertions.assertNull((Object)change.getOldElements());
        }
        for (i = 0; i < 1000; ++i) {
            size = random.nextInt(100);
            spyList = SpyListTest.nextSpyList(random, size);
            changes = new ArrayList();
            spyList.addListener(changes::add);
            int index = random.nextInt(size + 1);
            List<Long> newElements = SpyListTest.nextList(random, random.nextInt(100));
            spyList.addAll(index, newElements);
            if (newElements.isEmpty()) {
                Assertions.assertEquals((int)0, (int)changes.size());
                continue;
            }
            Assertions.assertEquals((int)1, (int)changes.size());
            SpyList.Change change = (SpyList.Change)changes.get(0);
            Assertions.assertEquals((Object)true, (Object)change.wasAdded());
            Assertions.assertEquals((Object)false, (Object)change.wasRemoved());
            Assertions.assertEquals((Object)false, (Object)change.wasReplaced());
            Assertions.assertEquals((int)index, (int)change.getIndex());
            Assertions.assertEquals((int)newElements.size(), (int)change.getSize());
            Assertions.assertEquals(newElements, (Object)change.getNewElements());
            Assertions.assertNull((Object)change.getOldElements());
        }
    }

    public static SpyList<Long> nextSpyList(Random random, int size) {
        SpyList spyList = new SpyList();
        while (spyList.size() < size) {
            spyList.add((Object)random.nextLong());
        }
        return spyList;
    }

    public static List<Long> nextList(Random random, int size) {
        ArrayList<Long> list = new ArrayList<Long>();
        while (list.size() < size) {
            list.add(random.nextLong());
        }
        return list;
    }
}

