/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MomentOfInertiaFactory;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionResult;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimRigidBody;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.SimJointStateType;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemRandomTools;

public class SingleContactImpulseCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 2.0E-12;
    private static final double POST_IMPULSE_VELOCITY_EPSILON = 5.0E-11;
    private static final double GAMMA = 1.0E-10;

    @Test
    public void testComputeContactPointLinearVelocity() {
        Random random = new Random(4564L);
        for (int i = 0; i < 10000; ++i) {
            double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-1.0);
            double dt = random.nextDouble();
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = SimMultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            for (SimJointStateType state : SimJointStateType.values()) {
                SimMultiBodySystemRandomTools.nextState((Random)random, (SimJointStateType)state, (Iterable)joints);
            }
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((SimOneDoFJointBasics)joints.get(0)).getPredecessor());
            rootBody.updateFramesRecursively();
            SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, worldFrame, false);
            spatialAccelerationCalculator.setGravitionalAcceleration(gravity);
            SimRigidBodyBasics contactingBody = ((SimOneDoFJointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            FramePoint3D contactPoint = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)contactingBody.getBodyFixedFrame());
            FrameVector3D actualLinearVelocity = new FrameVector3D();
            SingleContactImpulseCalculator.computeContactPointLinearVelocity((double)dt, (RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)contactingBody, (RigidBodyAccelerationProvider)spatialAccelerationCalculator, (FramePoint3DReadOnly)contactPoint, (FrameVector3DBasics)actualLinearVelocity);
            for (SimOneDoFJointBasics joint : joints) {
                joint.setQd(joint.getQd() + dt * joint.getQdd());
            }
            rootBody.updateFramesRecursively();
            FrameVector3D expectedLinearVelocity = new FrameVector3D();
            contactingBody.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)contactPoint, (FrameVector3DBasics)expectedLinearVelocity);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expectedLinearVelocity, (FrameTuple3DReadOnly)actualLinearVelocity, (double)2.0E-12);
        }
    }

    @Test
    public void testComputeContactPointSpatialVelocity() {
        Random random = new Random(4564L);
        for (int i = 0; i < 10000; ++i) {
            double gravity = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-1.0);
            double dt = random.nextDouble();
            int numberOfJoints = random.nextInt(50) + 1;
            List joints = SimMultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
            for (SimJointStateType state : SimJointStateType.values()) {
                SimMultiBodySystemRandomTools.nextState((Random)random, (SimJointStateType)state, (Iterable)joints);
            }
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((SimOneDoFJointBasics)joints.get(0)).getPredecessor());
            rootBody.updateFramesRecursively();
            SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)rootBody, worldFrame, false);
            spatialAccelerationCalculator.setGravitionalAcceleration(gravity);
            SimRigidBodyBasics contactingBody = ((SimOneDoFJointBasics)joints.get(random.nextInt(numberOfJoints))).getSuccessor();
            FramePoint3D contactPoint = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)contactingBody.getBodyFixedFrame());
            SpatialVector actualSpatialVelocity = new SpatialVector();
            SingleContactImpulseCalculator.predictContactPointSpatialVelocity((double)dt, (RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)contactingBody, (RigidBodyAccelerationProvider)spatialAccelerationCalculator, (FramePoint3DReadOnly)contactPoint, (SpatialVectorBasics)actualSpatialVelocity);
            for (SimOneDoFJointBasics joint : joints) {
                joint.setQd(joint.getQd() + dt * joint.getQdd());
            }
            rootBody.updateFramesRecursively();
            SpatialVector expectedSpatialVelocity = new SpatialVector((ReferenceFrame)contactingBody.getBodyFixedFrame());
            expectedSpatialVelocity.getAngularPart().set((FrameTuple3DReadOnly)contactingBody.getBodyFixedFrame().getTwistOfFrame().getAngularPart());
            contactingBody.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)contactPoint, expectedSpatialVelocity.getLinearPart());
            MecanoTestTools.assertSpatialVectorEquals((SpatialVectorReadOnly)expectedSpatialVelocity, (SpatialVectorReadOnly)actualSpatialVelocity, (double)2.0E-12);
        }
    }

    @Test
    public void testFloatingBodyAgainstEnvironment() throws Throwable {
        Random random = new Random(57476L);
        for (int i = 0; i < 10000; ++i) {
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-6, (double)0.01);
            Vector3D gravity = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0, (double)40.0));
            SimRigidBodyBasics singleBodyA = SingleContactImpulseCalculatorTest.nextSingleFloatingRigidBody(random, "shoup");
            RigidBodyBasics rootBodyA = MultiBodySystemTools.getRootBody((RigidBodyBasics)singleBodyA);
            CollisionResult collisionResult = SingleContactImpulseCalculatorTest.nextCollisionResult(random, singleBodyA);
            ForwardDynamicsCalculator forwardDynamicsCalculatorA = SingleContactImpulseCalculatorTest.setupForwardDynamicsCalculator((Vector3DReadOnly)gravity, (RigidBodyBasics)singleBodyA);
            FrameVector3D contactLinearVelocityNoImpulse = SingleContactImpulseCalculatorTest.predictContactVelocity(dt, collisionResult, forwardDynamicsCalculatorA, null);
            double normalVelocityMagnitudePreImpulse = contactLinearVelocityNoImpulse.dot((FrameVector3DReadOnly)collisionResult.getCollisionAxisForA());
            SingleContactImpulseCalculator impulseCalculator = new SingleContactImpulseCalculator(worldFrame, rootBodyA, forwardDynamicsCalculatorA, null, null);
            impulseCalculator.setCollision(collisionResult);
            impulseCalculator.setTolerance(1.0E-10);
            impulseCalculator.setContactParameters((ContactParametersReadOnly)ContactParameters.defaultIneslasticContactParameters((boolean)false));
            impulseCalculator.initialize(dt);
            impulseCalculator.updateInertia(null, null);
            impulseCalculator.computeImpulse(dt);
            impulseCalculator.finalizeImpulse();
            SingleContactImpulseCalculatorTest.updateVelocities(impulseCalculator, dt);
            Assertions.assertEquals((Object)(normalVelocityMagnitudePreImpulse < 0.0 ? 1 : 0), (Object)impulseCalculator.isConstraintActive(), (String)("Iteration " + i));
            SingleContactImpulseCalculatorTest.assertContactResponseProperties("Iteration " + i, dt, contactLinearVelocityNoImpulse, impulseCalculator, 2.0E-12, 5.0E-11);
        }
    }

    @Test
    public void testFloatingBodyAgainstFloatingBody() throws Throwable {
        Random random = new Random(57476L);
        for (int i = 0; i < 10000; ++i) {
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-6, (double)0.01);
            Vector3D gravity = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)15.0));
            SimRigidBodyBasics singleBodyA = SingleContactImpulseCalculatorTest.nextSingleFloatingRigidBody(random, "shoup");
            SimRigidBodyBasics singleBodyB = SingleContactImpulseCalculatorTest.nextSingleFloatingRigidBody(random, "kolop");
            CollisionResult collisionResult = SingleContactImpulseCalculatorTest.nextCollisionResult(random, singleBodyA, singleBodyB);
            RigidBodyBasics rootBodyA = collisionResult.getCollidableA().getRootBody();
            RigidBodyBasics rootBodyB = collisionResult.getCollidableB().getRootBody();
            ForwardDynamicsCalculator forwardDynamicsCalculatorA = SingleContactImpulseCalculatorTest.setupForwardDynamicsCalculator((Vector3DReadOnly)gravity, (RigidBodyBasics)singleBodyA);
            ForwardDynamicsCalculator forwardDynamicsCalculatorB = SingleContactImpulseCalculatorTest.setupForwardDynamicsCalculator((Vector3DReadOnly)gravity, (RigidBodyBasics)singleBodyB);
            FrameVector3D contactLinearVelocityNoImpulse = SingleContactImpulseCalculatorTest.predictContactVelocity(dt, collisionResult, forwardDynamicsCalculatorA, forwardDynamicsCalculatorB);
            SingleContactImpulseCalculator impulseCalculator = new SingleContactImpulseCalculator(worldFrame, rootBodyA, forwardDynamicsCalculatorA, rootBodyB, forwardDynamicsCalculatorB);
            impulseCalculator.setCollision(collisionResult);
            impulseCalculator.setTolerance(1.0E-10);
            impulseCalculator.setContactParameters((ContactParametersReadOnly)ContactParameters.defaultIneslasticContactParameters((boolean)false));
            impulseCalculator.initialize(dt);
            impulseCalculator.updateInertia(null, null);
            try {
                impulseCalculator.computeImpulse(dt);
            }
            catch (IllegalStateException e) {
                throw new AssertionFailedError("Failed at iteration " + i, (Throwable)e);
            }
            impulseCalculator.finalizeImpulse();
            SingleContactImpulseCalculatorTest.updateVelocities(impulseCalculator, dt);
            double normalVelocityMagnitudePreImpulse = contactLinearVelocityNoImpulse.dot((FrameVector3DReadOnly)collisionResult.getCollisionAxisForA());
            Assertions.assertEquals((Object)(normalVelocityMagnitudePreImpulse < 0.0 ? 1 : 0), (Object)impulseCalculator.isConstraintActive(), (String)("Iteration " + i));
            SingleContactImpulseCalculatorTest.assertContactResponseProperties("Iteration " + i, dt, contactLinearVelocityNoImpulse, impulseCalculator, 2.0E-12, 5.0E-11);
        }
    }

    @Test
    public void testFlyingCollidingSpheres() {
        Random random = new Random(9030112133717752657L);
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setCoefficientOfRestitution(1.0);
        contactParameters.setMinimumPenetration(5.0E-5);
        for (int i = 0; i < 10000; ++i) {
            double dt = 0.001;
            SimRigidBodyBasics sphereBodyA = SingleContactImpulseCalculatorTest.nextFloatingSphereBody(random, "sphereBodyA");
            SimRigidBodyBasics sphereBodyB = SingleContactImpulseCalculatorTest.nextFloatingSphereBody(random, "sphereBodyB");
            FloatingJointBasics rootJointA = (FloatingJointBasics)sphereBodyA.getParentJoint();
            FloatingJointBasics rootJointB = (FloatingJointBasics)sphereBodyB.getParentJoint();
            double massA = sphereBodyA.getInertia().getMass();
            double massB = sphereBodyB.getInertia().getMass();
            double radiusA = random.nextDouble();
            double radiusB = random.nextDouble();
            Collidable sphereCollidableA = new Collidable((RigidBodyBasics)sphereBodyA, -1L, -1L, (FrameShape3DReadOnly)new FrameSphere3D((ReferenceFrame)sphereBodyA.getBodyFixedFrame(), radiusA));
            Collidable sphereCollidableB = new Collidable((RigidBodyBasics)sphereBodyB, -1L, -1L, (FrameShape3DReadOnly)new FrameSphere3D((ReferenceFrame)sphereBodyB.getBodyFixedFrame(), radiusB));
            Point3DBasics positionA = rootJointA.getJointPose().getPosition();
            Point3DBasics positionB = rootJointB.getJointPose().getPosition();
            positionA.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(radiusA + radiusB - contactParameters.getMinimumPenetration()));
            positionB.add((Tuple3DReadOnly)positionA, (Tuple3DReadOnly)translation);
            CollisionResult collisionResult = new CollisionResult();
            collisionResult.setCollidableA(sphereCollidableA);
            collisionResult.setCollidableB(sphereCollidableB);
            FrameUnitVector3D collisionAxis = collisionResult.getCollisionAxisForA();
            collisionAxis.setReferenceFrame(worldFrame);
            collisionAxis.setAndNegate((Tuple3DReadOnly)translation);
            Vector3D sphereAInitialVelocity = new Vector3D();
            sphereAInitialVelocity.setAndScale(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)collisionAxis);
            Vector3D sphereBInitialVelocity = new Vector3D();
            rootJointA.getJointTwist().getLinearPart().set((Tuple3DReadOnly)sphereAInitialVelocity);
            rootJointB.getJointTwist().getLinearPart().set((Tuple3DReadOnly)sphereBInitialVelocity);
            rootJointA.updateFramesRecursively();
            rootJointB.updateFramesRecursively();
            collisionResult.getPointOnARootFrame().setReferenceFrame(worldFrame);
            collisionResult.getPointOnBRootFrame().setReferenceFrame(worldFrame);
            collisionResult.getPointOnARootFrame().scaleAdd(-radiusA, (FrameTuple3DReadOnly)collisionAxis, (Tuple3DReadOnly)positionA);
            collisionResult.getPointOnBRootFrame().scaleAdd(radiusB, (FrameTuple3DReadOnly)collisionAxis, (Tuple3DReadOnly)positionB);
            collisionResult.getCollisionData().getPointOnA().setIncludingFrame((FrameTuple3DReadOnly)collisionResult.getPointOnARootFrame());
            collisionResult.getCollisionData().getPointOnB().setIncludingFrame((FrameTuple3DReadOnly)collisionResult.getPointOnBRootFrame());
            collisionResult.getCollisionData().getPointOnA().changeFrame((ReferenceFrame)sphereBodyA.getBodyFixedFrame());
            collisionResult.getCollisionData().getPointOnB().changeFrame((ReferenceFrame)sphereBodyB.getBodyFixedFrame());
            ForwardDynamicsCalculator forwardDynamicsCalculatorA = new ForwardDynamicsCalculator((RigidBodyReadOnly)sphereCollidableA.getRootBody());
            ForwardDynamicsCalculator forwardDynamicsCalculatorB = new ForwardDynamicsCalculator((RigidBodyReadOnly)sphereCollidableB.getRootBody());
            SingleContactImpulseCalculator calculator = new SingleContactImpulseCalculator(worldFrame, sphereCollidableA.getRootBody(), forwardDynamicsCalculatorA, sphereCollidableB.getRootBody(), forwardDynamicsCalculatorB);
            forwardDynamicsCalculatorA.compute();
            forwardDynamicsCalculatorB.compute();
            calculator.setCollision(collisionResult);
            calculator.setTolerance(1.0E-10);
            calculator.setContactParameters((ContactParametersReadOnly)contactParameters);
            calculator.initialize(dt);
            calculator.updateInertia(null, null);
            calculator.computeImpulse(dt);
            calculator.finalizeImpulse();
            SingleContactImpulseCalculatorTest.updateVelocities(calculator, dt);
            Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)rootJointA.getJointTwist().getAngularPart(), (double)1.0E-5), (String)("Iteration: " + i + ", non-zero angular velocity, magnitude: " + rootJointA.getJointTwist().getAngularPart().length()));
            Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)rootJointB.getJointTwist().getAngularPart(), (double)1.0E-5), (String)("Iteration: " + i + ", non-zero angular velocity, magnitude: " + rootJointB.getJointTwist().getAngularPart().length()));
            Vector3D sphereAFinalVelocity = new Vector3D();
            Vector3D sphereBFinalVelocity = new Vector3D();
            sphereAFinalVelocity.setAndScale(massA - massB, (Tuple3DReadOnly)sphereAInitialVelocity);
            sphereAFinalVelocity.scaleAdd(2.0 * massB, (Tuple3DReadOnly)sphereBInitialVelocity, (Tuple3DReadOnly)sphereAFinalVelocity);
            sphereAFinalVelocity.scale(1.0 / (massA + massB));
            sphereBFinalVelocity.setAndScale(2.0 * massA, (Tuple3DReadOnly)sphereAInitialVelocity);
            sphereBFinalVelocity.scaleAdd(massB - massA, (Tuple3DReadOnly)sphereBInitialVelocity, (Tuple3DReadOnly)sphereBFinalVelocity);
            sphereBFinalVelocity.scale(1.0 / (massA + massB));
            EuclidCoreTestTools.assertTuple3DEquals((String)("Iteration: " + i), (Tuple3DReadOnly)sphereAFinalVelocity, (Tuple3DReadOnly)rootJointA.getJointTwist().getLinearPart(), (double)2.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((String)("Iteration: " + i), (Tuple3DReadOnly)sphereBFinalVelocity, (Tuple3DReadOnly)rootJointB.getJointTwist().getLinearPart(), (double)2.0E-12);
        }
    }

    public static void assertContactResponseProperties(String messagePrefix, double dt, FrameVector3D contactLinearVelocityNoImpulse, SingleContactImpulseCalculator impulseCalculator, double epsilon, double postImpulseVelocityEpsilon) throws Throwable {
        CollisionResult collisionResult = impulseCalculator.getCollisionResult();
        FrameUnitVector3D collisionAxisForA = collisionResult.getCollisionAxisForA();
        SimRigidBodyBasics bodyA = (SimRigidBodyBasics)collisionResult.getCollidableA().getRigidBody();
        SimRigidBodyBasics bodyB = (SimRigidBodyBasics)collisionResult.getCollidableB().getRigidBody();
        DMatrixRMaj jointVelocityChangeA = impulseCalculator.getJointVelocityChangeA();
        DMatrixRMaj jointVelocityChangeB = impulseCalculator.getJointVelocityChangeB();
        double normalVelocityMagnitudePreImpulse = contactLinearVelocityNoImpulse.dot((FrameVector3DReadOnly)collisionAxisForA);
        if (impulseCalculator.isConstraintActive()) {
            boolean isSticking;
            FrameVector3D contactLinearVelocityPostImpulse = SingleContactImpulseCalculatorTest.computeContactVelocity(dt, collisionResult);
            double normalVelocityPostImpulse = contactLinearVelocityPostImpulse.dot((FrameVector3DReadOnly)collisionAxisForA);
            Assertions.assertEquals((double)0.0, (double)normalVelocityPostImpulse, (double)(Math.max(1.0, Math.abs(normalVelocityMagnitudePreImpulse)) * postImpulseVelocityEpsilon), (String)messagePrefix);
            Assertions.assertEquals((Object)bodyA.getBodyFixedFrame(), (Object)impulseCalculator.getImpulseA().getBodyFrame());
            FrameVector3D impulseOnA = new FrameVector3D((FrameTuple3DReadOnly)impulseCalculator.getImpulseA().getLinearPart());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((String)messagePrefix, (Tuple3DReadOnly)impulseCalculator.getImpulseA().getAngularPart());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((String)messagePrefix, (Tuple3DReadOnly)impulseCalculator.getImpulseB().getAngularPart());
            if (bodyB != null) {
                Assertions.assertEquals((Object)bodyB.getBodyFixedFrame(), (Object)impulseCalculator.getImpulseB().getBodyFrame());
                FrameVector3D impulseOnB = new FrameVector3D((FrameTuple3DReadOnly)impulseCalculator.getImpulseB().getLinearPart());
                impulseOnB.changeFrame(impulseOnA.getReferenceFrame());
                impulseOnB.negate();
                EuclidCoreTestTools.assertTuple3DEquals((String)messagePrefix, (Tuple3DReadOnly)impulseOnA, (Tuple3DReadOnly)impulseOnB, (double)epsilon);
            } else {
                EuclidCoreTestTools.assertTuple3DIsSetToZero((String)messagePrefix, (Tuple3DReadOnly)impulseCalculator.getImpulseB().getLinearPart());
            }
            FrameVector3D impulseNormal = SingleContactImpulseCalculatorTest.extractNormalPart((FrameVector3DReadOnly)impulseOnA, (FrameVector3DReadOnly)collisionAxisForA);
            FrameVector3D impulseTangential = SingleContactImpulseCalculatorTest.extractTangentialPart((FrameVector3DReadOnly)impulseOnA, (FrameVector3DReadOnly)collisionAxisForA);
            impulseNormal.changeFrame(worldFrame);
            impulseTangential.changeFrame(worldFrame);
            boolean bl = isSticking = impulseTangential.length() < (impulseCalculator.getContactParameters().getCoefficientOfFriction() - epsilon) * impulseNormal.length();
            if (isSticking) {
                Assertions.assertEquals((double)0.0, (double)contactLinearVelocityPostImpulse.length(), (double)(Math.max(1.0, contactLinearVelocityNoImpulse.length()) * postImpulseVelocityEpsilon), (String)messagePrefix);
            } else {
                Assertions.assertEquals((double)impulseTangential.length(), (double)(impulseCalculator.getContactParameters().getCoefficientOfFriction() * impulseNormal.length()), (double)(Math.max(1.0, Math.abs(impulseTangential.length())) * epsilon), (String)messagePrefix);
                FrameVector3D tangentialVelocityPostImpulse = SingleContactImpulseCalculatorTest.extractTangentialPart((FrameVector3DReadOnly)contactLinearVelocityPostImpulse, (FrameVector3DReadOnly)collisionAxisForA);
                try {
                    Assertions.assertTrue((impulseTangential.dot((FrameVector3DReadOnly)tangentialVelocityPostImpulse) < 0.0 ? 1 : 0) != 0, (String)(messagePrefix + ", " + impulseTangential.dot((FrameVector3DReadOnly)tangentialVelocityPostImpulse)));
                }
                catch (Throwable e) {
                    impulseCalculator.printForUnitTest();
                    throw e;
                }
            }
        } else {
            Assertions.assertNull((Object)jointVelocityChangeA, (String)messagePrefix);
            if (bodyB != null) {
                Assertions.assertNull((Object)jointVelocityChangeB, (String)messagePrefix);
            }
        }
        if (bodyB == null) {
            Assertions.assertNull((Object)jointVelocityChangeB);
        }
    }

    public static ForwardDynamicsCalculator setupForwardDynamicsCalculator(Vector3DReadOnly gravity, RigidBodyBasics rigidBody) {
        ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody));
        forwardDynamicsCalculator.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
        forwardDynamicsCalculator.compute();
        return forwardDynamicsCalculator;
    }

    static CollisionResult nextCollisionResult(Random random, SimRigidBodyBasics contactingBodyA) {
        return SingleContactImpulseCalculatorTest.nextCollisionResult(random, contactingBodyA, null);
    }

    static CollisionResult nextCollisionResult(Random random, SimRigidBodyBasics contactingBodyA, SimRigidBodyBasics contactingBodyB) {
        CollisionResult collisionResult = new CollisionResult();
        collisionResult.setCollidableA(SingleContactImpulseCalculatorTest.nextCollidable(random, contactingBodyA));
        FrameUnitVector3D collisionAxisForA = collisionResult.getCollisionAxisForA();
        FramePoint3D pointInBodyFrameA = collisionResult.getCollisionData().getPointOnA();
        FramePoint3D pointInBodyFrameB = collisionResult.getCollisionData().getPointOnB();
        FramePoint3D pointOnARootFrame = collisionResult.getPointOnARootFrame();
        FramePoint3D pointOnBRootFrame = collisionResult.getPointOnBRootFrame();
        collisionAxisForA.setIncludingFrame(worldFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0));
        pointInBodyFrameA.setIncludingFrame((FrameTuple3DReadOnly)SingleContactImpulseCalculatorTest.nextPointWithinRadiusOfCoM(random, worldFrame, (RigidBodyBasics)contactingBodyA, 0.5));
        pointOnARootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointInBodyFrameA);
        pointInBodyFrameA.changeFrame((ReferenceFrame)contactingBodyA.getBodyFixedFrame());
        if (contactingBodyB != null) {
            collisionResult.setCollidableB(SingleContactImpulseCalculatorTest.nextCollidable(random, contactingBodyB));
            pointInBodyFrameB.setIncludingFrame((FrameTuple3DReadOnly)pointInBodyFrameA);
            pointOnBRootFrame.setIncludingFrame((FrameTuple3DReadOnly)pointInBodyFrameB);
            pointOnBRootFrame.changeFrame(worldFrame);
            pointInBodyFrameB.changeFrame((ReferenceFrame)contactingBodyB.getBodyFixedFrame());
        } else {
            collisionResult.setCollidableB(SingleContactImpulseCalculatorTest.nextStaticCollidable(random));
        }
        return collisionResult;
    }

    public static FrameVector3D computeContactVelocity(double dt, CollisionResult collisionResult) {
        return SingleContactImpulseCalculatorTest.predictContactVelocity(dt, collisionResult, null, null);
    }

    static FrameVector3D predictContactVelocity(double dt, CollisionResult collisionResult, ForwardDynamicsCalculator forwardDynamicsCalculatorA, ForwardDynamicsCalculator forwardDynamicsCalculatorB) {
        RigidBodyBasics singleBodyA = collisionResult.getCollidableA().getRigidBody();
        FramePoint3D pointInBodyFrameA = collisionResult.getCollisionData().getPointOnA();
        FrameVector3D contactLinearVelocityPreImpulse = forwardDynamicsCalculatorA != null ? SingleContactImpulseCalculatorTest.computeBodyPointVelocity(dt, singleBodyA, pointInBodyFrameA, forwardDynamicsCalculatorA.getAccelerationProvider(false)) : SingleContactImpulseCalculatorTest.computeBodyPointVelocity(dt, singleBodyA, pointInBodyFrameA);
        RigidBodyBasics singleBodyB = collisionResult.getCollidableB().getRigidBody();
        if (singleBodyB != null) {
            FramePoint3D pointInBodyFrameB = collisionResult.getCollisionData().getPointOnB();
            if (forwardDynamicsCalculatorB != null) {
                contactLinearVelocityPreImpulse.sub((FrameTuple3DReadOnly)SingleContactImpulseCalculatorTest.computeBodyPointVelocity(dt, singleBodyB, pointInBodyFrameB, forwardDynamicsCalculatorB.getAccelerationProvider(false)));
            } else {
                contactLinearVelocityPreImpulse.sub((FrameTuple3DReadOnly)SingleContactImpulseCalculatorTest.computeBodyPointVelocity(dt, singleBodyB, pointInBodyFrameB));
            }
        }
        return contactLinearVelocityPreImpulse;
    }

    static void updateVelocities(SingleContactImpulseCalculator impulseCalculator, double dt) {
        if (!impulseCalculator.isConstraintActive()) {
            return;
        }
        SingleContactImpulseCalculatorTest.updateJointVelocities(dt, impulseCalculator.getContactingBodyA(), impulseCalculator.getForwardDynamicsCalculatorA(), impulseCalculator.getJointVelocityChangeA());
        if (impulseCalculator.getContactingBodyB() != null) {
            SingleContactImpulseCalculatorTest.updateJointVelocities(dt, impulseCalculator.getContactingBodyB(), impulseCalculator.getForwardDynamicsCalculatorB(), impulseCalculator.getJointVelocityChangeB());
        }
    }

    static void updateJointVelocities(double dt, RigidBodyBasics rigidBody, ForwardDynamicsCalculator forwardDynamicsCalculator, DMatrixRMaj jointVelocityChange) {
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody);
        List<JointBasics> joints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{rootBody}));
        DMatrixRMaj jointVelocityMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom(joints), 1);
        MultiBodySystemTools.extractJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocityMatrix);
        CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (DMatrixD1)jointVelocityChange);
        CommonOps_DDRM.addEquals((DMatrixD1)jointVelocityMatrix, (double)dt, (DMatrixD1)forwardDynamicsCalculator.getJointAccelerationMatrix());
        MultiBodySystemTools.insertJointsState(joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocityMatrix);
        rootBody.updateFramesRecursively();
    }

    static FrameVector3D computeBodyPointVelocity(double dt, RigidBodyBasics rigidBody, FramePoint3D bodyFixedPoint) {
        return SingleContactImpulseCalculatorTest.computeBodyPointVelocity(dt, rigidBody, bodyFixedPoint, null);
    }

    static FrameVector3D computeBodyPointVelocity(double dt, RigidBodyBasics rigidBody, FramePoint3D bodyFixedPoint, RigidBodyAccelerationProvider noVelocityRigidBodyAccelerationProvider) {
        FrameVector3D contactLinearVelocity = new FrameVector3D();
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)rigidBody);
        if (noVelocityRigidBodyAccelerationProvider != null) {
            SingleContactImpulseCalculator.computeContactPointLinearVelocity((double)dt, (RigidBodyReadOnly)rootBody, (RigidBodyReadOnly)rigidBody, (RigidBodyAccelerationProvider)noVelocityRigidBodyAccelerationProvider, (FramePoint3DReadOnly)bodyFixedPoint, (FrameVector3DBasics)contactLinearVelocity);
        } else {
            rigidBody.getBodyFixedFrame().getTwistOfFrame().getLinearVelocityAt((FramePoint3DReadOnly)bodyFixedPoint, (FrameVector3DBasics)contactLinearVelocity);
        }
        contactLinearVelocity.changeFrame(worldFrame);
        return contactLinearVelocity;
    }

    static FrameVector3D extractNormalPart(FrameVector3DReadOnly input, FrameVector3DReadOnly normalAxis) {
        FrameVector3D axisCopy = new FrameVector3D((FrameTuple3DReadOnly)normalAxis);
        axisCopy.changeFrame(input.getReferenceFrame());
        FrameVector3D normalPart = new FrameVector3D(input.getReferenceFrame());
        normalPart.setAndScale(input.dot((FrameVector3DReadOnly)axisCopy), (FrameTuple3DReadOnly)axisCopy);
        return normalPart;
    }

    static FrameVector3D extractTangentialPart(FrameVector3DReadOnly input, FrameVector3DReadOnly normalAxis) {
        FrameVector3D axisCopy = new FrameVector3D((FrameTuple3DReadOnly)normalAxis);
        axisCopy.changeFrame(input.getReferenceFrame());
        FrameVector3D tangentialPart = new FrameVector3D(input.getReferenceFrame());
        tangentialPart.sub((FrameTuple3DReadOnly)input, (FrameTuple3DReadOnly)SingleContactImpulseCalculatorTest.extractNormalPart(input, normalAxis));
        return tangentialPart;
    }

    static FramePoint3D nextPointWithinRadiusOfCoM(Random random, ReferenceFrame referenceFrame, RigidBodyBasics rigidBody, double radius) {
        FramePoint3D next = new FramePoint3D((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3DWithFixedLength((Random)random, (ReferenceFrame)rigidBody.getBodyFixedFrame(), (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)radius)));
        next.changeFrame(referenceFrame);
        return next;
    }

    static SimRigidBodyBasics nextSingleFloatingRigidBody(Random random, String name) {
        SimRigidBody rootBody = new SimRigidBody(name + "RootBody", worldFrame, null);
        SimSixDoFJoint floatingJoint = SimMultiBodySystemRandomTools.nextSixDoFJoint((Random)random, (String)(name + "RootJoint"), (SimRigidBodyBasics)rootBody);
        SimRigidBody floatingBody = SimMultiBodySystemRandomTools.nextRigidBody((Random)random, (String)(name + "Body"), (SimJointBasics)floatingJoint);
        floatingJoint.setSuccessor((RigidBodyBasics)floatingBody);
        floatingJoint.getJointPose().set((Pose3DReadOnly)EuclidGeometryRandomTools.nextPose3D((Random)random));
        floatingJoint.getJointTwist().set((SpatialVectorReadOnly)MecanoRandomTools.nextSpatialVector((Random)random, (ReferenceFrame)floatingJoint.getFrameAfterJoint()));
        double density = 8000.0 * random.nextDouble();
        Vector3D size = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        double mass = density * size.getX() * size.getY() * size.getZ();
        floatingBody.getInertia().setMass(mass);
        floatingBody.getInertia().getMomentOfInertia().set((Matrix3DReadOnly)MomentOfInertiaFactory.solidBox((double)mass, (Tuple3DReadOnly)size));
        rootBody.updateFramesRecursively();
        return floatingBody;
    }

    static SimRigidBodyBasics nextFloatingSphereBody(Random random, String name) {
        SimRigidBody rootBody = new SimRigidBody(name + "RootBody", worldFrame, null);
        SimSixDoFJoint floatingJoint = SimMultiBodySystemRandomTools.nextSixDoFJoint((Random)random, (String)(name + "RootJoint"), (SimRigidBodyBasics)rootBody);
        double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)1.0);
        double mass = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
        Matrix3D inertia = MomentOfInertiaFactory.solidSphere((double)mass, (double)radius);
        SimRigidBody floatingBody = new SimRigidBody(name + "Body", (SimJointBasics)floatingJoint, (Matrix3DReadOnly)inertia, mass, (Tuple3DReadOnly)EuclidCoreTools.zeroVector3D);
        floatingJoint.setSuccessor((RigidBodyBasics)floatingBody);
        return floatingBody;
    }

    public static Collidable nextStaticCollidable(Random random) {
        return new Collidable(null, -1L, -1L, (FrameShape3DReadOnly)EuclidFrameShapeRandomTools.nextFrameShape3D((Random)random, (ReferenceFrame)worldFrame));
    }

    public static Collidable nextCollidable(Random random, SimRigidBodyBasics rigidBody) {
        FrameShape3DBasics shape = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)rigidBody.getBodyFixedFrame(), (Tuple3DReadOnly)rigidBody.getInertia().getCenterOfMassOffset());
        return new Collidable((RigidBodyBasics)rigidBody, -1L, -1L, (FrameShape3DReadOnly)shape);
    }
}

