/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class CropBufferRequest {
    private final int from;
    private final int to;

    public CropBufferRequest(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public CropBufferRequest(CropBufferRequest other) {
        this.from = other.from;
        this.to = other.to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getCroppedSize(int originalBufferSize) {
        return SharedMemoryTools.computeSubLength(this.from, this.to, originalBufferSize);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CropBufferRequest) {
            CropBufferRequest other = (CropBufferRequest)object;
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
        return false;
    }

    public String toString() {
        return "from: " + this.from + ", to: " + this.to;
    }
}

