/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SharedMemoryTestTools {
    public static void assertYoSharedBufferEquals(YoSharedBuffer expected, YoSharedBuffer actual, double epsilon) {
        SharedMemoryTestTools.assertYoSharedBufferEquals(null, expected, actual, epsilon);
    }

    public static void assertYoSharedBufferEquals(String messagePrefix, YoSharedBuffer expected, YoSharedBuffer actual, double epsilon) {
        if (expected == null) {
            if (actual != null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
        } else {
            if (actual == null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            SharedMemoryTestTools.assertYoRegistryEquals(expected.getRootRegistry(), actual.getRootRegistry());
            if (expected.getRegistryBuffer().getYoVariableBuffers().size() != actual.getRegistryBuffer().getYoVariableBuffers().size()) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            for (int i = 0; i < expected.getRegistryBuffer().getYoVariableBuffers().size(); ++i) {
                SharedMemoryTestTools.assertYoVariableBufferEquals(messagePrefix, expected.getRegistryBuffer().getYoVariableBuffers().get(i), actual.getRegistryBuffer().getYoVariableBuffers().get(i), epsilon);
            }
        }
    }

    public static void assertYoVariableBufferEquals(YoVariableBuffer<?> expected, YoVariableBuffer<?> actual, double epsilon) {
        SharedMemoryTestTools.assertYoVariableBufferEquals(null, expected, actual, epsilon);
    }

    public static void assertYoVariableBufferEquals(String messagePrefix, YoVariableBuffer<?> expected, YoVariableBuffer<?> actual, double epsilon) {
        if (expected == null) {
            if (actual != null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
        } else {
            if (actual == null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            SharedMemoryTestTools.assertYoVariableEquals(expected.getYoVariable(), actual.getYoVariable());
            if (expected instanceof YoBooleanBuffer) {
                SharedMemoryTestTools.assertYoBooleanBufferDataEquals(messagePrefix, (YoBooleanBuffer)expected, (YoBooleanBuffer)actual, epsilon);
            } else if (expected instanceof YoDoubleBuffer) {
                SharedMemoryTestTools.assertYoDoubleBufferDataEquals(messagePrefix, (YoDoubleBuffer)expected, (YoDoubleBuffer)actual, epsilon);
            } else if (expected instanceof YoIntegerBuffer) {
                SharedMemoryTestTools.assertYoIntegerBufferDataEquals(messagePrefix, (YoIntegerBuffer)expected, (YoIntegerBuffer)actual, epsilon);
            } else if (expected instanceof YoLongBuffer) {
                SharedMemoryTestTools.assertYoLongBufferDataEquals(messagePrefix, (YoLongBuffer)expected, (YoLongBuffer)actual, epsilon);
            } else if (expected instanceof YoEnumBuffer) {
                SharedMemoryTestTools.assertYoEnumBufferDataEquals(messagePrefix, (YoEnumBuffer)expected, (YoEnumBuffer)actual, epsilon);
            } else {
                throw new IllegalArgumentException("Unsupported buffer type: " + String.valueOf(expected));
            }
        }
    }

    private static void assertYoBooleanBufferDataEquals(String messagePrefix, YoBooleanBuffer expected, YoBooleanBuffer actual, double epsilon) {
        if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
            SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
        }
        int expectedReadIndex = expected.getProperties().getInPoint();
        int actualReadIndex = actual.getProperties().getInPoint();
        for (int i = 0; i < expected.getProperties().getActiveBufferLength(); ++i) {
            if (expected.getBuffer()[expectedReadIndex] != actual.getBuffer()[actualReadIndex]) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            expectedReadIndex = SharedMemoryTools.increment(expectedReadIndex, 1, expected.getProperties().getSize());
            actualReadIndex = SharedMemoryTools.increment(actualReadIndex, 1, actual.getProperties().getSize());
        }
    }

    private static void assertYoDoubleBufferDataEquals(String messagePrefix, YoDoubleBuffer expected, YoDoubleBuffer actual, double epsilon) {
        if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
            SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
        }
        int expectedReadIndex = expected.getProperties().getInPoint();
        int actualReadIndex = actual.getProperties().getInPoint();
        for (int i = 0; i < expected.getProperties().getActiveBufferLength(); ++i) {
            if (!EuclidCoreTools.epsilonEquals((double)expected.getBuffer()[expectedReadIndex], (double)actual.getBuffer()[actualReadIndex], (double)epsilon)) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            expectedReadIndex = SharedMemoryTools.increment(expectedReadIndex, 1, expected.getProperties().getSize());
            actualReadIndex = SharedMemoryTools.increment(actualReadIndex, 1, actual.getProperties().getSize());
        }
    }

    private static void assertYoIntegerBufferDataEquals(String messagePrefix, YoIntegerBuffer expected, YoIntegerBuffer actual, double epsilon) {
        if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
            SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
        }
        int expectedReadIndex = expected.getProperties().getInPoint();
        int actualReadIndex = actual.getProperties().getInPoint();
        for (int i = 0; i < expected.getProperties().getActiveBufferLength(); ++i) {
            if (expected.getBuffer()[expectedReadIndex] != actual.getBuffer()[actualReadIndex]) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            expectedReadIndex = SharedMemoryTools.increment(expectedReadIndex, 1, expected.getProperties().getSize());
            actualReadIndex = SharedMemoryTools.increment(actualReadIndex, 1, actual.getProperties().getSize());
        }
    }

    private static void assertYoLongBufferDataEquals(String messagePrefix, YoLongBuffer expected, YoLongBuffer actual, double epsilon) {
        if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
            SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
        }
        int expectedReadIndex = expected.getProperties().getInPoint();
        int actualReadIndex = actual.getProperties().getInPoint();
        for (int i = 0; i < expected.getProperties().getActiveBufferLength(); ++i) {
            if (expected.getBuffer()[expectedReadIndex] != actual.getBuffer()[actualReadIndex]) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            expectedReadIndex = SharedMemoryTools.increment(expectedReadIndex, 1, expected.getProperties().getSize());
            actualReadIndex = SharedMemoryTools.increment(actualReadIndex, 1, actual.getProperties().getSize());
        }
    }

    private static void assertYoEnumBufferDataEquals(String messagePrefix, YoEnumBuffer<?> expected, YoEnumBuffer<?> actual, double epsilon) {
        if (expected.getProperties().getActiveBufferLength() != actual.getProperties().getActiveBufferLength()) {
            SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
        }
        int expectedReadIndex = expected.getProperties().getInPoint();
        int actualReadIndex = actual.getProperties().getInPoint();
        for (int i = 0; i < expected.getProperties().getActiveBufferLength(); ++i) {
            if (expected.getBuffer()[expectedReadIndex] != actual.getBuffer()[actualReadIndex]) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            expectedReadIndex = SharedMemoryTools.increment(expectedReadIndex, 1, expected.getProperties().getSize());
            actualReadIndex = SharedMemoryTools.increment(actualReadIndex, 1, actual.getProperties().getSize());
        }
    }

    public static void assertYoBufferPropertiesEquals(YoBufferPropertiesReadOnly expected, YoBufferPropertiesReadOnly actual) {
        SharedMemoryTestTools.assertYoBufferPropertiesEquals(null, expected, actual);
    }

    public static void assertYoBufferPropertiesEquals(String messagePrefix, YoBufferPropertiesReadOnly expected, YoBufferPropertiesReadOnly actual) {
        if (!expected.equals(actual)) {
            EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expected.toString(), (String)actual.toString());
        }
    }

    public static void assertYoRegistryEquals(YoRegistry expected, YoRegistry actual) {
        SharedMemoryTestTools.assertYoRegistryEquals(null, expected, actual);
    }

    public static void assertYoRegistryEquals(String messagePrefix, YoRegistry expected, YoRegistry actual) {
        if (expected == null) {
            if (actual != null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
        } else {
            int i;
            if (actual == null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (!Objects.equals(expected.getName(), actual.getName())) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (expected.getVariables().size() != actual.getVariables().size()) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            for (i = 0; i < expected.getNumberOfVariables(); ++i) {
                YoVariable expectedVariable = expected.getVariable(i);
                YoVariable actualVariable = actual.getVariable(expectedVariable.getName());
                SharedMemoryTestTools.assertYoVariableEquals(messagePrefix, expectedVariable, actualVariable);
            }
            if (expected.getChildren().size() != actual.getChildren().size()) {
                EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expected.toString(), (String)actual.toString());
            }
            for (i = 0; i < expected.getChildren().size(); ++i) {
                YoRegistry expectedChild = (YoRegistry)expected.getChildren().get(i);
                YoRegistry actualChild = actual.getChildren().stream().filter(child -> child.getName().equals(expectedChild.getName())).findFirst().orElse(null);
                SharedMemoryTestTools.assertYoRegistryEquals(messagePrefix, expectedChild, actualChild);
            }
        }
    }

    public static void assertYoVariableEquals(YoVariable expected, YoVariable actual) {
        SharedMemoryTestTools.assertYoVariableEquals(null, expected, actual);
    }

    public static void assertYoVariableEquals(String messagePrefix, YoVariable expected, YoVariable actual) {
        if (expected == null) {
            if (actual != null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
        } else {
            if (actual == null) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (!Objects.equals(expected.getType(), actual.getType())) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (!Objects.equals(expected.getName(), actual.getName())) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
            if (!Objects.equals(expected.getDescription(), actual.getDescription())) {
                SharedMemoryTestTools.throwNotEqualAssertionError(messagePrefix, expected, actual);
            }
        }
    }

    private static void throwNotEqualAssertionError(String messagePrefix, YoRegistry expected, YoRegistry actual) {
        String expectedAsString = SharedMemoryTestTools.getYoRegistryString(expected);
        String actualAsString = SharedMemoryTestTools.getYoRegistryString(actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, YoVariable expected, YoVariable actual) {
        String expectedAsString = SharedMemoryTestTools.getYoVariableString(expected);
        String actualAsString = SharedMemoryTestTools.getYoVariableString(actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, YoVariableBuffer<?> expected, YoVariableBuffer<?> actual) {
        String expectedAsString = SharedMemoryTestTools.getYoVariableBufferString(expected);
        String actualAsString = SharedMemoryTestTools.getYoVariableBufferString(actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    private static void throwNotEqualAssertionError(String messagePrefix, YoSharedBuffer expected, YoSharedBuffer actual) {
        String expectedAsString = SharedMemoryTestTools.getYoSharedBufferString(expected);
        String actualAsString = SharedMemoryTestTools.getYoSharedBufferString(actual);
        EuclidCoreTestTools.throwNotEqualAssertionError((String)messagePrefix, (String)expectedAsString, (String)actualAsString);
    }

    public static String getYoRegistryString(YoRegistry yoRegistry) {
        if (yoRegistry == null) {
            return "null";
        }
        return yoRegistry.getClass().getSimpleName() + ", name: " + yoRegistry.getName() + ", variables: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", (Collection)yoRegistry.getVariables(), YoVariable::getName) + ", children: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", (Collection)yoRegistry.getChildren(), YoRegistry::getName);
    }

    public static String getYoVariableString(YoVariable yoVariable) {
        if (yoVariable == null) {
            return "null";
        }
        return yoVariable.getClass().getSimpleName() + ", name: " + yoVariable.getName() + ", description: " + yoVariable.getDescription();
    }

    public static String getYoSharedBufferString(YoSharedBuffer yoSharedBuffer) {
        if (yoSharedBuffer == null) {
            return "null";
        }
        return "properties: " + String.valueOf(yoSharedBuffer.getProperties()) + ", root registry: " + SharedMemoryTestTools.getYoRegistryString(yoSharedBuffer.getRootRegistry()) + ", buffers: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", yoSharedBuffer.getRegistryBuffer().getYoVariableBuffers(), b -> b.getYoVariable().getName());
    }

    public static String getYoVariableBufferString(YoVariableBuffer<?> yoVariableBuffer) {
        if (yoVariableBuffer == null) {
            return "null";
        }
        Object bufferAsString = yoVariableBuffer instanceof YoBooleanBuffer ? Arrays.toString((boolean[])yoVariableBuffer.getBuffer()) : (yoVariableBuffer instanceof YoDoubleBuffer ? Arrays.toString((double[])yoVariableBuffer.getBuffer()) : (yoVariableBuffer instanceof YoIntegerBuffer ? Arrays.toString((int[])yoVariableBuffer.getBuffer()) : (yoVariableBuffer instanceof YoLongBuffer ? Arrays.toString((long[])yoVariableBuffer.getBuffer()) : (yoVariableBuffer instanceof YoEnumBuffer ? Arrays.toString((byte[])yoVariableBuffer.getBuffer()) : "Unknow type: " + String.valueOf(yoVariableBuffer.getBuffer())))));
        return yoVariableBuffer.getClass().getSimpleName() + ", variable [" + SharedMemoryTestTools.getYoVariableString(yoVariableBuffer.getYoVariable()) + "], buffer properties: [" + String.valueOf(yoVariableBuffer.getProperties()) + "], buffer: " + (String)bufferAsString;
    }
}

