/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Arrays;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class BufferSample<D> {
    private final int from;
    private final int to;
    private final D sample;
    private final int sampleLength;
    private final YoBufferPropertiesReadOnly bufferProperties;

    public BufferSample(int from, D sample, int sampleLength, YoBufferPropertiesReadOnly bufferProperties) {
        this.from = from;
        this.sample = sample;
        this.sampleLength = sampleLength;
        this.bufferProperties = bufferProperties;
        this.to = SharedMemoryTools.computeToIndex(from, sampleLength, bufferProperties.getSize());
    }

    public BufferSample(BufferSample<D> other) {
        this.from = other.from;
        this.sample = other.sample;
        this.sampleLength = other.sampleLength;
        this.bufferProperties = other.bufferProperties;
        this.to = SharedMemoryTools.computeToIndex(this.from, this.sampleLength, this.bufferProperties.getSize());
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public D getSample() {
        return this.sample;
    }

    public int getSampleLength() {
        return this.sampleLength;
    }

    public YoBufferPropertiesReadOnly getBufferProperties() {
        return this.bufferProperties;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BufferSample) {
            BufferSample other = (BufferSample)object;
            if (this.from != other.from) {
                return false;
            }
            if (this.sampleLength != other.sampleLength) {
                return false;
            }
            if (!this.bufferProperties.equals(other.bufferProperties)) {
                return false;
            }
            return BufferSample.sampleEquals(this.sample, other.sample);
        }
        return false;
    }

    static boolean sampleEquals(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        if (!expected.getClass().isArray()) {
            throw new IllegalArgumentException("The argument \"expected\" is not an array.");
        }
        if (!actual.getClass().isArray()) {
            throw new IllegalArgumentException("The argument \"actual\" is not an array.");
        }
        if (expected.getClass() != actual.getClass()) {
            return false;
        }
        if (expected.getClass().getComponentType() == Boolean.TYPE) {
            return Arrays.equals((boolean[])expected, (boolean[])actual);
        }
        if (expected.getClass().getComponentType() == Double.TYPE) {
            return Arrays.equals((double[])expected, (double[])actual);
        }
        if (expected.getClass().getComponentType() == Integer.TYPE) {
            return Arrays.equals((int[])expected, (int[])actual);
        }
        if (expected.getClass().getComponentType() == Long.TYPE) {
            return Arrays.equals((long[])expected, (long[])actual);
        }
        if (expected.getClass().getComponentType() == Byte.TYPE) {
            return Arrays.equals((byte[])expected, (byte[])actual);
        }
        throw new IllegalStateException("Unhandled array type: " + String.valueOf(expected.getClass().getComponentType()));
    }

    public String toString() {
        return "from: " + this.from + ", sample length: " + this.sampleLength + ", type: " + String.valueOf(this.sample.getClass().getComponentType());
    }
}

