/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.tools;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;
import us.ihmc.scs2.definition.yoVariable.YoBooleanDefinition;
import us.ihmc.scs2.definition.yoVariable.YoDoubleDefinition;
import us.ihmc.scs2.definition.yoVariable.YoEnumDefinition;
import us.ihmc.scs2.definition.yoVariable.YoIntegerDefinition;
import us.ihmc.scs2.definition.yoVariable.YoLongDefinition;
import us.ihmc.scs2.definition.yoVariable.YoRegistryDefinition;
import us.ihmc.scs2.definition.yoVariable.YoVariableDefinition;
import us.ihmc.scs2.sharedMemory.YoBooleanBuffer;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoEnumBuffer;
import us.ihmc.scs2.sharedMemory.YoIntegerBuffer;
import us.ihmc.scs2.sharedMemory.YoLongBuffer;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class SharedMemoryIOTools {
    public static final int MATLAB_VARNAME_MAX_LENGTH = 63;
    public static final int MATLAB_VARNAME_OVERFLOW_SUFFIX_CHARS = 3;
    private static JAXBContext yoRegistryContext = null;

    public static JAXBContext getYoRegistryContext() {
        if (yoRegistryContext == null) {
            try {
                yoRegistryContext = JAXBContext.newInstance((Class[])new Class[]{YoRegistryDefinition.class, YoVariableDefinition.class, YoBooleanDefinition.class, YoDoubleDefinition.class, YoIntegerDefinition.class, YoLongDefinition.class, YoEnumDefinition.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException("Problem creating the JAXBContext.", e);
            }
        }
        return yoRegistryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YoRegistryDefinition loadYoRegistryDefinition(InputStream inputStream) throws JAXBException, IOException {
        try {
            JAXBContext context = SharedMemoryIOTools.getYoRegistryContext();
            Unmarshaller unmarshaller = context.createUnmarshaller();
            YoRegistryDefinition yoRegistryDefinition = (YoRegistryDefinition)unmarshaller.unmarshal(inputStream);
            return yoRegistryDefinition;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveYoRegistryDefinition(OutputStream outputStream, YoRegistryDefinition definition) throws JAXBException, IOException {
        try {
            JAXBContext context = SharedMemoryIOTools.getYoRegistryContext();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)definition, outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public static YoRegistryDefinition toYoRegistryDefinition(YoRegistry yoRegistry) {
        return SharedMemoryIOTools.toYoRegistryDefinition(yoRegistry, null, null);
    }

    public static YoRegistryDefinition toYoRegistryDefinition(YoRegistry yoRegistry, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) {
        YoRegistryDefinition definition = new YoRegistryDefinition();
        definition.setName(yoRegistry.getName());
        Stream<Object> variablesStream = yoRegistry.getVariables().stream();
        if (variableFilter != null) {
            variablesStream = variablesStream.filter(variableFilter);
        }
        definition.setYoVariables(variablesStream.map(SharedMemoryIOTools::toYoVariableDefinition).collect(Collectors.toList()));
        Stream<Object> childrenStream = yoRegistry.getChildren().stream();
        if (registryFilter != null) {
            childrenStream = childrenStream.filter(registryFilter);
        }
        definition.setYoRegistries(childrenStream.map(childRegistry -> SharedMemoryIOTools.toYoRegistryDefinition(childRegistry, variableFilter, registryFilter)).collect(Collectors.toList()));
        return definition;
    }

    public static YoVariableDefinition toYoVariableDefinition(YoVariable yoVariable) {
        YoBooleanDefinition definition = null;
        if (yoVariable instanceof YoBoolean) {
            definition = new YoBooleanDefinition();
        } else if (yoVariable instanceof YoDouble) {
            definition = new YoDoubleDefinition();
        } else if (yoVariable instanceof YoInteger) {
            definition = new YoIntegerDefinition();
        } else if (yoVariable instanceof YoLong) {
            definition = new YoLongDefinition();
        } else if (yoVariable instanceof YoEnum) {
            YoEnumDefinition enumDefinition = new YoEnumDefinition();
            enumDefinition.setAllowNullValue(((YoEnum)yoVariable).isNullAllowed());
            enumDefinition.setEnumValuesAsString(((YoEnum)yoVariable).getEnumValuesAsString());
            definition = enumDefinition;
        } else {
            throw new UnsupportedOperationException("Unsupported yoVariable type: " + yoVariable);
        }
        definition.setName(yoVariable.getName());
        definition.setNamespace(yoVariable.getNamespace().toString());
        definition.setDescription(yoVariable.getDescription());
        definition.setLowerBound(yoVariable.getLowerBound());
        definition.setUpperBound(yoVariable.getUpperBound());
        return definition;
    }

    public static YoRegistry toYoRegistry(YoRegistryDefinition definition) {
        YoRegistry yoRegistry = new YoRegistry(definition.getName());
        if (definition.getYoVariables() != null) {
            definition.getYoVariables().forEach(varDefinition -> yoRegistry.addVariable(SharedMemoryIOTools.toYoVariable(varDefinition)));
        }
        if (definition.getYoRegistries() != null) {
            definition.getYoRegistries().forEach(regDefinition -> yoRegistry.addChild(SharedMemoryIOTools.toYoRegistry(regDefinition)));
        }
        return yoRegistry;
    }

    public static YoVariable toYoVariable(YoVariableDefinition definition) {
        YoBoolean yoVariable = null;
        String name = definition.getName();
        String description = definition.getDescription();
        if (definition instanceof YoBooleanDefinition) {
            yoVariable = new YoBoolean(name, description, null);
        } else if (definition instanceof YoDoubleDefinition) {
            yoVariable = new YoDouble(name, description, null);
        } else if (definition instanceof YoIntegerDefinition) {
            yoVariable = new YoInteger(name, description, null);
        } else if (definition instanceof YoLongDefinition) {
            yoVariable = new YoLong(name, description, null);
        } else if (definition instanceof YoEnumDefinition) {
            yoVariable = new YoEnum(name, description, null, ((YoEnumDefinition)definition).isAllowNullValue(), ((YoEnumDefinition)definition).getEnumValuesAsString());
        } else {
            throw new UnsupportedOperationException("Unsupported definition type: " + definition);
        }
        yoVariable.setVariableBounds(definition.getLowerBound(), definition.getUpperBound());
        return yoVariable;
    }

    public static void exportRegistry(YoRegistry rootRegistry, OutputStream outputStream) throws JAXBException, IOException {
        SharedMemoryIOTools.exportRegistry(rootRegistry, outputStream, null, null);
    }

    public static void exportRegistry(YoRegistry rootRegistry, OutputStream outputStream, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) throws JAXBException, IOException {
        SharedMemoryIOTools.saveYoRegistryDefinition(outputStream, SharedMemoryIOTools.toYoRegistryDefinition(rootRegistry, variableFilter, registryFilter));
    }

    public static void exportDataASCII(YoSharedBuffer buffer, OutputStream dataOutputStream) {
        SharedMemoryIOTools.exportDataASCII(buffer, dataOutputStream, null, null);
    }

    public static void exportDataASCII(YoSharedBuffer buffer, OutputStream outputStream, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) {
        Stream<Object> yoVariableBufferStream;
        if (registryFilter != null) {
            List filteredRegistries = YoSearchTools.filterRegistries(registryFilter, (YoRegistry)buffer.getRootRegistry());
            yoVariableBufferStream = filteredRegistries.stream().flatMap(registry -> registry.getVariables().stream()).map(yoVariable -> buffer.getRegistryBuffer().findYoVariableBuffer((YoVariable)yoVariable));
        } else {
            yoVariableBufferStream = buffer.getRegistryBuffer().getYoVariableBuffers().stream();
        }
        if (variableFilter != null) {
            yoVariableBufferStream = yoVariableBufferStream.filter(yoVariableBuffer -> variableFilter.test((YoVariable)yoVariableBuffer.getYoVariable()));
        }
        PrintStream printStream = new PrintStream(outputStream);
        YoBufferPropertiesReadOnly properties = buffer.getProperties();
        int inPoint = properties.getInPoint();
        int activeBufferLength = properties.getActiveBufferLength();
        yoVariableBufferStream.forEach(yoVariableBuffer -> {
            String variableName = yoVariableBuffer.getYoVariable().getFullNameString();
            printStream.append(variableName).append(": ");
            printStream.println(SharedMemoryIOTools.arrayToString(yoVariableBuffer.copy(inPoint, activeBufferLength, properties).getSample()));
        });
        printStream.close();
    }

    public static void exportDataCSV(YoSharedBuffer buffer, OutputStream dataOutputStream) {
        SharedMemoryIOTools.exportDataCSV(buffer, dataOutputStream, null, null);
    }

    public static void exportDataCSV(YoSharedBuffer buffer, OutputStream outputStream, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) {
        Stream<Object> yoVariableBufferStream;
        if (registryFilter != null) {
            List filteredRegistries = YoSearchTools.filterRegistries(registryFilter, (YoRegistry)buffer.getRootRegistry());
            yoVariableBufferStream = filteredRegistries.stream().flatMap(registry -> registry.getVariables().stream()).map(yoVariable -> buffer.getRegistryBuffer().findYoVariableBuffer((YoVariable)yoVariable));
        } else {
            yoVariableBufferStream = buffer.getRegistryBuffer().getYoVariableBuffers().stream();
        }
        if (variableFilter != null) {
            yoVariableBufferStream = yoVariableBufferStream.filter(yoVariableBuffer -> variableFilter.test((YoVariable)yoVariableBuffer.getYoVariable()));
        }
        PrintStream printStream = new PrintStream(outputStream);
        YoVariableBuffer[] yoVariableBuffersToExport = (YoVariableBuffer[])yoVariableBufferStream.toArray(YoVariableBuffer[]::new);
        for (int bufferIndex = 0; bufferIndex < yoVariableBuffersToExport.length; ++bufferIndex) {
            printStream.print(yoVariableBuffersToExport[bufferIndex].getYoVariable().getFullNameString());
            if (bufferIndex < yoVariableBuffersToExport.length - 1) {
                printStream.print(", ");
                continue;
            }
            printStream.println();
        }
        YoBufferPropertiesReadOnly properties = buffer.getProperties();
        int readPosition = properties.getInPoint();
        IntConsumer[] bufferValueWriters = (IntConsumer[])Stream.of(yoVariableBuffersToExport).map(yoVariableBuffer -> {
            Object internalBuffer = yoVariableBuffer.getBuffer();
            if (yoVariableBuffer instanceof YoBooleanBuffer) {
                boolean[] booleanBuffer = (boolean[])internalBuffer;
                return position -> printStream.print(booleanBuffer[position]);
            }
            if (yoVariableBuffer instanceof YoDoubleBuffer) {
                double[] doubleBuffer = (double[])internalBuffer;
                return position -> printStream.print(doubleBuffer[position]);
            }
            if (yoVariableBuffer instanceof YoIntegerBuffer) {
                int[] intBuffer = (int[])internalBuffer;
                return position -> printStream.print(intBuffer[position]);
            }
            if (yoVariableBuffer instanceof YoLongBuffer) {
                long[] longBuffer = (long[])internalBuffer;
                return position -> printStream.print(longBuffer[position]);
            }
            if (yoVariableBuffer instanceof YoEnumBuffer) {
                byte[] byteBuffer = (byte[])internalBuffer;
                String[] enumConstants = ((YoEnum)yoVariableBuffer.getYoVariable()).getEnumValuesAsString();
                return position -> printStream.print(byteBuffer[position] == -1 ? "null" : enumConstants[byteBuffer[position]]);
            }
            throw new IllegalArgumentException("Unhandled buffer type: " + yoVariableBuffer);
        }).toArray(IntConsumer[]::new);
        for (int i = 0; i < properties.getActiveBufferLength(); ++i) {
            for (int bufferIndex = 0; bufferIndex < yoVariableBuffersToExport.length; ++bufferIndex) {
                bufferValueWriters[bufferIndex].accept(readPosition);
                if (bufferIndex < yoVariableBuffersToExport.length - 1) {
                    printStream.print(", ");
                    continue;
                }
                printStream.println();
            }
            readPosition = SharedMemoryTools.increment(readPosition, 1, properties.getSize());
        }
        printStream.close();
    }

    public static void exportDataMatlab(YoSharedBuffer buffer, File outputFile) throws IOException {
        SharedMemoryIOTools.exportDataMatlab(buffer, outputFile, null, null);
    }

    public static void exportDataMatlab(YoSharedBuffer buffer, File outputFile, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) throws IOException {
        Stream<Object> yoVariableBufferStream;
        YoRegistry rootRegistry = buffer.getRootRegistry();
        if (registryFilter != null) {
            List filteredRegistries = YoSearchTools.filterRegistries(registryFilter, (YoRegistry)rootRegistry);
            yoVariableBufferStream = filteredRegistries.stream().flatMap(registry -> registry.getVariables().stream()).map(yoVariable -> buffer.getRegistryBuffer().findYoVariableBuffer((YoVariable)yoVariable));
        } else {
            yoVariableBufferStream = buffer.getRegistryBuffer().getYoVariableBuffers().stream();
        }
        if (variableFilter != null) {
            yoVariableBufferStream = yoVariableBufferStream.filter(yoVariableBuffer -> variableFilter.test((YoVariable)yoVariableBuffer.getYoVariable()));
        }
        Mat5File matFile = Mat5.newMatFile();
        Struct rootStruct = Mat5.newStruct();
        matFile.addArray(rootRegistry.getName(), (Array)rootStruct);
        Struct nameHelperStruct = Mat5.newStruct();
        matFile.addArray("NameOverflow", (Array)nameHelperStruct);
        HashMap nameOverflowCounter = new HashMap();
        HashMap renamedRegistryMap = new HashMap();
        yoVariableBufferStream.forEach(yoVariableBuffer -> {
            YoBufferPropertiesReadOnly properties = yoVariableBuffer.getProperties();
            Struct parentStruct = rootStruct;
            Object yoVariable = yoVariableBuffer.getYoVariable();
            if (yoVariable.getRegistry() != rootRegistry) {
                YoNamespace parentNamespace = yoVariable.getNamespace();
                for (int i = 1; i < parentNamespace.size(); ++i) {
                    Struct childStruct;
                    YoNamespace ancestorNamespace = parentNamespace.subNamespace(0, i + 1);
                    String subName = renamedRegistryMap.containsKey(ancestorNamespace) ? (String)renamedRegistryMap.get(ancestorNamespace) : ancestorNamespace.getShortName();
                    try {
                        childStruct = parentStruct.getStruct(subName);
                    }
                    catch (IllegalArgumentException e) {
                        childStruct = Mat5.newStruct();
                        String registryStructName = SharedMemoryIOTools.checkAndRegisterLongName(subName, nameOverflowCounter, nameHelperStruct);
                        renamedRegistryMap.put(ancestorNamespace, registryStructName);
                        parentStruct.set(registryStructName, (Array)childStruct);
                    }
                    parentStruct = childStruct;
                }
            }
            String variableStructName = SharedMemoryIOTools.checkAndRegisterLongName(yoVariableBuffer.getYoVariable().getName(), nameOverflowCounter, nameHelperStruct);
            Matrix matMatrix = Mat5.newMatrix((int)properties.getActiveBufferLength(), (int)1);
            SharedMemoryIOTools.writeBuffer(yoVariableBuffer.getBuffer(), matMatrix, properties.getInPoint(), properties.getActiveBufferLength());
            parentStruct.set(variableStructName, (Array)matMatrix);
        });
        Mat5.writeToFile((MatFile)matFile, (File)outputFile);
        rootStruct.close();
    }

    private static String checkAndRegisterLongName(String name, Map<String, MutableInt> nameOverflowCounter, Struct nameHelperStruct) {
        int idSuffix;
        if (name.length() <= 63) {
            return name;
        }
        String shortenedName = name.substring(0, 60);
        String matlabFieldName = shortenedName + (idSuffix = nameOverflowCounter.computeIfAbsent(name, n -> new MutableInt(0)).getAndIncrement());
        if (matlabFieldName.length() > 63) {
            throw new RuntimeException("Too many instances of shortened variable name " + shortenedName);
        }
        Matrix nameMatrix = Mat5.newMatrix((int)name.length(), (int)1);
        for (int i = 0; i < name.length(); ++i) {
            nameMatrix.setInt(i, (int)name.charAt(i));
        }
        nameHelperStruct.set(matlabFieldName, (Array)nameMatrix);
        return matlabFieldName;
    }

    private static void writeBuffer(Object buffer, Matrix matrix, int start, int length) {
        int readingPosition = start;
        if (buffer instanceof boolean[]) {
            boolean[] booleanBuffer = (boolean[])buffer;
            for (int i = 0; i < length; ++i) {
                matrix.setBoolean(i, booleanBuffer[readingPosition]);
                readingPosition = SharedMemoryTools.increment(readingPosition, 1, booleanBuffer.length);
            }
        } else if (buffer instanceof double[]) {
            double[] doubleBuffer = (double[])buffer;
            for (int i = 0; i < length; ++i) {
                matrix.setDouble(i, doubleBuffer[readingPosition]);
                readingPosition = SharedMemoryTools.increment(readingPosition, 1, doubleBuffer.length);
            }
        } else if (buffer instanceof int[]) {
            int[] intBuffer = (int[])buffer;
            for (int i = 0; i < length; ++i) {
                matrix.setInt(i, intBuffer[readingPosition]);
                readingPosition = SharedMemoryTools.increment(readingPosition, 1, intBuffer.length);
            }
        } else if (buffer instanceof long[]) {
            long[] longBuffer = (long[])buffer;
            for (int i = 0; i < length; ++i) {
                matrix.setLong(i, longBuffer[readingPosition]);
                readingPosition = SharedMemoryTools.increment(readingPosition, 1, longBuffer.length);
            }
        } else if (buffer instanceof byte[]) {
            byte[] byteBuffer = (byte[])buffer;
            for (int i = 0; i < length; ++i) {
                matrix.setByte(i, byteBuffer[readingPosition]);
                readingPosition = SharedMemoryTools.increment(readingPosition, 1, byteBuffer.length);
            }
        } else {
            throw new IllegalArgumentException("Unsupported buffer type: " + buffer);
        }
    }

    private static String arrayToString(Object array) {
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        throw new IllegalArgumentException("Unsupported type: " + array);
    }

    public static YoRegistry importRegistry(InputStream inputStream) throws JAXBException, IOException {
        return SharedMemoryIOTools.toYoRegistry(SharedMemoryIOTools.loadYoRegistryDefinition(inputStream));
    }

    public static YoSharedBuffer importDataASCII(InputStream inputStream, YoRegistry root) throws IOException {
        return SharedMemoryIOTools.importDataASCII(inputStream, new YoSharedBuffer(root, 1));
    }

    public static YoSharedBuffer importDataASCII(InputStream inputStream, YoSharedBuffer buffer) throws IOException {
        YoRegistry root = buffer.getRootRegistry();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.lines().forEach(line -> {
            int seperatorIndex = line.indexOf(":");
            String variableName = line.substring(0, seperatorIndex).trim();
            String data = line.substring(seperatorIndex, line.length());
            YoVariable yoVariable = root.findVariable(variableName);
            YoVariableBuffer<?> yoVariableBuffer = buffer.getRegistryBuffer().findYoVariableBuffer(yoVariable);
            data = data.substring(data.indexOf("[") + 1, data.lastIndexOf("]"));
            String[] values = data.split(", ");
            SharedMemoryIOTools.setActiveBuffer(buffer, values.length);
            if (yoVariable instanceof YoBoolean) {
                for (int i = 0; i < values.length; ++i) {
                    ((boolean[])yoVariableBuffer.getBuffer())[i] = Boolean.parseBoolean(values[i]);
                }
            } else if (yoVariable instanceof YoDouble) {
                for (int i = 0; i < values.length; ++i) {
                    ((double[])yoVariableBuffer.getBuffer())[i] = Double.parseDouble(values[i]);
                }
            } else if (yoVariable instanceof YoInteger) {
                for (int i = 0; i < values.length; ++i) {
                    ((int[])yoVariableBuffer.getBuffer())[i] = Integer.parseInt(values[i]);
                }
            } else if (yoVariable instanceof YoLong) {
                for (int i = 0; i < values.length; ++i) {
                    ((long[])yoVariableBuffer.getBuffer())[i] = Long.parseLong(values[i]);
                }
            } else if (yoVariable instanceof YoEnum) {
                for (int i = 0; i < values.length; ++i) {
                    ((byte[])yoVariableBuffer.getBuffer())[i] = Byte.parseByte(values[i]);
                }
            } else {
                throw new IllegalArgumentException("Unexpected value: " + yoVariable);
            }
        });
        bufferedReader.close();
        return buffer;
    }

    public static YoSharedBuffer importDataCSV(InputStream inputStream, YoRegistry root) throws IOException {
        return SharedMemoryIOTools.importDataCSV(inputStream, new YoSharedBuffer(root, 1));
    }

    public static YoSharedBuffer importDataCSV(InputStream inputStream, YoSharedBuffer buffer) throws IOException {
        YoRegistry root = buffer.getRootRegistry();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String currentLine = bufferedReader.readLine();
        int currentPosition = 0;
        String[] variableNames = currentLine.split(", ");
        ObjIntConsumer[] bufferValueReaders = (ObjIntConsumer[])Stream.of(variableNames).map(variableName -> {
            YoVariable yoVariable = root.findVariable(variableName);
            YoVariableBuffer<?> yoVariableBuffer = buffer.getRegistryBuffer().findYoVariableBuffer(yoVariable);
            if (yoVariableBuffer instanceof YoBooleanBuffer) {
                return (value, position) -> {
                    ((boolean[])yoVariableBuffer.getBuffer())[position] = Boolean.parseBoolean(value);
                };
            }
            if (yoVariableBuffer instanceof YoDoubleBuffer) {
                return (value, position) -> {
                    ((double[])yoVariableBuffer.getBuffer())[position] = Double.parseDouble(value);
                };
            }
            if (yoVariableBuffer instanceof YoIntegerBuffer) {
                return (value, position) -> {
                    ((int[])yoVariableBuffer.getBuffer())[position] = Integer.parseInt(value);
                };
            }
            if (yoVariableBuffer instanceof YoLongBuffer) {
                return (value, position) -> {
                    ((long[])yoVariableBuffer.getBuffer())[position] = Long.parseLong(value);
                };
            }
            if (yoVariableBuffer instanceof YoEnumBuffer) {
                List<String> enumConstants = Arrays.asList(((YoEnum)yoVariable).getEnumValuesAsString());
                return (value, position) -> {
                    ((byte[])yoVariableBuffer.getBuffer())[position] = Objects.equals(value, "null") ? -1 : (byte)enumConstants.indexOf(value);
                };
            }
            throw new IllegalArgumentException("Unhandled buffer type: " + yoVariableBuffer);
        }).toArray(ObjIntConsumer[]::new);
        if (buffer.getProperties().getSize() < 64) {
            buffer.resizeBuffer(64);
        }
        while ((currentLine = bufferedReader.readLine()) != null) {
            if (currentPosition >= buffer.getProperties().getSize()) {
                buffer.resizeBuffer(2 * buffer.getProperties().getSize());
            }
            String[] currentValues = currentLine.split(", ");
            for (int bufferIndex = 0; bufferIndex < bufferValueReaders.length; ++bufferIndex) {
                bufferValueReaders[bufferIndex].accept(currentValues[bufferIndex], currentPosition);
            }
            ++currentPosition;
        }
        buffer.setInPoint(0);
        buffer.setOutPoint(currentPosition - 1);
        bufferedReader.close();
        return buffer;
    }

    public static YoSharedBuffer importDataMatlab(File inputFile, YoRegistry root) throws IOException {
        return SharedMemoryIOTools.importDataMatlab(inputFile, new YoSharedBuffer(root, 1));
    }

    public static YoSharedBuffer importDataMatlab(File inputFile, YoSharedBuffer buffer) throws IOException {
        YoRegistry root = buffer.getRootRegistry();
        Mat5File mat5File = Mat5.readFromFile((File)inputFile);
        ArrayList<MatFile.Entry> entries = new ArrayList<MatFile.Entry>();
        for (MatFile.Entry entry : mat5File.getEntries()) {
            entries.add(entry);
        }
        if (entries.size() == 0) {
            throw new IllegalArgumentException("Empty data structure");
        }
        if (entries.size() > 2) {
            throw new IllegalArgumentException("Unexpected number of structs");
        }
        MatFile.Entry entry = (MatFile.Entry)entries.get(0);
        if (!entry.getName().equals(root.getName())) {
            throw new IllegalArgumentException("Registry name mismatch");
        }
        Struct rootStruct = (Struct)entry.getValue();
        Struct nameHelperStruct = entries.size() == 2 ? (Struct)((MatFile.Entry)entries.get(1)).getValue() : null;
        SharedMemoryIOTools.importMatlabStruct(rootStruct, root, buffer, nameHelperStruct);
        return buffer;
    }

    private static void importMatlabStruct(Struct matlabStruct, YoRegistry parentRegistry, YoSharedBuffer buffer, Struct nameHelperStruct) {
        for (String rawFieldName : matlabStruct.getFieldNames()) {
            String fieldName = SharedMemoryIOTools.checkAndRetrieveLongName(rawFieldName, nameHelperStruct);
            Array field = matlabStruct.get(rawFieldName);
            if (field instanceof Matrix) {
                YoVariable variable = parentRegistry.getVariable(fieldName);
                if (variable == null) {
                    throw new IllegalArgumentException("Could not find the variable " + fieldName + " in " + parentRegistry);
                }
                SharedMemoryIOTools.importMatlabMatrix(variable, (Matrix)field, buffer);
                continue;
            }
            if (!(field instanceof Struct)) continue;
            YoRegistry registry = parentRegistry.findRegistry(new YoNamespace(fieldName));
            SharedMemoryIOTools.importMatlabStruct((Struct)field, registry, buffer, nameHelperStruct);
        }
    }

    private static String checkAndRetrieveLongName(String fieldName, Struct nameHelperStruct) {
        if (nameHelperStruct == null) {
            return fieldName;
        }
        try {
            Matrix matrix = nameHelperStruct.getMatrix(fieldName);
            StringBuilder fullName = new StringBuilder();
            for (int i = 0; i < matrix.getNumRows(); ++i) {
                fullName.append((char)matrix.getInt(i));
            }
            return fullName.toString();
        }
        catch (IllegalArgumentException e) {
            return fieldName;
        }
    }

    private static void importMatlabMatrix(YoVariable variable, Matrix matlabMatrix, YoSharedBuffer buffer) {
        int size = matlabMatrix.getNumRows();
        SharedMemoryIOTools.setActiveBuffer(buffer, size);
        if (variable instanceof YoBoolean) {
            YoBooleanBuffer variableBuffer = (YoBooleanBuffer)buffer.getRegistryBuffer().findYoVariableBuffer(variable);
            for (int i = 0; i < size; ++i) {
                variableBuffer.getBuffer()[i] = matlabMatrix.getBoolean(i);
            }
        } else if (variable instanceof YoDouble) {
            YoDoubleBuffer variableBuffer = (YoDoubleBuffer)buffer.getRegistryBuffer().findYoVariableBuffer(variable);
            for (int i = 0; i < size; ++i) {
                variableBuffer.getBuffer()[i] = matlabMatrix.getDouble(i);
            }
        } else if (variable instanceof YoInteger) {
            YoIntegerBuffer variableBuffer = (YoIntegerBuffer)buffer.getRegistryBuffer().findYoVariableBuffer(variable);
            for (int i = 0; i < size; ++i) {
                variableBuffer.getBuffer()[i] = matlabMatrix.getInt(i);
            }
        } else if (variable instanceof YoLong) {
            YoLongBuffer variableBuffer = (YoLongBuffer)buffer.getRegistryBuffer().findYoVariableBuffer(variable);
            for (int i = 0; i < size; ++i) {
                variableBuffer.getBuffer()[i] = matlabMatrix.getLong(i);
            }
        } else if (variable instanceof YoEnum) {
            YoEnumBuffer variableBuffer = (YoEnumBuffer)buffer.getRegistryBuffer().findYoVariableBuffer(variable);
            for (int i = 0; i < size; ++i) {
                variableBuffer.getBuffer()[i] = matlabMatrix.getByte(i);
            }
        } else {
            throw new IllegalStateException("Unexpected variable type.");
        }
    }

    private static void setActiveBuffer(YoSharedBuffer buffer, int newSize) {
        if (newSize > buffer.getProperties().getSize()) {
            buffer.resizeBuffer(newSize);
        }
        buffer.setInPoint(0);
        buffer.setOutPoint(newSize - 1);
    }

    public static void main(String[] args) {
        String a = "3289";
        String b = "thisIsAWord";
        Integer.parseInt(a);
        Integer.parseInt(b);
    }

    public static enum DataFormat {
        ASCII(".scs2.ascii"),
        CSV(".scs2.csv"),
        MATLAB(".scs2.mat");

        private final String fileExtension;

        private DataFormat(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public static DataFormat fromFilename(String filename) {
            if (filename == null) {
                return null;
            }
            for (DataFormat dataFormat : DataFormat.values()) {
                if (!filename.endsWith(dataFormat.getFileExtension())) continue;
                return dataFormat;
            }
            return null;
        }
    }
}

