/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class FillBufferRequest {
    private final boolean zeroFill;
    private final int from;
    private final int to;

    public FillBufferRequest(boolean zeroFill, int from, int to) {
        this.zeroFill = zeroFill;
        this.from = from;
        this.to = to;
    }

    public boolean getZeroFill() {
        return this.zeroFill;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getFilledSize(int originalBufferSize) {
        return SharedMemoryTools.computeSubLength(this.from, this.to, originalBufferSize);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FillBufferRequest) {
            FillBufferRequest other = (FillBufferRequest)object;
            if (this.zeroFill != other.zeroFill) {
                return false;
            }
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
        return false;
    }

    public String toString() {
        return "zeroFill: " + this.zeroFill + ", from: " + this.from + ", to: " + this.to;
    }
}

