/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.interfaces;

import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public interface YoBufferPropertiesReadOnly {
    public int getSize();

    public int getCurrentIndex();

    public int getInPoint();

    public int getOutPoint();

    default public int getActiveBufferLength() {
        return SharedMemoryTools.computeSubLength(this.getInPoint(), this.getOutPoint(), this.getSize());
    }

    default public boolean isIndexBetweenBounds(int indexToCheck) {
        return SharedMemoryTools.isInsideBounds(indexToCheck, this.getInPoint(), this.getOutPoint(), this.getSize());
    }

    default public YoBufferPropertiesReadOnly copy() {
        final int size = this.getSize();
        final int currentIndex = this.getCurrentIndex();
        final int inPoint = this.getInPoint();
        final int outPoint = this.getOutPoint();
        return new YoBufferPropertiesReadOnly(){

            @Override
            public int getSize() {
                return size;
            }

            @Override
            public int getCurrentIndex() {
                return currentIndex;
            }

            @Override
            public int getInPoint() {
                return inPoint;
            }

            @Override
            public int getOutPoint() {
                return outPoint;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof YoBufferPropertiesReadOnly) {
                    return this.equals((YoBufferPropertiesReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return "Size " + size + ", index " + currentIndex + ", in-point " + inPoint + ", out-point " + outPoint;
            }
        };
    }

    default public boolean equals(YoBufferPropertiesReadOnly other) {
        if (other == null) {
            return false;
        }
        if (this.getCurrentIndex() != other.getCurrentIndex()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getInPoint() != other.getInPoint()) {
            return false;
        }
        return this.getOutPoint() == other.getOutPoint();
    }
}

