/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoEnumBuffer<E extends Enum<E>>
extends YoVariableBuffer<YoEnum<E>> {
    private byte[] buffer;

    public YoEnumBuffer(YoEnum<E> yoEnum, YoBufferPropertiesReadOnly properties) {
        super(yoEnum, properties);
        this.buffer = new byte[properties.getSize()];
    }

    @Override
    public void resizeBuffer(int from, int length) {
        if (from == 0 && length == this.buffer.length) {
            return;
        }
        this.buffer = SharedMemoryTools.ringArrayCopy(this.buffer, from, length);
    }

    @Override
    public void writeBufferAt(int index) {
        this.buffer[index] = (byte)((YoEnum)this.yoVariable).getOrdinal();
    }

    @Override
    public void readBufferAt(int index) {
        ((YoEnum)this.yoVariable).set((int)this.buffer[index]);
    }

    @Override
    long getValueAsLongBits(int index) {
        return this.buffer[index];
    }

    @Override
    public BufferSample<byte[]> copy(int from, int length, YoBufferPropertiesReadOnly properties) {
        return new BufferSample<byte[]>(from, SharedMemoryTools.ringArrayCopy(this.buffer, from, length), length, properties);
    }

    @Override
    public void fillBuffer(boolean zeroFill, int from, int length) {
        SharedMemoryTools.ringArrayFill(this.buffer, zeroFill ? (byte)0 : (byte)((YoEnum)this.yoVariable).getOrdinal(), from, length);
    }

    @Override
    LinkedYoEnum<E> newLinkedYoVariable(YoEnum<E> variableToLink, Object initialUser) {
        return new LinkedYoEnum<E>(variableToLink, this, initialUser);
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public double[] getAsDoubleBuffer() {
        return SharedMemoryTools.toDoubleArray(this.buffer);
    }

    @Override
    public void dispose() {
        this.buffer = null;
    }
}

