/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBufferList;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoRegistryBuffer {
    private final YoRegistry rootRegistry;
    private final YoVariableBufferList yoVariableBuffers = new YoVariableBufferList();
    private final Map<String, YoVariableBuffer<?>> yoVariableFullnameToBufferMap = new HashMap();
    private final YoBufferPropertiesReadOnly properties;
    private final YoRegistryChangedListener registryBufferUpdater;
    private final ReentrantLock lock = new ReentrantLock();

    public YoRegistryBuffer(YoRegistry rootRegistry, YoBufferPropertiesReadOnly properties) {
        this.rootRegistry = rootRegistry;
        this.properties = properties;
        for (YoVariable yoVariable : rootRegistry.collectSubtreeVariables()) {
            this.registerNewYoVariable(yoVariable);
        }
        this.registryBufferUpdater = change -> {
            if (change.wasVariableAdded()) {
                this.registerNewYoVariable(change.getTargetVariable());
            }
            if (change.wasRegistryAdded()) {
                this.registerNewYoVariables(change.getTargetRegistry().collectSubtreeVariables());
            }
        };
        this.rootRegistry.addListener(this.registryBufferUpdater);
    }

    private void registerNewYoVariables(Collection<? extends YoVariable> yoVariables) {
        for (YoVariable yoVariable : yoVariables) {
            this.registerNewYoVariable(yoVariable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewYoVariable(YoVariable yoVariable) {
        String fullName = yoVariable.getFullNameString();
        if (this.yoVariableFullnameToBufferMap.containsKey(fullName)) {
            return;
        }
        YoVariableBuffer<?> yoVariableBuffer = YoVariableBuffer.newYoVariableBuffer(yoVariable, this.properties);
        this.lock.lock();
        try {
            this.yoVariableBuffers.add(yoVariableBuffer);
            this.yoVariableFullnameToBufferMap.put(fullName, yoVariableBuffer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resizeBuffer(int from, int length) {
        this.yoVariableBuffers.resizeBuffer(from, length);
    }

    public void fillBuffer(boolean zeroFill, int from, int length) {
        this.yoVariableBuffers.fillBuffer(zeroFill, from, length);
    }

    public void writeBuffer() {
        this.writeBufferAt(this.properties.getCurrentIndex());
    }

    public void writeBufferAt(int index) {
        this.yoVariableBuffers.writeBufferAt(index);
    }

    public void readBuffer() {
        this.readBufferAt(this.properties.getCurrentIndex());
    }

    public void readBufferAt(int index) {
        this.yoVariableBuffers.readBufferAt(index);
    }

    public List<YoVariableBuffer<?>> getYoVariableBuffers() {
        return this.yoVariableBuffers;
    }

    public YoVariableBuffer<?> findYoVariableBuffer(YoVariable yoVariable) {
        return this.yoVariableFullnameToBufferMap.get(yoVariable.getFullNameString());
    }

    public YoVariableBuffer<?> findOrCreateYoVariableBuffer(YoVariable yoVariable) {
        String variableFullName = yoVariable.getFullNameString();
        YoVariableBuffer<?> yoVariableBuffer = this.yoVariableFullnameToBufferMap.get(variableFullName);
        if (yoVariableBuffer == null) {
            YoRegistry registry = SharedMemoryTools.ensurePathExists(this.rootRegistry, yoVariable.getNamespace());
            YoVariable duplicate = registry.getVariable(yoVariable.getName());
            if (duplicate == null) {
                duplicate = yoVariable.duplicate(registry);
            }
            yoVariableBuffer = YoVariableBuffer.newYoVariableBuffer(duplicate, this.properties);
            this.yoVariableBuffers.add(yoVariableBuffer);
            this.yoVariableFullnameToBufferMap.put(variableFullName, yoVariableBuffer);
        }
        return yoVariableBuffer;
    }

    LinkedYoRegistry newLinkedYoRegistry(YoRegistry registryToLink) {
        return new LinkedYoRegistry(registryToLink, this);
    }

    LinkedYoRegistry newLinkedYoRegistry() {
        return new LinkedYoRegistry(new YoRegistry(this.rootRegistry.getName()), this);
    }

    ReentrantLock getLock() {
        return this.lock;
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public YoBufferPropertiesReadOnly getProperties() {
        return this.properties;
    }

    public void dispose() {
        this.rootRegistry.removeListener(this.registryBufferUpdater);
        this.yoVariableBuffers.dispose();
        this.yoVariableFullnameToBufferMap.clear();
    }
}

