/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoDoubleBuffer
extends YoVariableBuffer<YoDouble> {
    private double[] buffer;

    public YoDoubleBuffer(YoDouble yoDouble, YoBufferPropertiesReadOnly properties) {
        super(yoDouble, properties);
        this.buffer = new double[properties.getSize()];
    }

    @Override
    public void resizeBuffer(int from, int length) {
        if (from == 0 && length == this.buffer.length) {
            return;
        }
        this.buffer = SharedMemoryTools.ringArrayCopy(this.buffer, from, length);
    }

    @Override
    public void writeBufferAt(int index) {
        this.buffer[index] = ((YoDouble)this.yoVariable).getValue();
    }

    @Override
    public void readBufferAt(int index) {
        ((YoDouble)this.yoVariable).set(this.buffer[index]);
    }

    @Override
    long getValueAsLongBits(int index) {
        return Double.doubleToLongBits(this.buffer[index]);
    }

    @Override
    public BufferSample<double[]> copy(int from, int length, YoBufferPropertiesReadOnly properties) {
        return new BufferSample<double[]>(from, SharedMemoryTools.ringArrayCopy(this.buffer, from, length), length, properties);
    }

    @Override
    public void fillBuffer(boolean zeroFill, int from, int length) {
        SharedMemoryTools.ringArrayFill(this.buffer, zeroFill ? 0.0 : ((YoDouble)this.yoVariable).getValue(), from, length);
    }

    LinkedYoDouble newLinkedYoVariable(YoDouble variableToLink) {
        return new LinkedYoDouble(variableToLink, this);
    }

    public double[] getBuffer() {
        return this.buffer;
    }

    @Override
    public double[] getAsDoubleBuffer() {
        return this.buffer;
    }

    @Override
    public void dispose() {
        this.buffer = null;
    }
}

