/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.FillBufferRequest;
import us.ihmc.scs2.sharedMemory.LinkedBufferArray;
import us.ihmc.scs2.sharedMemory.LinkedBufferProperties;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoRegistryBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.LinkedYoVariableFactory;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoSharedBuffer
implements LinkedYoVariableFactory {
    private final YoRegistryBuffer registryBuffer;
    private final ReentrantLock linkedBuffersLock = new ReentrantLock();
    private final LinkedBufferArray linkedBuffers = new LinkedBufferArray();
    private final ConcurrentLinkedQueue<LinkedBufferProperties> linkedBufferProperties = new ConcurrentLinkedQueue();
    private final YoBufferProperties properties = new YoBufferProperties();
    private boolean isDisposed = false;

    public YoSharedBuffer(YoRegistry rootRegistry, int initialBufferSize) {
        this.properties.setSize(initialBufferSize);
        this.registryBuffer = new YoRegistryBuffer(rootRegistry, this.properties);
    }

    public void cropBuffer(CropBufferRequest request) {
        if (this.isDisposed) {
            return;
        }
        int newSize = request.getCroppedSize(this.properties.getSize());
        this.registryBuffer.resizeBuffer(request.getFrom(), newSize);
        this.properties.setSize(newSize);
        this.properties.setInPointIndex(0);
        this.properties.setOutPointIndex(newSize - 1);
        this.properties.setCurrentIndexUnsafe(0);
    }

    public void fillBuffer(FillBufferRequest request) {
        if (this.isDisposed) {
            return;
        }
        this.registryBuffer.fillBuffer(request.getZeroFill(), request.getFrom(), request.getFilledSize(this.properties.getSize()));
    }

    public boolean resizeBuffer(int newSize) {
        int newCurrentIndex;
        int newOutPoint;
        int newInPoint;
        if (this.isDisposed) {
            return false;
        }
        if (newSize == this.properties.getSize() || newSize <= 0) {
            return false;
        }
        int oldCurrentIndex = this.properties.getCurrentIndex();
        int oldInPoint = this.properties.getInPoint();
        int oldOutPoint = this.properties.getOutPoint();
        int startBufferCopyIndex = oldInPoint;
        int oldSize = this.properties.getSize();
        if (newSize < this.properties.getActiveBufferLength()) {
            startBufferCopyIndex = SharedMemoryTools.computeFromIndex(oldOutPoint, newSize, oldSize);
            newInPoint = 0;
            newOutPoint = newSize - 1;
            newCurrentIndex = SharedMemoryTools.isInsideBounds(oldCurrentIndex, SharedMemoryTools.computeFromIndex(oldOutPoint, newSize, oldSize), oldOutPoint, oldSize) ? newOutPoint - SharedMemoryTools.computeSubLength(oldCurrentIndex, oldOutPoint, oldSize) + 1 : newOutPoint;
        } else {
            newInPoint = 0;
            newOutPoint = this.properties.getActiveBufferLength() - 1;
            newCurrentIndex = this.properties.isIndexBetweenBounds(oldCurrentIndex) ? SharedMemoryTools.computeSubLength(oldInPoint, oldCurrentIndex, oldSize) - 1 : newOutPoint;
        }
        this.registryBuffer.resizeBuffer(startBufferCopyIndex, newSize);
        this.properties.setSize(newSize);
        this.properties.setInPointIndex(newInPoint);
        this.properties.setOutPointIndex(newOutPoint);
        this.properties.setCurrentIndexUnsafe(newCurrentIndex);
        return true;
    }

    public boolean setCurrentIndex(int newIndex) {
        return this.properties.setCurrentIndex(newIndex);
    }

    public boolean setInPoint(int newInPoint) {
        return this.properties.setInPointIndex(newInPoint);
    }

    public boolean setOutPoint(int newOutPoint) {
        return this.properties.setOutPointIndex(newOutPoint);
    }

    public boolean processLinkedPushRequests(boolean writeBuffer) {
        if (this.isDisposed) {
            return false;
        }
        this.linkedBuffersLock.lock();
        try {
            boolean bl = this.linkedBuffers.processPush(writeBuffer);
            return bl;
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
    }

    public void flushLinkedPushRequests() {
        if (this.isDisposed) {
            return;
        }
        this.linkedBuffersLock.lock();
        try {
            this.linkedBuffers.flushPush();
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
    }

    public void readBuffer() {
        if (this.isDisposed) {
            return;
        }
        this.registryBuffer.readBuffer();
    }

    public void writeBuffer() {
        if (this.isDisposed) {
            return;
        }
        this.registryBuffer.writeBuffer();
    }

    public void prepareLinkedBuffersForPull() {
        if (this.isDisposed) {
            return;
        }
        this.linkedBuffersLock.lock();
        try {
            this.linkedBuffers.prepareForPull();
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
        this.linkedBufferProperties.forEach(LinkedBufferProperties::prepareForPull);
    }

    public boolean hasRequestPending() {
        if (this.isDisposed) {
            return false;
        }
        this.linkedBuffersLock.lock();
        try {
            boolean bl = this.linkedBuffers.hasRequestPending();
            return bl;
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
    }

    public int incrementBufferIndex(boolean updateBufferBounds) {
        return this.properties.incrementIndex(updateBufferBounds);
    }

    public int incrementBufferIndex(boolean updateBufferBounds, int stepSize) {
        return this.properties.incrementIndex(updateBufferBounds, stepSize);
    }

    public int decrementBufferIndex(int stepSize) {
        return this.properties.decrementIndex(stepSize);
    }

    public YoBufferPropertiesReadOnly getProperties() {
        return this.properties;
    }

    public YoRegistry getRootRegistry() {
        return this.registryBuffer.getRootRegistry();
    }

    public YoRegistryBuffer getRegistryBuffer() {
        return this.registryBuffer;
    }

    public void exportDataASCII(OutputStream outputStream) {
        this.exportDataASCII(outputStream, null, null);
    }

    public void exportDataASCII(OutputStream outputStream, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) {
        SharedMemoryIOTools.exportDataASCII(this, outputStream, variableFilter, registryFilter);
    }

    public void exportDataCSV(OutputStream outputStream) {
        this.exportDataCSV(outputStream, null, null);
    }

    public void exportDataCSV(OutputStream outputStream, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) {
        SharedMemoryIOTools.exportDataCSV(this, outputStream, variableFilter, registryFilter);
    }

    public void exportDataMatlab(File file) throws IOException {
        this.exportDataMatlab(file, null, null);
    }

    public void exportDataMatlab(File file, Predicate<YoVariable> variableFilter, Predicate<YoRegistry> registryFilter) throws IOException {
        SharedMemoryIOTools.exportDataMatlab(this, file, variableFilter, registryFilter);
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        try {
            this.linkedBuffersLock.lock();
            this.isDisposed = true;
            this.registryBuffer.dispose();
            this.linkedBuffers.dispose();
            this.linkedBufferProperties.forEach(l -> l.dispose());
            this.linkedBufferProperties.clear();
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
    }

    @Override
    public LinkedYoRegistry newLinkedYoRegistry(YoRegistry registryToLink) {
        if (this.isDisposed) {
            return null;
        }
        LinkedYoRegistry linkedYoRegistry = this.registryBuffer.newLinkedYoRegistry(registryToLink);
        this.linkedBuffersLock.lock();
        try {
            this.linkedBuffers.add(linkedYoRegistry);
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
        return linkedYoRegistry;
    }

    @Override
    public LinkedYoRegistry newLinkedYoRegistry() {
        if (this.isDisposed) {
            return null;
        }
        LinkedYoRegistry linkedYoRegistry = this.registryBuffer.newLinkedYoRegistry();
        this.linkedBuffersLock.lock();
        try {
            this.linkedBuffers.add(linkedYoRegistry);
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
        return linkedYoRegistry;
    }

    @Override
    public LinkedBufferProperties newLinkedBufferProperties() {
        if (this.isDisposed) {
            return null;
        }
        LinkedBufferProperties linkedBufferProperties = new LinkedBufferProperties(this.properties);
        this.linkedBufferProperties.add(linkedBufferProperties);
        return linkedBufferProperties;
    }

    @Override
    public LinkedYoVariable<?> newLinkedYoVariable(YoVariable variableToLink) {
        if (this.isDisposed) {
            return null;
        }
        LinkedYoVariable linkedYoVariable = LinkedYoVariable.newLinkedYoVariable(variableToLink, this.registryBuffer.findYoVariableBuffer(variableToLink));
        this.linkedBuffersLock.lock();
        try {
            this.linkedBuffers.add(linkedYoVariable);
        }
        finally {
            this.linkedBuffersLock.unlock();
        }
        return linkedYoVariable;
    }
}

