/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.tools;

import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class SharedMemoryToolsTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testComputeSubLength() {
        Random random = new Random(34536L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeSubLength((int)0, (int)10, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeSubLength((int)0, (int)10, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeSubLength((int)0, (int)10, (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeSubLength((int)5, (int)4, (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeSubLength((int)-1, (int)4, (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeSubLength((int)0, (int)-1, (int)5));
        for (int i = 0; i < 1000; ++i) {
            int length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            int to = random.nextInt(length);
            int subLength = SharedMemoryTools.computeSubLength((int)from, (int)to, (int)length);
            int index = from;
            int expectedSubLength = 1;
            while (index != to) {
                if (++index >= length) {
                    index = 0;
                }
                ++expectedSubLength;
            }
            Assertions.assertEquals((int)expectedSubLength, (int)subLength);
        }
    }

    @Test
    public void testComputeFromIndex() {
        Random random = new Random(2456L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeFromIndex((int)9, (int)1, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeFromIndex((int)9, (int)0, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeFromIndex((int)9, (int)2, (int)1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeFromIndex((int)11, (int)10, (int)11));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeFromIndex((int)-1, (int)10, (int)11));
        for (int i = 0; i < 1000; ++i) {
            int length = random.nextInt(1000) + 1;
            int to = random.nextInt(length);
            int subLength = random.nextInt(length - 1) + 1;
            int from = SharedMemoryTools.computeFromIndex((int)to, (int)subLength, (int)length);
            Assertions.assertEquals((int)subLength, (int)SharedMemoryTools.computeSubLength((int)from, (int)to, (int)length));
        }
    }

    @Test
    public void testComputeToIndex() {
        Random random = new Random(2456L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeToIndex((int)9, (int)1, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeToIndex((int)9, (int)0, (int)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> SharedMemoryTools.computeToIndex((int)9, (int)2, (int)1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeToIndex((int)11, (int)10, (int)11));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> SharedMemoryTools.computeToIndex((int)-1, (int)10, (int)11));
        for (int i = 0; i < 1000; ++i) {
            int length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            int subLength = random.nextInt(length - 1) + 1;
            int to = SharedMemoryTools.computeToIndex((int)from, (int)subLength, (int)length);
            Assertions.assertEquals((int)subLength, (int)SharedMemoryTools.computeSubLength((int)from, (int)to, (int)length));
        }
    }

    @Test
    public void testRingArrayCopyWithBoolean() {
        int k;
        boolean[] source;
        int length;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextBooleanArray(random, length);
            boolean[] copy = SharedMemoryTools.ringArrayCopy((boolean[])source, (int)0, (int)length);
            Assertions.assertArrayEquals((boolean[])source, (boolean[])copy);
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextBooleanArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(length - from);
            boolean[] copy = SharedMemoryTools.ringArrayCopy((boolean[])source, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source[k + from]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            boolean[] source2 = SharedMemoryToolsTest.nextBooleanArray(random, length);
            boolean[] copy = SharedMemoryTools.ringArrayCopy((boolean[])source2, (int)from, (int)length);
            for (int k2 = 0; k2 < length; ++k2) {
                if (copy[k2] != source2[(k2 + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source2) + "\nfrom=" + from + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            boolean[] source3 = SharedMemoryToolsTest.nextBooleanArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(from + 1) + length - from;
            boolean[] copy = SharedMemoryTools.ringArrayCopy((boolean[])source3, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source3[(k + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source3) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
    }

    @Test
    public void testRingArrayCopyWithDouble() {
        int k;
        double[] source;
        int length;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextDoubleArray(random, length);
            double[] copy = SharedMemoryTools.ringArrayCopy((double[])source, (int)0, (int)length);
            Assertions.assertArrayEquals((double[])source, (double[])copy);
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextDoubleArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(length - from);
            double[] copy = SharedMemoryTools.ringArrayCopy((double[])source, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source[k + from]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            double[] source2 = SharedMemoryToolsTest.nextDoubleArray(random, length);
            double[] copy = SharedMemoryTools.ringArrayCopy((double[])source2, (int)from, (int)length);
            for (int k2 = 0; k2 < length; ++k2) {
                if (copy[k2] != source2[(k2 + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source2) + "\nfrom=" + from + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            double[] source3 = SharedMemoryToolsTest.nextDoubleArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(from + 1) + length - from;
            double[] copy = SharedMemoryTools.ringArrayCopy((double[])source3, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source3[(k + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source3) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
    }

    @Test
    public void testRingArrayCopyWithInteger() {
        int k;
        int[] source;
        int length;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextIntegerArray(random, length);
            int[] copy = SharedMemoryTools.ringArrayCopy((int[])source, (int)0, (int)length);
            Assertions.assertArrayEquals((int[])source, (int[])copy);
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextIntegerArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(length - from);
            int[] copy = SharedMemoryTools.ringArrayCopy((int[])source, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source[k + from]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            int[] source2 = SharedMemoryToolsTest.nextIntegerArray(random, length);
            int[] copy = SharedMemoryTools.ringArrayCopy((int[])source2, (int)from, (int)length);
            for (int k2 = 0; k2 < length; ++k2) {
                if (copy[k2] != source2[(k2 + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source2) + "\nfrom=" + from + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int[] source3 = SharedMemoryToolsTest.nextIntegerArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(from + 1) + length - from;
            int[] copy = SharedMemoryTools.ringArrayCopy((int[])source3, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source3[(k + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source3) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
    }

    @Test
    public void testRingArrayCopyWithLong() {
        int k;
        long[] source;
        int length;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextLongArray(random, length);
            long[] copy = SharedMemoryTools.ringArrayCopy((long[])source, (int)0, (int)length);
            Assertions.assertArrayEquals((long[])source, (long[])copy);
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextLongArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(length - from);
            long[] copy = SharedMemoryTools.ringArrayCopy((long[])source, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source[k + from]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            long[] source2 = SharedMemoryToolsTest.nextLongArray(random, length);
            long[] copy = SharedMemoryTools.ringArrayCopy((long[])source2, (int)from, (int)length);
            for (int k2 = 0; k2 < length; ++k2) {
                if (copy[k2] != source2[(k2 + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source2) + "\nfrom=" + from + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            long[] source3 = SharedMemoryToolsTest.nextLongArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(from + 1) + length - from;
            long[] copy = SharedMemoryTools.ringArrayCopy((long[])source3, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source3[(k + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source3) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
    }

    @Test
    public void testRingArrayCopyWithByte() {
        int k;
        byte[] source;
        int length;
        int i;
        Random random = new Random(4353L);
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextByteArray(random, length);
            byte[] copy = SharedMemoryTools.ringArrayCopy((byte[])source, (int)0, (int)length);
            Assertions.assertArrayEquals((byte[])source, (byte[])copy);
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            source = SharedMemoryToolsTest.nextByteArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(length - from);
            byte[] copy = SharedMemoryTools.ringArrayCopy((byte[])source, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source[k + from]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            int from = random.nextInt(length);
            byte[] source2 = SharedMemoryToolsTest.nextByteArray(random, length);
            byte[] copy = SharedMemoryTools.ringArrayCopy((byte[])source2, (int)from, (int)length);
            for (int k2 = 0; k2 < length; ++k2) {
                if (copy[k2] != source2[(k2 + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source2) + "\nfrom=" + from + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            length = random.nextInt(1000) + 1;
            byte[] source3 = SharedMemoryToolsTest.nextByteArray(random, length);
            int from = random.nextInt(length);
            int copyLength = random.nextInt(from + 1) + length - from;
            byte[] copy = SharedMemoryTools.ringArrayCopy((byte[])source3, (int)from, (int)copyLength);
            for (k = 0; k < copyLength; ++k) {
                if (copy[k] != source3[(k + from) % length]) {
                    throw new AssertionError((Object)("Source: " + Arrays.toString(source3) + "\nfrom=" + from + ", copyLength=" + copyLength + "\nCopy: " + Arrays.toString(copy)));
                }
            }
        }
    }

    public static boolean[] nextBooleanArray(Random random, int length) {
        boolean[] next = new boolean[length];
        for (int i = 0; i < length; ++i) {
            next[i] = random.nextBoolean();
        }
        return next;
    }

    public static double[] nextDoubleArray(Random random, int length) {
        double[] next = new double[length];
        for (int i = 0; i < length; ++i) {
            next[i] = EuclidCoreRandomTools.nextDouble((Random)random);
        }
        return next;
    }

    public static int[] nextIntegerArray(Random random, int length) {
        int[] next = new int[length];
        for (int i = 0; i < length; ++i) {
            next[i] = RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
        }
        return next;
    }

    public static long[] nextLongArray(Random random, int length) {
        long[] next = new long[length];
        for (int i = 0; i < length; ++i) {
            next[i] = RandomNumbers.nextInt((Random)random, (int)-100000, (int)100000);
        }
        return next;
    }

    public static byte[] nextByteArray(Random random, int length) {
        byte[] next = new byte[length];
        random.nextBytes(next);
        return next;
    }

    @Test
    public void testDuplicateMissingYoVariablesInTarget() {
        YoVariable targetVariable;
        int numberOfYoVariablesCreated;
        YoRegistry target;
        YoRegistry original;
        int numberOfVariables;
        int i;
        Random random = new Random(469L);
        for (i = 0; i < 1000; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
            original = SharedMemoryRandomTools.nextYoRegistry((Random)random, (int)numberOfVariables);
            target = new YoRegistry(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)1, (int)50));
            numberOfYoVariablesCreated = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            Assertions.assertEquals((int)numberOfVariables, (int)numberOfYoVariablesCreated);
            for (Object originalVariable : original.getVariables()) {
                targetVariable = target.findVariable(originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable.getClass());
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
            YoRegistry originalRoot = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)numberOfVariables, (int)50)[0];
            YoRegistry targetRoot = new YoRegistry(originalRoot.getName());
            numberOfYoVariablesCreated = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            Assertions.assertEquals((int)originalRoot.collectSubtreeVariables().size(), (int)numberOfYoVariablesCreated);
            for (YoRegistry originalRegistry : originalRoot.collectSubtreeRegistries()) {
                YoRegistry targetRegistry = targetRoot.findRegistry(originalRegistry.getNamespace());
                Assertions.assertNotNull((Object)targetRegistry);
                Assertions.assertEquals((int)originalRegistry.getNumberOfVariables(), (int)targetRegistry.getNumberOfVariables());
            }
            for (Object originalVariable : originalRoot.collectSubtreeVariables()) {
                targetVariable = targetRoot.findVariable(originalVariable.getNamespace().toString(), originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable.getClass());
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            original = SharedMemoryRandomTools.nextYoRegistry((Random)random, (int)numberOfVariables);
            target = new YoRegistry(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)1, (int)50));
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            int numberOfMissingVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            SharedMemoryRandomTools.nextYoVariables((Random)random, (int)numberOfMissingVariables, (YoRegistry)original);
            int numberOfYoVariablesCreated2 = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            Assertions.assertEquals((int)numberOfMissingVariables, (int)numberOfYoVariablesCreated2);
            for (YoVariable originalVariable : original.getVariables()) {
                YoVariable targetVariable2 = target.findVariable(originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable2);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable2.getClass());
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            YoRegistry[] originalRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)numberOfVariables, (int)25);
            YoRegistry originalRoot = originalRegistries[0];
            YoRegistry targetRoot = new YoRegistry(originalRoot.getName());
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            int numberOfMissingVariables = 0;
            for (int j = 0; j < 25; ++j) {
                int n = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
                YoRegistry parent = originalRegistries[random.nextInt(originalRegistries.length)];
                YoRegistry registry = SharedMemoryRandomTools.nextYoRegistry((Random)random, (String)SharedMemoryRandomTools.nextAvailableRegistryName((Random)random, (int)1, (int)50, (YoRegistry)parent), (int)n);
                parent.addChild(registry);
                numberOfMissingVariables += n;
            }
            int numberOfYoVariablesCreated3 = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            Assertions.assertEquals((int)numberOfMissingVariables, (int)numberOfYoVariablesCreated3);
            for (YoRegistry originalRegistry : originalRoot.collectSubtreeRegistries()) {
                YoRegistry targetRegistry = targetRoot.findRegistry(originalRegistry.getNamespace());
                Assertions.assertNotNull((Object)targetRegistry);
                Assertions.assertEquals((int)originalRegistry.getNumberOfVariables(), (int)targetRegistry.getNumberOfVariables());
            }
            for (YoVariable originalVariable : originalRoot.collectSubtreeVariables()) {
                YoVariable targetVariable3 = targetRoot.findVariable(originalVariable.getNamespace().toString(), originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable3);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable3.getClass());
            }
        }
    }
}

