/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;

public class YoBufferPropertiesTest {
    private static final int ITERATIONS = 100000;

    @Test
    public void testConstructors() {
        int i;
        Random random = new Random(45346L);
        YoBufferProperties yoBufferProperties = new YoBufferProperties();
        Assertions.assertEquals((int)0, (int)yoBufferProperties.getInPoint());
        Assertions.assertEquals((int)0, (int)yoBufferProperties.getOutPoint());
        Assertions.assertEquals((int)0, (int)yoBufferProperties.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)yoBufferProperties.getSize());
        for (i = 0; i < 100000; ++i) {
            int size = random.nextInt(1280000);
            int index = random.nextInt(size);
            YoBufferProperties yoBufferProperties2 = new YoBufferProperties(index, size);
            Assertions.assertEquals((int)0, (int)yoBufferProperties2.getInPoint());
            Assertions.assertEquals((int)0, (int)yoBufferProperties2.getOutPoint());
            Assertions.assertEquals((int)index, (int)yoBufferProperties2.getCurrentIndex());
            Assertions.assertEquals((int)size, (int)yoBufferProperties2.getSize());
        }
        for (i = 0; i < 100000; ++i) {
            YoBufferProperties original = SharedMemoryRandomTools.nextYoBufferProperties((Random)random, (int)random.nextInt(1280000));
            YoBufferProperties clone = new YoBufferProperties((YoBufferPropertiesReadOnly)original);
            Assertions.assertEquals((int)original.getInPoint(), (int)clone.getInPoint());
            Assertions.assertEquals((int)original.getOutPoint(), (int)clone.getOutPoint());
            Assertions.assertEquals((int)original.getCurrentIndex(), (int)clone.getCurrentIndex());
            Assertions.assertEquals((int)original.getSize(), (int)clone.getSize());
        }
    }

    @Test
    public void testIncrementIndex() {
        int j;
        YoBufferProperties expectedProperties;
        int outPoint;
        int index;
        int inPoint;
        int size;
        int i;
        Random random = new Random(436L);
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            YoBufferProperties properties = new YoBufferProperties(index, size);
            properties.setInPointIndex(inPoint);
            properties.setOutPointIndex(outPoint);
            int newIndex = properties.incrementIndex(false);
            Assertions.assertEquals((int)newIndex, (int)properties.getCurrentIndex());
            Assertions.assertEquals((int)size, (int)properties.getSize());
            Assertions.assertEquals((int)inPoint, (int)properties.getInPoint());
            Assertions.assertEquals((int)outPoint, (int)properties.getOutPoint());
            if (index == size - 1 && properties.isIndexBetweenBounds(0)) {
                Assertions.assertEquals((int)0, (int)newIndex);
            } else if (properties.isIndexBetweenBounds(index) && properties.isIndexBetweenBounds(index + 1)) {
                Assertions.assertEquals((int)(index + 1), (int)newIndex);
            } else {
                Assertions.assertEquals((int)inPoint, (int)newIndex);
            }
            index = outPoint;
            properties.setCurrentIndexUnsafe(index);
            newIndex = properties.incrementIndex(false);
            Assertions.assertEquals((int)inPoint, (int)newIndex);
            index = size - 1;
            properties.setCurrentIndexUnsafe(index);
            newIndex = properties.incrementIndex(false);
            if (properties.isIndexBetweenBounds(size - 1) && properties.isIndexBetweenBounds(0)) {
                Assertions.assertEquals((int)0, (int)newIndex);
                continue;
            }
            Assertions.assertEquals((int)inPoint, (int)newIndex);
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 2;
            inPoint = random.nextInt(size);
            int outPoint2 = random.nextInt(size);
            int index2 = random.nextInt(size);
            String messagePrefix = "iteration " + i + ", index " + index2 + ", size " + size + ", in " + inPoint + ", out " + outPoint2;
            YoBufferProperties properties = new YoBufferProperties(index2, size);
            properties.setInPointIndex(inPoint);
            properties.setOutPointIndex(outPoint2);
            int newIndex = properties.incrementIndex(true);
            Assertions.assertEquals((int)newIndex, (int)properties.getCurrentIndex(), (String)messagePrefix);
            Assertions.assertEquals((int)size, (int)properties.getSize(), (String)messagePrefix);
            Assertions.assertEquals((int)newIndex, (int)properties.getOutPoint());
            Assertions.assertNotEquals((int)properties.getInPoint(), (int)properties.getOutPoint());
            if (inPoint != newIndex) {
                Assertions.assertEquals((int)inPoint, (int)properties.getInPoint(), (String)messagePrefix);
            } else {
                Assertions.assertEquals((int)((inPoint + 1) % size), (int)properties.getInPoint(), (String)messagePrefix);
            }
            if (index2 < size - 1) {
                Assertions.assertEquals((int)(index2 + 1), (int)newIndex, (String)messagePrefix);
                continue;
            }
            Assertions.assertEquals((int)0, (int)newIndex, (String)messagePrefix);
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            int stepSize = random.nextInt(500);
            boolean updateBufferBounds = random.nextBoolean();
            YoBufferProperties actualProperties = new YoBufferProperties(index, size);
            actualProperties.setInPointIndex(inPoint);
            actualProperties.setOutPointIndex(outPoint);
            actualProperties.incrementIndex(updateBufferBounds, stepSize);
            expectedProperties = new YoBufferProperties(index, size);
            expectedProperties.setInPointIndex(inPoint);
            expectedProperties.setOutPointIndex(outPoint);
            for (j = 0; j < stepSize; ++j) {
                expectedProperties.incrementIndex(updateBufferBounds);
            }
            Assertions.assertEquals((Object)expectedProperties, (Object)actualProperties);
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            int stepSize = -random.nextInt(500);
            boolean updateBufferBounds = random.nextBoolean();
            YoBufferProperties actualProperties = new YoBufferProperties(index, size);
            actualProperties.setInPointIndex(inPoint);
            actualProperties.setOutPointIndex(outPoint);
            actualProperties.incrementIndex(updateBufferBounds, stepSize);
            expectedProperties = new YoBufferProperties(index, size);
            expectedProperties.setInPointIndex(inPoint);
            expectedProperties.setOutPointIndex(outPoint);
            for (j = 0; j < Math.abs(stepSize); ++j) {
                expectedProperties.decrementIndex();
            }
            Assertions.assertEquals((Object)expectedProperties, (Object)actualProperties);
        }
    }

    @Test
    public void testDecrementIndex() {
        int j;
        YoBufferProperties expectedProperties;
        int outPoint;
        int index;
        int inPoint;
        int size;
        int i;
        Random random = new Random(4346547L);
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            YoBufferProperties properties = new YoBufferProperties(index, size);
            properties.setInPointIndex(inPoint);
            properties.setOutPointIndex(outPoint);
            int newIndex = properties.decrementIndex();
            Assertions.assertEquals((int)newIndex, (int)properties.getCurrentIndex());
            Assertions.assertEquals((int)size, (int)properties.getSize());
            Assertions.assertEquals((int)inPoint, (int)properties.getInPoint());
            Assertions.assertEquals((int)outPoint, (int)properties.getOutPoint());
            if (index == 0 && properties.isIndexBetweenBounds(size - 1)) {
                Assertions.assertEquals((int)(size - 1), (int)newIndex);
            } else if (properties.isIndexBetweenBounds(index) && properties.isIndexBetweenBounds(index - 1)) {
                Assertions.assertEquals((int)(index - 1), (int)newIndex);
            } else {
                Assertions.assertEquals((int)outPoint, (int)newIndex);
            }
            index = inPoint;
            properties.setCurrentIndexUnsafe(index);
            newIndex = properties.decrementIndex();
            Assertions.assertEquals((int)outPoint, (int)newIndex);
            index = 0;
            properties.setCurrentIndexUnsafe(index);
            newIndex = properties.decrementIndex();
            if (properties.isIndexBetweenBounds(size - 1) && properties.isIndexBetweenBounds(0)) {
                Assertions.assertEquals((int)(size - 1), (int)newIndex);
                continue;
            }
            Assertions.assertEquals((int)outPoint, (int)newIndex);
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            int stepSize = random.nextInt(500);
            YoBufferProperties actualProperties = new YoBufferProperties(index, size);
            actualProperties.setInPointIndex(inPoint);
            actualProperties.setOutPointIndex(outPoint);
            actualProperties.decrementIndex(stepSize);
            expectedProperties = new YoBufferProperties(index, size);
            expectedProperties.setInPointIndex(inPoint);
            expectedProperties.setOutPointIndex(outPoint);
            for (j = 0; j < stepSize; ++j) {
                expectedProperties.decrementIndex();
            }
            Assertions.assertEquals((Object)expectedProperties, (Object)actualProperties);
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            index = random.nextInt(size);
            outPoint = random.nextInt(size);
            int stepSize = -random.nextInt(500);
            YoBufferProperties actualProperties = new YoBufferProperties(index, size);
            actualProperties.setInPointIndex(inPoint);
            actualProperties.setOutPointIndex(outPoint);
            actualProperties.decrementIndex(stepSize);
            expectedProperties = new YoBufferProperties(index, size);
            expectedProperties.setInPointIndex(inPoint);
            expectedProperties.setOutPointIndex(outPoint);
            for (j = 0; j < Math.abs(stepSize); ++j) {
                expectedProperties.incrementIndex(false);
            }
            Assertions.assertEquals((Object)expectedProperties, (Object)actualProperties);
        }
    }

    @Test
    public void testSetCurrentIndex() {
        Random random = new Random(4677L);
        for (int i = 0; i < 100000; ++i) {
            int size = random.nextInt(10000) + 1;
            int index = random.nextInt(size);
            YoBufferProperties actual = new YoBufferProperties(index, size);
            YoBufferProperties expected = new YoBufferProperties((YoBufferPropertiesReadOnly)actual);
            Assertions.assertFalse((boolean)actual.setCurrentIndex(index));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setCurrentIndex(-random.nextInt(1000) - 1));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setCurrentIndex(size + random.nextInt(1000)));
            Assertions.assertEquals((Object)actual, (Object)expected);
            if (size <= 1) continue;
            int newIndex = random.nextInt(size);
            while (newIndex == index) {
                newIndex = random.nextInt(size);
            }
            Assertions.assertTrue((boolean)actual.setCurrentIndex(newIndex));
            Assertions.assertEquals((int)newIndex, (int)actual.getCurrentIndex());
            Assertions.assertEquals((int)expected.getSize(), (int)actual.getSize());
            Assertions.assertEquals((int)expected.getInPoint(), (int)actual.getInPoint());
            Assertions.assertEquals((int)expected.getOutPoint(), (int)actual.getOutPoint());
        }
    }

    @Test
    public void testSetCurrentIndexUnsafe() {
        Random random = new Random(9746L);
        for (int i = 0; i < 100000; ++i) {
            YoBufferProperties original = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoBufferProperties clone = new YoBufferProperties((YoBufferPropertiesReadOnly)original);
            int newIndex = RandomNumbers.nextInt((Random)random, (int)-5000000, (int)5000000);
            clone.setCurrentIndexUnsafe(newIndex);
            Assertions.assertEquals((int)newIndex, (int)clone.getCurrentIndex());
            Assertions.assertEquals((int)original.getSize(), (int)clone.getSize());
            Assertions.assertEquals((int)original.getInPoint(), (int)clone.getInPoint());
            Assertions.assertEquals((int)original.getOutPoint(), (int)clone.getOutPoint());
        }
    }

    @Test
    public void testSetSize() {
        Random random = new Random(9746L);
        for (int i = 0; i < 100000; ++i) {
            YoBufferProperties original = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoBufferProperties clone = new YoBufferProperties((YoBufferPropertiesReadOnly)original);
            int newSize = RandomNumbers.nextInt((Random)random, (int)1, (int)5000000);
            clone.setSize(newSize);
            Assertions.assertEquals((int)newSize, (int)clone.getSize());
            Assertions.assertEquals((int)original.getCurrentIndex(), (int)clone.getCurrentIndex());
            Assertions.assertEquals((int)original.getInPoint(), (int)clone.getInPoint());
            Assertions.assertEquals((int)original.getOutPoint(), (int)clone.getOutPoint());
            Assertions.assertThrows(IllegalArgumentException.class, () -> clone.setSize(-random.nextInt(1000)));
        }
    }

    @Test
    public void testSetInPoint() {
        Random random = new Random(4677L);
        for (int i = 0; i < 100000; ++i) {
            int size = random.nextInt(10000) + 1;
            YoBufferProperties actual = SharedMemoryRandomTools.nextYoBufferProperties((Random)random, (int)size);
            YoBufferProperties expected = new YoBufferProperties((YoBufferPropertiesReadOnly)actual);
            Assertions.assertFalse((boolean)actual.setInPointIndex(actual.getInPoint()));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setInPointIndex(-random.nextInt(1000) - 1));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setInPointIndex(size + random.nextInt(1000)));
            Assertions.assertEquals((Object)actual, (Object)expected);
            if (size <= 1) continue;
            int newInPoint = random.nextInt(size);
            while (newInPoint == actual.getInPoint()) {
                newInPoint = random.nextInt(size);
            }
            Assertions.assertTrue((boolean)actual.setInPointIndex(newInPoint));
            Assertions.assertEquals((int)expected.getCurrentIndex(), (int)actual.getCurrentIndex());
            Assertions.assertEquals((int)expected.getSize(), (int)actual.getSize());
            Assertions.assertEquals((int)newInPoint, (int)actual.getInPoint());
            Assertions.assertEquals((int)expected.getOutPoint(), (int)actual.getOutPoint());
        }
    }

    @Test
    public void testSetOutPoint() {
        Random random = new Random(4677L);
        for (int i = 0; i < 100000; ++i) {
            int size = random.nextInt(10000) + 1;
            YoBufferProperties actual = SharedMemoryRandomTools.nextYoBufferProperties((Random)random, (int)size);
            YoBufferProperties expected = new YoBufferProperties((YoBufferPropertiesReadOnly)actual);
            Assertions.assertFalse((boolean)actual.setOutPointIndex(actual.getOutPoint()));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setOutPointIndex(-random.nextInt(1000) - 1));
            Assertions.assertEquals((Object)actual, (Object)expected);
            Assertions.assertFalse((boolean)actual.setOutPointIndex(size + random.nextInt(1000)));
            Assertions.assertEquals((Object)actual, (Object)expected);
            if (size <= 1) continue;
            int newOutPoint = random.nextInt(size);
            while (newOutPoint == actual.getOutPoint()) {
                newOutPoint = random.nextInt(size);
            }
            Assertions.assertTrue((boolean)actual.setOutPointIndex(newOutPoint));
            Assertions.assertEquals((int)expected.getCurrentIndex(), (int)actual.getCurrentIndex());
            Assertions.assertEquals((int)expected.getSize(), (int)actual.getSize());
            Assertions.assertEquals((int)expected.getInPoint(), (int)actual.getInPoint());
            Assertions.assertEquals((int)newOutPoint, (int)actual.getOutPoint());
        }
    }

    @Test
    public void testGetActiveBufferLength() {
        Random random = new Random(63234L);
        for (int i = 0; i < 100000; ++i) {
            YoBufferProperties properties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            int index = properties.getInPoint();
            int expectedLength = 1;
            while (index != properties.getOutPoint()) {
                if (++index >= properties.getSize()) {
                    index = 0;
                }
                ++expectedLength;
            }
            Assertions.assertEquals((int)expectedLength, (int)properties.getActiveBufferLength());
        }
    }

    @Test
    public void testIsIndexBetweenBounds() {
        YoBufferProperties properties;
        int indexOutside;
        int indexInside;
        int outPoint;
        int inPoint;
        int size;
        int i;
        Random random = new Random(4367L);
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            inPoint = random.nextInt(size);
            outPoint = RandomNumbers.nextInt((Random)random, (int)inPoint, (int)(size - 1));
            indexInside = RandomNumbers.nextInt((Random)random, (int)inPoint, (int)outPoint);
            indexOutside = random.nextBoolean() && outPoint < size - 1 ? RandomNumbers.nextInt((Random)random, (int)(outPoint + 1), (int)(size - 1)) : (inPoint > 0 ? RandomNumbers.nextInt((Random)random, (int)0, (int)(inPoint - 1)) : -1);
            properties = new YoBufferProperties();
            properties.setSize(size);
            properties.setInPointIndex(inPoint);
            properties.setOutPointIndex(outPoint);
            Assertions.assertTrue((boolean)properties.isIndexBetweenBounds(indexInside));
            Assertions.assertFalse((boolean)properties.isIndexBetweenBounds(indexOutside));
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 2;
            int outPoint2 = random.nextInt(size - 1);
            int inPoint2 = RandomNumbers.nextInt((Random)random, (int)(outPoint2 + 1), (int)(size - 1));
            indexInside = random.nextBoolean() ? RandomNumbers.nextInt((Random)random, (int)0, (int)outPoint2) : RandomNumbers.nextInt((Random)random, (int)inPoint2, (int)(size - 1));
            indexOutside = outPoint2 < inPoint2 - 1 ? RandomNumbers.nextInt((Random)random, (int)(outPoint2 + 1), (int)(inPoint2 - 1)) : -1;
            properties = new YoBufferProperties();
            properties.setSize(size);
            properties.setInPointIndex(inPoint2);
            properties.setOutPointIndex(outPoint2);
            Assertions.assertTrue((boolean)properties.isIndexBetweenBounds(indexInside));
            Assertions.assertFalse((boolean)properties.isIndexBetweenBounds(indexOutside));
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            outPoint = inPoint = random.nextInt(size);
            indexInside = inPoint;
            indexOutside = outPoint < size - 1 ? RandomNumbers.nextInt((Random)random, (int)(outPoint + 1), (int)(size - 1)) : (inPoint > 0 ? RandomNumbers.nextInt((Random)random, (int)0, (int)(inPoint - 1)) : -1);
            properties = new YoBufferProperties();
            properties.setSize(size);
            properties.setInPointIndex(inPoint);
            properties.setOutPointIndex(outPoint);
            Assertions.assertTrue((boolean)properties.isIndexBetweenBounds(indexInside));
            Assertions.assertFalse((boolean)properties.isIndexBetweenBounds(indexOutside));
        }
        for (i = 0; i < 100000; ++i) {
            size = random.nextInt(10000) + 1;
            YoBufferProperties properties2 = new YoBufferProperties();
            properties2.setSize(size);
            properties2.setInPointIndex(random.nextInt(size));
            properties2.setOutPointIndex(random.nextInt(size));
            int indexOutside2 = -random.nextInt(100) - 1;
            Assertions.assertFalse((boolean)properties2.isIndexBetweenBounds(indexOutside2));
            indexOutside2 = size + random.nextInt(100);
            Assertions.assertFalse((boolean)properties2.isIndexBetweenBounds(indexOutside2));
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(5346L);
        for (int i = 0; i < 100000; ++i) {
            YoBufferProperties original = SharedMemoryRandomTools.nextYoBufferProperties((Random)random);
            YoBufferPropertiesReadOnly copy = original.copy();
            Assertions.assertEquals((int)original.getInPoint(), (int)copy.getInPoint());
            Assertions.assertEquals((int)original.getOutPoint(), (int)copy.getOutPoint());
            Assertions.assertEquals((int)original.getCurrentIndex(), (int)copy.getCurrentIndex());
            Assertions.assertEquals((int)original.getSize(), (int)copy.getSize());
        }
    }

    @Test
    public void testEquals() {
        Random random = new Random(6577L);
        for (int i = 0; i < 100000; ++i) {
            TestProperties testProperties = new TestProperties(random);
            YoBufferProperties properties1 = new YoBufferProperties((YoBufferPropertiesReadOnly)testProperties);
            YoBufferProperties properties2 = new YoBufferProperties((YoBufferPropertiesReadOnly)testProperties);
            Assertions.assertTrue((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertTrue((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertFalse((boolean)properties1.equals(null));
            Assertions.assertFalse((boolean)properties1.equals(new ArrayList()));
            ++testProperties.inPoint;
            properties2.set((YoBufferPropertiesReadOnly)testProperties);
            Assertions.assertFalse((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertFalse((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties2));
            --testProperties.inPoint;
            ++testProperties.outPoint;
            properties2.set((YoBufferPropertiesReadOnly)testProperties);
            Assertions.assertFalse((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertFalse((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties2));
            --testProperties.outPoint;
            ++testProperties.currentIndex;
            properties2.set((YoBufferPropertiesReadOnly)testProperties);
            Assertions.assertFalse((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertFalse((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties2));
            --testProperties.currentIndex;
            ++testProperties.size;
            properties2.set((YoBufferPropertiesReadOnly)testProperties);
            Assertions.assertFalse((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties1));
            Assertions.assertFalse((boolean)properties1.equals((YoBufferPropertiesReadOnly)properties2));
            Assertions.assertTrue((boolean)testProperties.equals((YoBufferPropertiesReadOnly)properties2));
        }
    }

    private static class TestProperties
    implements YoBufferPropertiesReadOnly {
        private int inPoint = 0;
        private int outPoint = 0;
        private int currentIndex = 0;
        private int size = 0;

        public TestProperties(Random random) {
            this.inPoint = random.nextInt(416516516);
            this.outPoint = random.nextInt(416516516);
            this.currentIndex = random.nextInt(416516516);
            this.size = random.nextInt(416516516);
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getSize() {
            return this.size;
        }

        public int getInPoint() {
            return this.inPoint;
        }

        public int getOutPoint() {
            return this.outPoint;
        }
    }
}

