/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoMirroredRegistryToolsTest {
    private static final int ITERATIONS = 100;

    @Test
    public void testDuplicateMissingYoVariablesInTarget() {
        YoVariable targetVariable;
        int numberOfYoVariablesCreated;
        YoRegistry target;
        YoRegistry original;
        int numberOfVariables;
        int i;
        Random random = new Random(469L);
        for (i = 0; i < 100; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
            original = SharedMemoryRandomTools.nextYoRegistry((Random)random, (int)numberOfVariables);
            target = new YoRegistry(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)1, (int)50));
            numberOfYoVariablesCreated = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            Assertions.assertEquals((int)numberOfVariables, (int)numberOfYoVariablesCreated);
            for (Object originalVariable : original.getVariables()) {
                targetVariable = target.findVariable(originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable.getClass());
            }
        }
        for (i = 0; i < 100; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
            YoRegistry originalRoot = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)numberOfVariables, (int)50)[0];
            YoRegistry targetRoot = new YoRegistry(originalRoot.getName());
            numberOfYoVariablesCreated = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            Assertions.assertEquals((int)originalRoot.collectSubtreeVariables().size(), (int)numberOfYoVariablesCreated);
            for (YoRegistry originalRegistry : originalRoot.collectSubtreeRegistries()) {
                YoRegistry targetRegistry = targetRoot.findRegistry(originalRegistry.getNamespace());
                Assertions.assertNotNull((Object)targetRegistry);
                Assertions.assertEquals((int)originalRegistry.getNumberOfVariables(), (int)targetRegistry.getNumberOfVariables());
            }
            for (Object originalVariable : originalRoot.collectSubtreeVariables()) {
                targetVariable = targetRoot.findVariable(originalVariable.getNamespace().toString(), originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable.getClass());
            }
        }
        for (i = 0; i < 100; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            original = SharedMemoryRandomTools.nextYoRegistry((Random)random, (int)numberOfVariables);
            target = new YoRegistry(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)1, (int)50));
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            int numberOfMissingVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            SharedMemoryRandomTools.nextYoVariables((Random)random, (int)numberOfMissingVariables, (YoRegistry)original);
            int numberOfYoVariablesCreated2 = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)original, (YoRegistry)target);
            Assertions.assertEquals((int)numberOfMissingVariables, (int)numberOfYoVariablesCreated2);
            for (YoVariable originalVariable : original.getVariables()) {
                YoVariable targetVariable2 = target.findVariable(originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable2);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable2.getClass());
            }
        }
        for (i = 0; i < 100; ++i) {
            numberOfVariables = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
            YoRegistry[] originalRegistries = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)numberOfVariables, (int)25);
            YoRegistry originalRoot = originalRegistries[0];
            YoRegistry targetRoot = new YoRegistry(originalRoot.getName());
            SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            int numberOfMissingVariables = 0;
            for (int j = 0; j < 25; ++j) {
                int n = RandomNumbers.nextInt((Random)random, (int)0, (int)50);
                YoRegistry parent = originalRegistries[random.nextInt(originalRegistries.length)];
                YoRegistry registry = SharedMemoryRandomTools.nextYoRegistry((Random)random, (String)SharedMemoryRandomTools.nextAvailableRegistryName((Random)random, (int)1, (int)50, (YoRegistry)parent), (int)n);
                parent.addChild(registry);
                numberOfMissingVariables += n;
            }
            int numberOfYoVariablesCreated3 = SharedMemoryTools.duplicateMissingYoVariablesInTarget((YoRegistry)originalRoot, (YoRegistry)targetRoot);
            Assertions.assertEquals((int)numberOfMissingVariables, (int)numberOfYoVariablesCreated3);
            for (YoRegistry originalRegistry : originalRoot.collectSubtreeRegistries()) {
                YoRegistry targetRegistry = targetRoot.findRegistry(originalRegistry.getNamespace());
                Assertions.assertNotNull((Object)targetRegistry);
                Assertions.assertEquals((int)originalRegistry.getNumberOfVariables(), (int)targetRegistry.getNumberOfVariables());
            }
            for (YoVariable originalVariable : originalRoot.collectSubtreeVariables()) {
                YoVariable targetVariable3 = targetRoot.findVariable(originalVariable.getNamespace().toString(), originalVariable.getName());
                Assertions.assertNotNull((Object)targetVariable3);
                Assertions.assertEquals(originalVariable.getClass(), targetVariable3.getClass());
            }
        }
    }
}

