/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Random;
import javax.xml.bind.JAXBException;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTestTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SharedMemoryIOToolsTest {
    @Test
    public void testExportImportRegistry() throws JAXBException, IOException {
        Random random = new Random(34536L);
        String registryFileName = "./bufferASCIIExport.scs2.registry";
        YoRegistry exportedRegistry = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)20, (int)20)[0];
        SharedMemoryIOTools.exportRegistry((YoRegistry)exportedRegistry, (OutputStream)new FileOutputStream(registryFileName));
        YoRegistry importedRegistry = SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFileName));
        SharedMemoryTestTools.assertYoRegistryEquals((YoRegistry)exportedRegistry, (YoRegistry)importedRegistry);
        Files.delete(Paths.get(registryFileName, new String[0]));
    }

    @Test
    public void testExportImportASCII() throws JAXBException, IOException {
        Random random = new Random(35453L);
        String dataFileName = "./bufferASCIIExport.scs2.data";
        String registryFileName = "./bufferASCIIExport.scs2.registry";
        for (int i = 0; i < 100; ++i) {
            YoSharedBuffer exportedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)20, (int)20);
            SharedMemoryIOTools.exportRegistry((YoRegistry)exportedBuffer.getRootRegistry(), (OutputStream)new FileOutputStream(registryFileName));
            SharedMemoryIOTools.exportDataASCII((YoSharedBuffer)exportedBuffer, (OutputStream)new FileOutputStream(dataFileName));
            YoRegistry importedRoot = SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFileName));
            SharedMemoryTestTools.assertYoRegistryEquals((YoRegistry)exportedBuffer.getRootRegistry(), (YoRegistry)importedRoot);
            YoSharedBuffer importedBuffer = SharedMemoryIOTools.importDataASCII((InputStream)new FileInputStream(dataFileName), (YoRegistry)importedRoot);
            SharedMemoryTestTools.assertYoSharedBufferEquals((YoSharedBuffer)exportedBuffer, (YoSharedBuffer)importedBuffer, (double)0.0);
        }
        Files.delete(Paths.get(dataFileName, new String[0]));
        Files.delete(Paths.get(registryFileName, new String[0]));
    }

    @Test
    public void testExportImportCSV() throws JAXBException, IOException {
        Random random = new Random(35453L);
        String dataFileName = "./bufferCSVExport.scs2.data";
        String registryFileName = "./bufferCSVExport.scs2.registry";
        for (int i = 0; i < 10; ++i) {
            YoSharedBuffer exportedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)20, (int)20);
            SharedMemoryIOTools.exportRegistry((YoRegistry)exportedBuffer.getRootRegistry(), (OutputStream)new FileOutputStream(registryFileName));
            SharedMemoryIOTools.exportDataCSV((YoSharedBuffer)exportedBuffer, (OutputStream)new FileOutputStream(dataFileName));
            YoRegistry importedRoot = SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFileName));
            SharedMemoryTestTools.assertYoRegistryEquals((YoRegistry)exportedBuffer.getRootRegistry(), (YoRegistry)importedRoot);
            YoSharedBuffer importedBuffer = SharedMemoryIOTools.importDataCSV((InputStream)new FileInputStream(dataFileName), (YoRegistry)importedRoot);
            SharedMemoryTestTools.assertYoSharedBufferEquals((YoSharedBuffer)exportedBuffer, (YoSharedBuffer)importedBuffer, (double)0.0);
        }
        Files.delete(Paths.get(dataFileName, new String[0]));
        Files.delete(Paths.get(registryFileName, new String[0]));
    }

    @Test
    public void testExportImportMatlab() throws JAXBException, IOException {
        Random random = new Random(35453L);
        String dataFileName = "./bufferMatlabExport.scs2.mat";
        String registryFileName = "./bufferMatlabExport.scs2.registry";
        for (int i = 0; i < 100; ++i) {
            YoSharedBuffer exportedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (int)20, (int)20);
            SharedMemoryIOTools.exportRegistry((YoRegistry)exportedBuffer.getRootRegistry(), (OutputStream)new FileOutputStream(registryFileName));
            SharedMemoryIOTools.exportDataMatlab((YoSharedBuffer)exportedBuffer, (File)new File(dataFileName));
            YoRegistry importedRoot = SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFileName));
            SharedMemoryTestTools.assertYoRegistryEquals((YoRegistry)exportedBuffer.getRootRegistry(), (YoRegistry)importedRoot);
            YoSharedBuffer importedBuffer = SharedMemoryIOTools.importDataMatlab((File)new File(dataFileName), (YoRegistry)importedRoot);
            exportedBuffer.cropBuffer(new CropBufferRequest(exportedBuffer.getProperties().getInPoint(), exportedBuffer.getProperties().getOutPoint()));
            SharedMemoryTestTools.assertYoSharedBufferEquals((YoSharedBuffer)exportedBuffer, (YoSharedBuffer)importedBuffer, (double)0.0);
        }
        Files.delete(Paths.get(dataFileName, new String[0]));
        Files.delete(Paths.get(registryFileName, new String[0]));
    }

    @Test
    public void testExportImportMatlabLongName() throws JAXBException, IOException {
        Random random = new Random(35453L);
        String dataFileName = "./bufferMatlabExport.scs2.mat";
        String registryFileName = "./bufferMatlabExport.scs2.registry";
        for (int i = 0; i < 100; ++i) {
            YoRegistry exportedRoot = SharedMemoryRandomTools.nextYoRegistryTree((Random)random, (int)20, (int)20)[0];
            new YoDouble(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)64, (int)163), exportedRoot);
            YoRegistry longNameRegistry = new YoRegistry(SharedMemoryRandomTools.nextAlphanumericString((Random)random, (int)64, (int)163));
            exportedRoot.addChild(longNameRegistry);
            new YoDouble("bloppy", longNameRegistry);
            new YoDouble("bushy", longNameRegistry);
            YoSharedBuffer exportedBuffer = SharedMemoryRandomTools.nextYoSharedBuffer((Random)random, (YoRegistry)exportedRoot);
            SharedMemoryIOTools.exportRegistry((YoRegistry)exportedRoot, (OutputStream)new FileOutputStream(registryFileName));
            SharedMemoryIOTools.exportDataMatlab((YoSharedBuffer)exportedBuffer, (File)new File(dataFileName));
            YoRegistry importedRoot = SharedMemoryIOTools.importRegistry((InputStream)new FileInputStream(registryFileName));
            SharedMemoryTestTools.assertYoRegistryEquals((YoRegistry)exportedRoot, (YoRegistry)importedRoot);
            YoSharedBuffer importedBuffer = SharedMemoryIOTools.importDataMatlab((File)new File(dataFileName), (YoRegistry)importedRoot);
            exportedBuffer.cropBuffer(new CropBufferRequest(exportedBuffer.getProperties().getInPoint(), exportedBuffer.getProperties().getOutPoint()));
            SharedMemoryTestTools.assertYoSharedBufferEquals((YoSharedBuffer)exportedBuffer, (YoSharedBuffer)importedBuffer, (double)0.0);
        }
        Files.delete(Paths.get(dataFileName, new String[0]));
        Files.delete(Paths.get(registryFileName, new String[0]));
    }
}

