/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.scs2.sharedMemory.BufferSample;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.YoBufferProperties;
import us.ihmc.scs2.sharedMemory.YoDoubleBuffer;
import us.ihmc.scs2.sharedMemory.YoVariableBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryRandomTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoDoubleBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testConstructors() {
        int j;
        YoBufferProperties yoBufferProperties;
        YoDoubleBuffer yoDoubleBuffer;
        YoDouble yoDouble;
        int i;
        Random random = new Random(467L);
        for (i = 0; i < 1000; ++i) {
            yoDouble = SharedMemoryRandomTools.nextYoDouble((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoDouble == (yoDoubleBuffer = new YoDoubleBuffer(yoDouble, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoDoubleBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoDoubleBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((double)0.0, (double)yoDoubleBuffer.getBuffer()[j]);
            }
        }
        for (i = 0; i < 1000; ++i) {
            yoDouble = SharedMemoryRandomTools.nextYoDouble((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            Assertions.assertTrue((yoDouble == (yoDoubleBuffer = (YoDoubleBuffer)YoVariableBuffer.newYoVariableBuffer((YoVariable)yoDouble, (YoBufferPropertiesReadOnly)(yoBufferProperties = SharedMemoryRandomTools.nextYoBufferProperties((Random)random)))).getYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoBufferProperties == yoDoubleBuffer.getProperties() ? 1 : 0) != 0);
            Assertions.assertEquals((int)yoBufferProperties.getSize(), (int)yoDoubleBuffer.getBuffer().length);
            for (j = 0; j < yoBufferProperties.getSize(); ++j) {
                Assertions.assertEquals((double)0.0, (double)yoDoubleBuffer.getBuffer()[j]);
            }
        }
    }

    @Test
    public void testResizeBuffer() {
        Random random = new Random(8967254L);
        for (int i = 0; i < 1000; ++i) {
            YoDoubleBuffer yoDoubleBuffer = SharedMemoryRandomTools.nextYoDoubleBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoBufferProperties originalBufferProperties = new YoBufferProperties(yoDoubleBuffer.getProperties());
            int from = random.nextInt(yoDoubleBuffer.getProperties().getSize());
            int newLength = random.nextInt(yoDoubleBuffer.getProperties().getSize());
            double[] expectedBuffer = SharedMemoryTools.ringArrayCopy((double[])yoDoubleBuffer.getBuffer(), (int)from, (int)newLength);
            yoDoubleBuffer.resizeBuffer(from, newLength);
            Assertions.assertArrayEquals((double[])expectedBuffer, (double[])yoDoubleBuffer.getBuffer());
            Assertions.assertEquals((Object)originalBufferProperties, (Object)yoDoubleBuffer.getProperties());
            double[] buffer = yoDoubleBuffer.getBuffer();
            yoDoubleBuffer.resizeBuffer(0, buffer.length);
            Assertions.assertTrue((buffer == yoDoubleBuffer.getBuffer() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWriteBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoDoubleBuffer yoDoubleBuffer = SharedMemoryRandomTools.nextYoDoubleBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoDouble yoDouble = (YoDouble)yoDoubleBuffer.getYoVariable();
            int currentIndex = yoDoubleBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                double newValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
                yoDouble.set(newValue);
                yoDoubleBuffer.writeBuffer();
                Assertions.assertEquals((double)newValue, (double)yoDouble.getValue());
                Assertions.assertEquals((double)newValue, (double)yoDoubleBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testReadBuffer() {
        Random random = new Random(867324L);
        for (int i = 0; i < 1000; ++i) {
            YoDoubleBuffer yoDoubleBuffer = SharedMemoryRandomTools.nextYoDoubleBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            YoDouble yoDouble = (YoDouble)yoDoubleBuffer.getYoVariable();
            int currentIndex = yoDoubleBuffer.getProperties().getCurrentIndex();
            for (int j = 0; j < 10; ++j) {
                double newValue;
                yoDoubleBuffer.getBuffer()[currentIndex] = newValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
                yoDoubleBuffer.readBuffer();
                Assertions.assertEquals((double)newValue, (double)yoDouble.getValue());
                Assertions.assertEquals((double)newValue, (double)yoDoubleBuffer.getBuffer()[currentIndex]);
            }
        }
    }

    @Test
    public void testCopy() {
        Random random = new Random(43566L);
        for (int i = 0; i < 1000; ++i) {
            YoDoubleBuffer yoDoubleBuffer = SharedMemoryRandomTools.nextYoDoubleBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            int from = random.nextInt(yoDoubleBuffer.getProperties().getSize());
            int length = random.nextInt(yoDoubleBuffer.getProperties().getSize() - 1) + 1;
            double[] expectedCopy = SharedMemoryTools.ringArrayCopy((double[])yoDoubleBuffer.getBuffer(), (int)from, (int)length);
            BufferSample actualCopy = yoDoubleBuffer.copy(from, length, yoDoubleBuffer.getProperties().copy());
            Assertions.assertEquals((int)from, (int)actualCopy.getFrom());
            Assertions.assertEquals((int)length, (int)actualCopy.getSampleLength());
            Assertions.assertEquals((Object)yoDoubleBuffer.getProperties(), (Object)actualCopy.getBufferProperties());
            int to = from + length - 1;
            if (to >= yoDoubleBuffer.getProperties().getSize()) {
                to -= yoDoubleBuffer.getProperties().getSize();
            }
            Assertions.assertEquals((int)to, (int)actualCopy.getTo());
            Assertions.assertArrayEquals((double[])expectedCopy, (double[])((double[])actualCopy.getSample()));
        }
    }

    @Test
    public void testNewLinkedYoVariable() {
        Random random = new Random(87324L);
        for (int i = 0; i < 1000; ++i) {
            YoDouble linkedDouble = new YoDouble("linked", new YoRegistry("Dummy"));
            YoDoubleBuffer yoDoubleBuffer = SharedMemoryRandomTools.nextYoDoubleBuffer((Random)random, (YoRegistry)new YoRegistry("Dummy"));
            LinkedYoDouble linkedYoVariable = yoDoubleBuffer.newLinkedYoVariable(linkedDouble, null);
            Assertions.assertTrue((linkedDouble == linkedYoVariable.getLinkedYoVariable() ? 1 : 0) != 0);
            Assertions.assertTrue((yoDoubleBuffer == linkedYoVariable.getBuffer() ? 1 : 0) != 0);
        }
    }
}

