/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sharedMemory;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;

public class CropBufferRequestTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testGetters() {
        Random random = new Random(7624L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(10000);
            int from = random.nextInt(size);
            int to = random.nextInt(size);
            CropBufferRequest cropBufferRequest = new CropBufferRequest(from, to);
            Assertions.assertEquals((int)from, (int)cropBufferRequest.getFrom());
            Assertions.assertEquals((int)to, (int)cropBufferRequest.getTo());
            int index = cropBufferRequest.getFrom();
            int expectedLength = 1;
            while (index != cropBufferRequest.getTo()) {
                if (++index >= size) {
                    index = 0;
                }
                ++expectedLength;
            }
            Assertions.assertEquals((int)expectedLength, (int)cropBufferRequest.getCroppedSize(size));
        }
    }

    @Test
    public void testEquals() {
        Random random = new Random(96L);
        for (int i = 0; i < 1000; ++i) {
            int size = random.nextInt(10000);
            int from = random.nextInt(size);
            int to = random.nextInt(size);
            CropBufferRequest request = new CropBufferRequest(from, to);
            Assertions.assertFalse((boolean)request.equals(null));
            Assertions.assertFalse((boolean)request.equals(new ArrayList()));
            Assertions.assertTrue((boolean)request.equals((Object)request));
            Assertions.assertTrue((boolean)request.equals((Object)new CropBufferRequest(request)));
            Assertions.assertFalse((boolean)request.equals((Object)new CropBufferRequest(from + 1, to)));
            Assertions.assertFalse((boolean)request.equals((Object)new CropBufferRequest(from, to + 1)));
        }
    }
}

