/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final String namePrefix;
    private final int threadPriority;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public DaemonThreadFactory(String poolName) {
        this(poolName, 5);
    }

    public DaemonThreadFactory(String poolName, int threadPriority) {
        this(poolName, DaemonThreadFactory.getCurrentGroup(), threadPriority);
    }

    public DaemonThreadFactory(String poolName, ThreadGroup threadGroup, int threadPriority) {
        this.group = threadGroup;
        this.namePrefix = poolName + " Pool [Thread-";
        this.threadPriority = threadPriority;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement() + "]");
        thread.setDaemon(true);
        if (thread.getPriority() != this.threadPriority) {
            thread.setPriority(this.threadPriority);
        }
        return thread;
    }

    private static ThreadGroup getCurrentGroup() {
        return System.getSecurityManager() != null ? System.getSecurityManager().getThreadGroup() : Thread.currentThread().getThreadGroup();
    }
}

