/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class JVMStatisticsGenerator {
    private final YoRegistry registry;
    private final YoTimer timer;
    private final YoLong freeMemory;
    private final YoLong maxMemory;
    private final YoLong usedMemory;
    private final YoLong totalMemory;
    private final YoLong totalGCInvocations;
    private final YoLong totalGCTotalCollectionTimeMs;
    private final YoInteger loadedClassCount;
    private final YoLong totalLoadedClassCount;
    private final YoLong unloadedClassCount;
    private final YoLong totalCompilationTime;
    private final YoInteger availableProcessors;
    private final YoDouble systemLoadAverage;
    private final ArrayList<GCBeanHolder> gcBeanHolders = new ArrayList();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();

    public JVMStatisticsGenerator(String prefix, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(prefix + "SCS2JVMStatistics");
        this.timer = new YoTimer(prefix + "JVMStatsTimer", TimeUnit.MILLISECONDS, this.registry);
        this.freeMemory = new YoLong(prefix + "FreeMemoryInBytes", this.registry);
        this.maxMemory = new YoLong(prefix + "MaxMemoryInBytes", this.registry);
        this.usedMemory = new YoLong(prefix + "UsedMemoryInBytes", this.registry);
        this.totalMemory = new YoLong(prefix + "TotalMemoryInBytes", this.registry);
        this.totalGCInvocations = new YoLong(prefix + "TotalGCInvocations", this.registry);
        this.totalGCTotalCollectionTimeMs = new YoLong(prefix + "GCTotalCollectionTimeMs", this.registry);
        this.loadedClassCount = new YoInteger(prefix + "LoadedClassCount", this.registry);
        this.totalLoadedClassCount = new YoLong(prefix + "TotalLoadedClassCount", this.registry);
        this.unloadedClassCount = new YoLong(prefix + "UnloadedClassCount", this.registry);
        this.totalCompilationTime = new YoLong(prefix + "TotalCompilationTimeMs", this.registry);
        this.availableProcessors = new YoInteger(prefix + "AvailableProcessors", this.registry);
        this.systemLoadAverage = new YoDouble(prefix + "SystemLoadAverage", this.registry);
        this.createGCBeanHolders();
        this.availableProcessors.set(this.operatingSystemMXBean.getAvailableProcessors());
        this.maxMemory.set(Runtime.getRuntime().maxMemory());
        parentRegistry.addChild(this.registry);
    }

    public void update() {
        this.timer.start();
        this.updateGCStatistics();
        this.updateClassLoadingStatistics();
        this.updateMemoryUsageStatistics();
        if (this.compilationMXBean != null) {
            this.totalCompilationTime.set(this.compilationMXBean.getTotalCompilationTime());
        }
        this.systemLoadAverage.set(this.operatingSystemMXBean.getSystemLoadAverage());
        this.timer.stop();
    }

    private void updateMemoryUsageStatistics() {
        this.freeMemory.set(Runtime.getRuntime().freeMemory());
        this.totalMemory.set(Runtime.getRuntime().totalMemory());
        this.usedMemory.set(this.totalMemory.getLongValue() - this.freeMemory.getLongValue());
    }

    private void updateClassLoadingStatistics() {
        this.loadedClassCount.set(this.classLoadingMXBean.getLoadedClassCount());
        this.totalLoadedClassCount.set(this.classLoadingMXBean.getTotalLoadedClassCount());
        this.unloadedClassCount.set(this.classLoadingMXBean.getUnloadedClassCount());
    }

    private void updateGCStatistics() {
        long totalInvocations = 0L;
        long totalTime = 0L;
        for (int i = 0; i < this.gcBeanHolders.size(); ++i) {
            GCBeanHolder holder = this.gcBeanHolders.get(i);
            holder.update();
            totalInvocations += holder.gcInvocations.getLongValue();
            totalTime += holder.gcTotalCollectionTimeMs.getLongValue();
        }
        this.totalGCInvocations.set(totalInvocations);
        this.totalGCTotalCollectionTimeMs.set(totalTime);
    }

    private void createGCBeanHolders() {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < gcbeans.size(); ++i) {
            GarbageCollectorMXBean gcbean = gcbeans.get(i);
            String name = YoTools.ILLEGAL_CHARACTERS_PATTERN.matcher(gcbean.getName()).replaceAll("");
            this.gcBeanHolders.add(new GCBeanHolder(this, name, gcbean));
        }
    }

    private class GCBeanHolder {
        final GarbageCollectorMXBean gcBean;
        final YoLong gcInvocations;
        final YoLong gcTotalCollectionTimeMs;

        GCBeanHolder(JVMStatisticsGenerator jVMStatisticsGenerator, String name, GarbageCollectorMXBean gcBean) {
            this.gcBean = gcBean;
            this.gcInvocations = new YoLong(name + "GCInvocations", jVMStatisticsGenerator.registry);
            this.gcTotalCollectionTimeMs = new YoLong(name + "GCTotalTimeMs", jVMStatisticsGenerator.registry);
        }

        void update() {
            this.gcInvocations.set(this.gcBean.getCollectionCount());
            this.gcTotalCollectionTimeMs.set(this.gcBean.getCollectionTime());
        }
    }
}

