/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.awt.image.BufferedImage;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionRobotDefinitionListChange;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.symbolic.YoEquationManager;

public class SessionMessagerAPI {
    private static final MessagerAPIFactory apiFactory = new MessagerAPIFactory();
    private static final MessagerAPIFactory.Category root = apiFactory.createRootCategory("SessionAPI");
    private static final MessagerAPIFactory.CategoryTheme Session = apiFactory.createCategoryTheme("Session");
    private static final MessagerAPIFactory.CategoryTheme Record = apiFactory.createCategoryTheme("Record");
    private static final MessagerAPIFactory.CategoryTheme Export = apiFactory.createCategoryTheme("Export");
    private static final MessagerAPIFactory.CategoryTheme Initialize = apiFactory.createCategoryTheme("Initialize");
    private static final MessagerAPIFactory.CategoryTheme Run = apiFactory.createCategoryTheme("Run");
    private static final MessagerAPIFactory.CategoryTheme Playback = apiFactory.createCategoryTheme("Playback");
    private static final MessagerAPIFactory.CategoryTheme Change = apiFactory.createCategoryTheme("Change");
    private static final MessagerAPIFactory.CategoryTheme RobotDefinition = apiFactory.createCategoryTheme("RobotDefinition");
    private static final MessagerAPIFactory.CategoryTheme Equation = apiFactory.createCategoryTheme("Equation");
    private static final MessagerAPIFactory.TopicTheme RealTimeRate = apiFactory.createTopicTheme("RealTimeRate");
    private static final MessagerAPIFactory.TopicTheme Period = apiFactory.createTypedTopicTheme("Period");
    private static final MessagerAPIFactory.TopicTheme State = apiFactory.createTypedTopicTheme("State");
    private static final MessagerAPIFactory.TopicTheme Mode = apiFactory.createTypedTopicTheme("Mode");
    private static final MessagerAPIFactory.TopicTheme TickPeriod = apiFactory.createTypedTopicTheme("TickPeriod");
    private static final MessagerAPIFactory.TopicTheme Data = apiFactory.createTypedTopicTheme("Data");
    private static final MessagerAPIFactory.TopicTheme Request = apiFactory.createTypedTopicTheme("Request");
    public static final MessagerAPIFactory.Topic<Long> SessionDTNanoseconds = root.child(Session).child(Run).topic(Period);
    public static final MessagerAPIFactory.Topic<SessionState> SessionCurrentState = root.child(Session).topic(State);
    public static final MessagerAPIFactory.Topic<SessionMode> SessionCurrentMode = root.child(Session).topic(Mode);
    public static final MessagerAPIFactory.Topic<Integer> BufferRecordTickPeriod = root.child(Session).child(Record).topic(TickPeriod);
    public static final MessagerAPIFactory.Topic<Integer> InitializeBufferRecordTickPeriod = root.child(Session).child(Initialize).child(Record).topic(TickPeriod);
    public static final MessagerAPIFactory.Topic<Boolean> RunAtRealTimeRate = root.child(Session).child(Run).topic(RealTimeRate);
    public static final MessagerAPIFactory.Topic<Double> PlaybackRealTimeRate = root.child(Session).child(Playback).topic(RealTimeRate);
    public static final MessagerAPIFactory.Topic<SessionDataExportRequest> SessionDataExportRequest = root.child(Session).child(Export).topic(Data);
    public static final MessagerAPIFactory.Topic<SessionRobotDefinitionListChange> SessionRobotDefinitionListChangeRequest = root.child(Session).child(Change).child(RobotDefinition).topic(Request);
    public static final MessagerAPIFactory.Topic<SessionRobotDefinitionListChange> SessionRobotDefinitionListChangeState = root.child(Session).child(Change).child(RobotDefinition).topic(State);
    public static final MessagerAPIFactory.Topic<YoEquationManager.YoEquationListChange> SessionYoEquationListChangeRequest = root.child(Session).child(Change).child(Equation).topic(Request);
    public static final MessagerAPIFactory.Topic<YoEquationManager.YoEquationListChange> SessionYoEquationListChangeState = root.child(Session).child(Change).child(Equation).topic(State);
    public static final MessagerAPIFactory.MessagerAPI API;

    private SessionMessagerAPI() {
    }

    static {
        new Sensors();
        API = apiFactory.getAPIAndCloseFactory();
    }

    public static class Sensors {
        private static final MessagerAPIFactory.CategoryTheme Sensor = apiFactory.createCategoryTheme("Sensor");
        private static final MessagerAPIFactory.CategoryTheme Camera = apiFactory.createCategoryTheme("Camera");
        private static final MessagerAPIFactory.TopicTheme Definition = apiFactory.createTypedTopicTheme("Definition");
        private static final MessagerAPIFactory.TopicTheme Frame = apiFactory.createTypedTopicTheme("Frame");
        public static final MessagerAPIFactory.Topic<SensorMessage<CameraSensorDefinition>> CameraSensorDefinitionData = root.child(Sensor).child(Camera).topic(Definition);
        public static final MessagerAPIFactory.Topic<SensorMessage<BufferedImage>> CameraSensorFrame = root.child(Sensor).child(Camera).topic(Frame);

        public static class SensorMessage<T> {
            private final String robotName;
            private final String sensorName;
            private final T messageContent;

            public SensorMessage(String robotName, String sensorName, T messageContent) {
                this.robotName = robotName;
                this.sensorName = sensorName;
                this.messageContent = messageContent;
            }

            public String getRobotName() {
                return this.robotName;
            }

            public String getSensorName() {
                return this.sensorName;
            }

            public T getMessageContent() {
                return this.messageContent;
            }

            public String toString() {
                return "[robotName=" + this.robotName + ", sensorName=" + this.sensorName + ", messageContent=" + this.messageContent + "]";
            }
        }
    }
}

