/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.xml.bind.JAXBException;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.TopicListener;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.DaemonThreadFactory;
import us.ihmc.scs2.session.JVMStatisticsGenerator;
import us.ihmc.scs2.session.SessionDataExportRequest;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionProperties;
import us.ihmc.scs2.session.SessionPropertiesHelper;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.session.YoSharedBufferMessagerAPI;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.FillBufferRequest;
import us.ihmc.scs2.sharedMemory.YoSharedBuffer;
import us.ihmc.scs2.sharedMemory.interfaces.LinkedYoVariableFactory;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class Session {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = SessionPropertiesHelper.loadIntegerProperty("scs2.session.buffer.initialsize", 8192);
    private static final int DEFAULT_BUFFER_RECORD_TICK_PERIOD = SessionPropertiesHelper.loadIntegerProperty("scs2.session.buffer.recordtickperiod", 1);
    private static final boolean DEFAULT_RUN_AT_REALTIME_RATE = SessionPropertiesHelper.loadBooleanProperty("scs2.session.runrealtime", false);
    private static final double DEFAULT_PLAYBACK_REALTIME_RATE = SessionPropertiesHelper.loadDoubleProperty("scs2.session.playrealtime", 2.0);
    private static final long DEFAULT_BUFFER_PUBLISH_PERIOD = SessionPropertiesHelper.loadLongProperty("scs2.session.buffer.publishperiod", 33333333L);
    public static final String ROOT_REGISTRY_NAME = "root";
    public static final String SESSION_INTERNAL_REGISTRY_NAME = Session.class.getSimpleName() + "InternalRegistry";
    public static final YoNamespace ROOT_NAMESPACE = new YoNamespace("root");
    public static final YoNamespace SESSION_INTERNAL_NAMESPACE = ROOT_NAMESPACE.append(SESSION_INTERNAL_REGISTRY_NAME);
    public static final String SCS2_INTERNAL_FRAME_SUFFIX = "[SCS2Internal]";
    protected final ReferenceFrame inertialFrame;
    protected final YoRegistry rootRegistry = new YoRegistry("root");
    protected final YoRegistry sessionRegistry = new YoRegistry(SESSION_INTERNAL_REGISTRY_NAME);
    protected final YoDouble time = new YoDouble("time[sec]", this.rootRegistry);
    private final JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator("SCS2Stats", this.sessionRegistry);
    protected final YoRegistry runRegistry = new YoRegistry("runStatistics");
    private final YoTimer runActualDT = new YoTimer("runActualDT", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runTimer = new YoTimer("runTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runInitializeTimer = new YoTimer("runInitializeTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runSpecificTimer = new YoTimer("runSpecificTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    private final YoTimer runFinalizeTimer = new YoTimer("runFinalizeTimer", TimeUnit.MILLISECONDS, this.runRegistry);
    protected final YoRegistry playbackRegistry = new YoRegistry("playbackStatistics");
    private final YoTimer playbackActualDT = new YoTimer("playbackActualDT", TimeUnit.MILLISECONDS, this.playbackRegistry);
    private final YoTimer playbackTimer = new YoTimer("playbackTimer", TimeUnit.MILLISECONDS, this.playbackRegistry);
    protected final YoRegistry pauseRegistry = new YoRegistry("pauseStatistics");
    private final YoTimer pauseActualDT = new YoTimer("pauseActualDT", TimeUnit.MILLISECONDS, this.pauseRegistry);
    private final YoTimer pauseTimer = new YoTimer("pauseTimer", TimeUnit.MILLISECONDS, this.pauseRegistry);
    protected final YoSharedBuffer sharedBuffer = new YoSharedBuffer(this.rootRegistry, DEFAULT_INITIAL_BUFFER_SIZE);
    private final AtomicReference<SessionMode> activeMode = new AtomicReference<SessionMode>(SessionMode.PAUSE);
    private final AtomicBoolean runAtRealTimeRate = new AtomicBoolean(DEFAULT_RUN_AT_REALTIME_RATE);
    private final AtomicReference<Double> playbackRealTimeRate = new AtomicReference<Double>(DEFAULT_PLAYBACK_REALTIME_RATE);
    private int stepSizePerPlaybackTick = 1;
    private final AtomicInteger bufferRecordTickPeriod = new AtomicInteger(DEFAULT_BUFFER_RECORD_TICK_PERIOD);
    private final AtomicLong sessionDTNanoseconds = new AtomicLong(Conversions.secondsToNanoseconds((double)1.0E-4));
    private final AtomicLong desiredBufferPublishPeriod = new AtomicLong(DEFAULT_BUFFER_PUBLISH_PERIOD);
    private final long sessionPropertiesPublishPeriod = 500L;
    private long lastSessionPropertiesPublishTimestamp = -1L;
    private final List<SessionModeChangeListener> sessionModeChangeListeners = new ArrayList<SessionModeChangeListener>();
    private final List<SessionModeChangeListener> preSessionModeChangeListeners = new ArrayList<SessionModeChangeListener>();
    private final List<Consumer<SessionProperties>> sessionPropertiesListeners = new ArrayList<Consumer<SessionProperties>>();
    private final List<Consumer<YoBufferPropertiesReadOnly>> currentBufferPropertiesListeners = new ArrayList<Consumer<YoBufferPropertiesReadOnly>>();
    private final List<Runnable> shutdownListeners = new ArrayList<Runnable>();
    private final List<Consumer<Throwable>> runThrowableListeners = new ArrayList<Consumer<Throwable>>();
    private final List<Consumer<Throwable>> playbackThrowableListeners = new ArrayList<Consumer<Throwable>>();
    private final SessionUserField<CropBufferRequest> pendingCropBufferRequest = new SessionUserField();
    private final SessionUserField<FillBufferRequest> pendingFillBufferRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingBufferIndexRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingBufferInPointIndexRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingBufferOutPointIndexRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingIncrementBufferIndexRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingDecrementBufferIndexRequest = new SessionUserField();
    private final SessionUserField<Integer> pendingBufferSizeRequest = new SessionUserField();
    private final SessionUserField<SessionDataExportRequest> pendingDataExportRequest = new SessionUserField();
    private final List<SessionTopicListenerManager> sessionTopicListenerManagers = new ArrayList<SessionTopicListenerManager>();
    private boolean sessionThreadStarted = false;
    private boolean sessionInitialized = false;
    private boolean isSessionShutdown = false;
    private long lastPublishedBufferTimestamp = -1L;
    protected boolean firstRunTick = true;
    protected boolean firstPauseTick = true;
    protected final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, new DaemonThreadFactory("SCS2-Session-Thread"));
    protected PeriodicTaskWrapper activePeriodicTask;
    private final EnumMap<SessionMode, Runnable> sessionModeToTaskMap = new EnumMap(SessionMode.class);
    protected boolean hasBufferSizeBeenInitialized = false;
    protected boolean hasBufferRecordPeriodBeenInitialized = false;
    protected int nextRunBufferRecordTickCounter = 0;

    public Session() {
        this(ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    }

    public Session(ReferenceFrame inertialFrame) {
        this.inertialFrame = inertialFrame;
        this.rootRegistry.addChild(this.sessionRegistry);
        this.sessionRegistry.addChild(this.runRegistry);
        this.sessionRegistry.addChild(this.playbackRegistry);
        this.sessionRegistry.addChild(this.pauseRegistry);
        this.setSessionModeTask(SessionMode.RUNNING, this::runTick);
        this.setSessionModeTask(SessionMode.PLAYBACK, this::playbackTick);
        this.setSessionModeTask(SessionMode.PAUSE, this::pauseTick);
    }

    public static String retrieveCallerName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String className = stackTrace[stackTrace.length - 1].getClassName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public void setupWithMessager(Messager messager) {
        for (SessionTopicListenerManager manager : this.sessionTopicListenerManagers) {
            if (messager != manager.messager) continue;
            throw new IllegalArgumentException("Messager already registered.");
        }
        this.sessionTopicListenerManagers.add(new SessionTopicListenerManager(messager));
    }

    public void setSessionMode(SessionMode sessionMode) {
        this.setSessionMode(sessionMode, null);
    }

    protected void setSessionMode(SessionMode sessionMode, SessionModeTransition transition) {
        SessionMode currentMode = this.activeMode.get();
        if (sessionMode != currentMode) {
            this.scheduleSessionTask(sessionMode, transition);
        }
    }

    public void addSessionModeChangeListener(SessionModeChangeListener listener) {
        this.sessionModeChangeListeners.add(listener);
    }

    public boolean removeSessionModeChangeListener(SessionModeChangeListener listener) {
        return this.sessionModeChangeListeners.remove(listener);
    }

    public void addPreSessionModeChangeListener(SessionModeChangeListener listener) {
        this.preSessionModeChangeListeners.add(listener);
    }

    public boolean removePreSessionModeChangeListener(SessionModeChangeListener listener) {
        return this.preSessionModeChangeListeners.remove(listener);
    }

    public void addShutdownListener(Runnable listener) {
        this.shutdownListeners.add(listener);
    }

    public boolean removeShutdownListener(Runnable listener) {
        return this.shutdownListeners.remove(listener);
    }

    public void addSessionPropertiesListener(Consumer<SessionProperties> listener) {
        this.sessionPropertiesListeners.add(listener);
    }

    public boolean removeSessionPropertiesListener(Consumer<SessionProperties> listener) {
        return this.sessionPropertiesListeners.remove(listener);
    }

    public void addCurrentBufferPropertiesListener(Consumer<YoBufferPropertiesReadOnly> listener) {
        this.currentBufferPropertiesListeners.add(listener);
    }

    public boolean removeCurrentBufferPropertiesListener(Consumer<YoBufferPropertiesReadOnly> listener) {
        return this.currentBufferPropertiesListeners.remove(listener);
    }

    public void addRunThrowableListener(Consumer<Throwable> listener) {
        this.runThrowableListeners.add(listener);
    }

    public boolean removeRunThrowableListener(Consumer<Throwable> listener) {
        return this.runThrowableListeners.remove(listener);
    }

    public void addPlaybackThrowableListener(Consumer<Throwable> listener) {
        this.playbackThrowableListeners.add(listener);
    }

    public boolean removePlaybackThrowableListener(Consumer<Throwable> listener) {
        return this.playbackThrowableListeners.remove(listener);
    }

    public void setSessionDTSeconds(double sessionDTSeconds) {
        this.setSessionDTNanoseconds(Conversions.secondsToNanoseconds((double)sessionDTSeconds));
    }

    public void setSessionDTNanoseconds(long sessionDTNanoseconds) {
        if (this.sessionDTNanoseconds.get() == sessionDTNanoseconds) {
            return;
        }
        this.sessionDTNanoseconds.set(sessionDTNanoseconds);
        this.scheduleSessionTask(this.getActiveMode());
    }

    public boolean initializeBufferSize(int bufferSize) {
        if (this.hasBufferSizeBeenInitialized) {
            return false;
        }
        this.submitBufferSizeRequest(bufferSize);
        return true;
    }

    public boolean initializeBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        if (this.hasBufferRecordPeriodBeenInitialized) {
            return false;
        }
        this.setBufferRecordTickPeriod(bufferRecordTickPeriod);
        return true;
    }

    public void submitRunAtRealTimeRate(boolean runAtRealTimeRate) {
        if (this.runAtRealTimeRate.get() == runAtRealTimeRate) {
            return;
        }
        this.runAtRealTimeRate.set(runAtRealTimeRate);
        if (this.getActiveMode() == SessionMode.RUNNING) {
            this.scheduleSessionTask(this.getActiveMode());
        }
    }

    public void submitPlaybackRealTimeRate(double realTimeRate) {
        if (this.playbackRealTimeRate.get() == realTimeRate) {
            return;
        }
        this.playbackRealTimeRate.set(realTimeRate);
        if (this.getActiveMode() == SessionMode.PLAYBACK) {
            this.scheduleSessionTask(this.getActiveMode());
        }
    }

    public void setBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        this.hasBufferRecordPeriodBeenInitialized = true;
        if (bufferRecordTickPeriod == this.bufferRecordTickPeriod.get()) {
            return;
        }
        this.bufferRecordTickPeriod.set(Math.max(1, bufferRecordTickPeriod));
    }

    public void setDesiredBufferPublishPeriod(long publishPeriod) {
        this.desiredBufferPublishPeriod.set(publishPeriod);
    }

    public void submitCropBufferRequest(CropBufferRequest cropBufferRequest) {
        this.pendingCropBufferRequest.submit(cropBufferRequest);
    }

    public void submitFillBufferRequest(FillBufferRequest fillBufferRequest) {
        this.pendingFillBufferRequest.submit(fillBufferRequest);
    }

    public void submitBufferSizeRequest(Integer bufferSizeRequest) {
        this.pendingBufferSizeRequest.submit(bufferSizeRequest);
        this.hasBufferSizeBeenInitialized = true;
    }

    public void submitBufferIndexRequest(Integer bufferIndexRequest) {
        this.pendingBufferIndexRequest.submit(bufferIndexRequest);
    }

    public void submitIncrementBufferIndexRequest(Integer incrementBufferIndexRequest) {
        this.pendingIncrementBufferIndexRequest.submit(incrementBufferIndexRequest);
    }

    public void submitDecrementBufferIndexRequest(Integer decrementBufferIndexRequest) {
        this.pendingDecrementBufferIndexRequest.submit(decrementBufferIndexRequest);
    }

    public void submitBufferInPointIndexRequest(Integer bufferInPointIndexRequest) {
        this.pendingBufferInPointIndexRequest.submit(bufferInPointIndexRequest);
    }

    public void submitBufferOutPointIndexRequest(Integer bufferOutPointIndexRequest) {
        this.pendingBufferOutPointIndexRequest.submit(bufferOutPointIndexRequest);
    }

    public void submitSessionDataExportRequest(SessionDataExportRequest sessionDataExportRequest) {
        this.pendingDataExportRequest.submit(sessionDataExportRequest);
    }

    public void submitCropBufferRequestAndWait(CropBufferRequest cropBufferRequest) {
        if (this.hasSessionStarted()) {
            this.pendingCropBufferRequest.submitAndWait(cropBufferRequest);
        } else {
            this.pendingCropBufferRequest.submit(cropBufferRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitFillBufferRequestAndWait(FillBufferRequest fillBufferRequest) {
        if (this.hasSessionStarted()) {
            this.pendingFillBufferRequest.submitAndWait(fillBufferRequest);
        } else {
            this.pendingFillBufferRequest.submit(fillBufferRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitBufferSizeRequestAndWait(Integer bufferSizeRequest) {
        this.hasBufferSizeBeenInitialized = true;
        if (this.hasSessionStarted()) {
            this.pendingBufferSizeRequest.submitAndWait(bufferSizeRequest);
        } else {
            this.pendingBufferSizeRequest.submit(bufferSizeRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitBufferIndexRequestAndWait(Integer bufferIndexRequest) {
        if (this.hasSessionStarted()) {
            this.pendingBufferIndexRequest.submitAndWait(bufferIndexRequest);
        } else {
            this.pendingBufferIndexRequest.submit(bufferIndexRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitIncrementBufferIndexRequestAndWait(Integer incrementBufferIndexRequest) {
        if (this.hasSessionStarted()) {
            this.pendingIncrementBufferIndexRequest.submitAndWait(incrementBufferIndexRequest);
        } else {
            this.pendingIncrementBufferIndexRequest.submit(incrementBufferIndexRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitDecrementBufferIndexRequestAndWait(Integer decrementBufferIndexRequest) {
        if (this.hasSessionStarted()) {
            this.pendingDecrementBufferIndexRequest.submitAndWait(decrementBufferIndexRequest);
        } else {
            this.pendingDecrementBufferIndexRequest.submit(decrementBufferIndexRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitBufferInPointIndexRequestAndWait(Integer bufferInPointIndexRequest) {
        if (this.hasSessionStarted()) {
            this.pendingBufferInPointIndexRequest.submitAndWait(bufferInPointIndexRequest);
        } else {
            this.pendingBufferInPointIndexRequest.submit(bufferInPointIndexRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitBufferOutPointIndexRequestAndWait(Integer bufferOutPointIndexRequest) {
        if (this.hasSessionStarted()) {
            this.pendingBufferOutPointIndexRequest.submitAndWait(bufferOutPointIndexRequest);
        } else {
            this.pendingBufferOutPointIndexRequest.submit(bufferOutPointIndexRequest);
            this.processBufferRequests(true);
        }
    }

    public void submitSessionDataExportRequestAndWait(SessionDataExportRequest sessionDataExportRequest) {
        if (this.hasSessionStarted()) {
            this.pendingDataExportRequest.submitAndWait(sessionDataExportRequest);
        } else {
            this.pendingDataExportRequest.submit(sessionDataExportRequest);
            this.processBufferRequests(true);
        }
    }

    public boolean startSessionThread() {
        if (this.sessionThreadStarted) {
            LogTools.info((String)"Session already started.");
            return false;
        }
        if (this.isSessionShutdown) {
            LogTools.error((String)"Session has been shutdown.");
            return false;
        }
        LogTools.trace((String)"Starting session's thread");
        this.sessionThreadStarted = true;
        this.scheduleSessionTask(this.getActiveMode());
        return true;
    }

    public boolean stopSessionThread() {
        if (!this.sessionThreadStarted) {
            return false;
        }
        if (this.isSessionShutdown) {
            return false;
        }
        if (this.activePeriodicTask != null) {
            this.activePeriodicTask.stopAndWait();
            this.activePeriodicTask = null;
        }
        this.sessionThreadStarted = false;
        return true;
    }

    public void shutdownSession() {
        if (this.isSessionShutdown) {
            return;
        }
        this.isSessionShutdown = true;
        this.shutdownListeners.forEach(Runnable::run);
        LogTools.info((String)"Shutting down {}: {}", (Object)this.getClass().getSimpleName(), (Object)this.getSessionName());
        this.sessionThreadStarted = false;
        if (this.activePeriodicTask != null) {
            this.activePeriodicTask.stopAndWait();
            this.activePeriodicTask = null;
        }
        this.sessionTopicListenerManagers.forEach(rec$ -> ((SessionTopicListenerManager)rec$).detachFromMessager());
        this.sessionTopicListenerManagers.clear();
        this.sharedBuffer.dispose();
        this.rootRegistry.clear();
        this.executorService.shutdown();
        this.inertialFrame.removeListeners();
        this.inertialFrame.clearChildren();
    }

    private void scheduleSessionTask(SessionMode sessionMode) {
        this.scheduleSessionTask(sessionMode, null);
    }

    private void scheduleSessionTask(SessionMode newMode, final SessionModeTransition transition) {
        Runnable command;
        SessionMode previousMode = this.activeMode.get();
        this.preSessionModeChangeListeners.forEach(listener -> listener.onChange(previousMode, newMode));
        if (!this.sessionThreadStarted) {
            if (newMode != previousMode) {
                this.firstRunTick = true;
                this.firstPauseTick = true;
            }
            this.activeMode.set(newMode);
            this.sessionModeChangeListeners.forEach(listener -> listener.onChange(previousMode, newMode));
            this.reportActiveMode();
            return;
        }
        if (this.activePeriodicTask != null) {
            this.activePeriodicTask.stopAndWait();
            this.activePeriodicTask = null;
        }
        if (this.isSessionShutdown) {
            return;
        }
        if (newMode != previousMode) {
            this.firstRunTick = true;
            this.firstPauseTick = true;
        }
        this.runActualDT.reset();
        this.playbackActualDT.reset();
        this.pauseActualDT.reset();
        final Runnable sessionModeTask = this.sessionModeToTaskMap.get((Object)newMode);
        if (transition == null) {
            command = sessionModeTask;
        } else {
            Objects.requireNonNull(transition.getNextMode(), "nextMode argument is required when providing a terminalCondition");
            command = new Runnable(){
                private boolean terminated = false;

                @Override
                public void run() {
                    sessionModeTask.run();
                    if (this.terminated) {
                        return;
                    }
                    this.terminated = transition.isDone();
                    if (this.terminated) {
                        Session.this.executorService.execute(() -> {
                            Session.this.setSessionMode(transition.getNextMode());
                            transition.notifyTransitionComplete();
                        });
                    }
                }
            };
        }
        if (this.isSessionShutdown) {
            return;
        }
        this.activePeriodicTask = new PeriodicTaskWrapper(command, this.computeThreadPeriod(newMode), TimeUnit.NANOSECONDS);
        this.activeMode.set(newMode);
        this.schedulingSessionMode(previousMode, newMode);
        this.executorService.execute(this.activePeriodicTask);
        this.sessionModeChangeListeners.forEach(listener -> listener.onChange(previousMode, newMode));
        this.reportActiveMode();
    }

    protected void schedulingSessionMode(SessionMode previousMode, SessionMode newMode) {
    }

    private long computeThreadPeriod(SessionMode mode) {
        switch (mode) {
            case RUNNING: {
                return this.computeRunTaskPeriod();
            }
            case PAUSE: {
                return this.computePauseTaskPeriod();
            }
            case PLAYBACK: {
                return this.computePlaybackTaskPeriod();
            }
        }
        throw new UnsupportedOperationException("Unhandled session mode: " + (Object)((Object)mode));
    }

    protected void setSessionModeTask(SessionMode sessionMode, Runnable runnable) {
        this.sessionModeToTaskMap.put(sessionMode, runnable);
    }

    private void reportActiveMode() {
        for (Consumer<SessionProperties> listener : this.sessionPropertiesListeners) {
            listener.accept(this.getSessionProperties());
        }
    }

    public SessionProperties getSessionProperties() {
        return new SessionProperties(this.activeMode.get(), this.runAtRealTimeRate.get(), this.playbackRealTimeRate.get(), this.sessionDTNanoseconds.get(), this.bufferRecordTickPeriod.get());
    }

    public void reinitializeSession() {
        this.sessionInitialized = false;
    }

    protected void initializeSession() {
    }

    protected long computeRunTaskPeriod() {
        return this.runAtRealTimeRate.get() ? this.sessionDTNanoseconds.get() : 1L;
    }

    protected void doGeneric(SessionMode currentMode) {
        long currentTimestamp;
        if (!this.sessionInitialized) {
            this.initializeSession();
            if (currentMode == SessionMode.PAUSE || currentMode == SessionMode.PLAYBACK) {
                this.sharedBuffer.writeBuffer();
            }
            this.sessionInitialized = true;
        }
        if ((currentTimestamp = System.nanoTime()) - this.lastSessionPropertiesPublishTimestamp > 500L) {
            this.lastSessionPropertiesPublishTimestamp = currentTimestamp;
            this.reportActiveMode();
        }
    }

    public boolean runTick() {
        boolean caughtException;
        this.runTimer.start();
        this.runActualDT.update();
        this.doGeneric(SessionMode.RUNNING);
        this.runInitializeTimer.start();
        this.initializeRunTick();
        this.runInitializeTimer.stop();
        try {
            this.runSpecificTimer.start();
            this.time.set(this.doSpecificRunTick());
            this.runSpecificTimer.stop();
            caughtException = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.runThrowableListeners.forEach(listener -> listener.accept(e));
            caughtException = true;
        }
        this.jvmStatisticsGenerator.update();
        this.runFinalizeTimer.start();
        this.finalizeRunTick(false);
        this.runFinalizeTimer.stop();
        this.runTimer.stop();
        if (caughtException) {
            this.setSessionMode(SessionMode.PAUSE);
        }
        return !caughtException;
    }

    protected void initializeRunTick() {
        if (this.firstRunTick) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
            this.nextRunBufferRecordTickCounter = 0;
            this.firstRunTick = false;
        } else if (this.nextRunBufferRecordTickCounter <= 0) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
        }
    }

    protected abstract double doSpecificRunTick();

    protected void finalizeRunTick(boolean forceWriteBuffer) {
        boolean writeBuffer;
        boolean bl = writeBuffer = this.nextRunBufferRecordTickCounter <= 0;
        if (!writeBuffer && forceWriteBuffer) {
            this.sharedBuffer.incrementBufferIndex(true);
            writeBuffer = true;
        }
        if (writeBuffer) {
            this.sharedBuffer.writeBuffer();
            long currentTimestamp = System.nanoTime();
            if (currentTimestamp - this.lastPublishedBufferTimestamp > this.desiredBufferPublishPeriod.get()) {
                this.sharedBuffer.prepareLinkedBuffersForPull();
                this.lastPublishedBufferTimestamp = currentTimestamp;
            }
            this.processBufferRequests(false);
            this.publishBufferProperties(this.sharedBuffer.getProperties());
            this.nextRunBufferRecordTickCounter = Math.max(1, this.bufferRecordTickPeriod.get());
        }
        --this.nextRunBufferRecordTickCounter;
    }

    public boolean hasWrittenBufferInLastRunTick() {
        return this.nextRunBufferRecordTickCounter == Math.max(1, this.bufferRecordTickPeriod.get()) - 1;
    }

    protected long computePlaybackTaskPeriod() {
        long timeIncrement = this.sessionDTNanoseconds.get() * (long)this.bufferRecordTickPeriod.get();
        if (this.playbackRealTimeRate.get() <= 0.5) {
            this.stepSizePerPlaybackTick = 1;
            return (long)((double)timeIncrement / this.playbackRealTimeRate.get());
        }
        this.stepSizePerPlaybackTick = 2 * Math.max(1, (int)Math.floor(this.playbackRealTimeRate.get()));
        return (long)((double)(timeIncrement * (long)this.stepSizePerPlaybackTick) / this.playbackRealTimeRate.get());
    }

    public void playbackTick() {
        boolean caughtException;
        this.playbackTimer.start();
        this.playbackActualDT.update();
        this.doGeneric(SessionMode.PLAYBACK);
        this.initializePlaybackTick();
        try {
            this.doSpecificPlaybackTick();
            caughtException = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.playbackThrowableListeners.forEach(listener -> listener.accept(e));
            caughtException = true;
        }
        this.finalizePlaybackTick();
        this.playbackTimer.stop();
        if (caughtException) {
            this.setSessionMode(SessionMode.PAUSE);
        }
    }

    protected void initializePlaybackTick() {
        this.sharedBuffer.flushLinkedPushRequests();
        this.sharedBuffer.readBuffer();
    }

    protected void doSpecificPlaybackTick() {
    }

    protected void finalizePlaybackTick() {
        long currentTimestamp = System.nanoTime();
        if (currentTimestamp - this.lastPublishedBufferTimestamp > this.desiredBufferPublishPeriod.get()) {
            this.sharedBuffer.prepareLinkedBuffersForPull();
            this.lastPublishedBufferTimestamp = currentTimestamp;
        }
        this.sharedBuffer.incrementBufferIndex(false, this.stepSizePerPlaybackTick);
        this.processBufferRequests(false);
        this.publishBufferProperties(this.sharedBuffer.getProperties());
    }

    protected long computePauseTaskPeriod() {
        return Conversions.secondsToNanoseconds((double)0.01);
    }

    public void pauseTick() {
        this.pauseTimer.start();
        this.pauseActualDT.update();
        this.doGeneric(SessionMode.PAUSE);
        boolean shouldReadBuffer = this.initializePauseTick();
        this.finalizePauseTick(shouldReadBuffer |= this.doSpecificPauseTick());
        this.pauseTimer.stop();
    }

    protected boolean initializePauseTick() {
        boolean shouldReadBuffer = this.firstPauseTick;
        this.firstPauseTick = false;
        shouldReadBuffer |= this.sharedBuffer.processLinkedPushRequests(true);
        if (!(shouldReadBuffer |= this.processBufferRequests(true))) {
            shouldReadBuffer = this.sharedBuffer.hasRequestPending();
        }
        return shouldReadBuffer;
    }

    protected boolean doSpecificPauseTick() {
        return false;
    }

    protected void finalizePauseTick(boolean shouldReadBuffer) {
        long currentTimestamp;
        if (shouldReadBuffer) {
            this.sharedBuffer.readBuffer();
        }
        if ((currentTimestamp = System.nanoTime()) - this.lastPublishedBufferTimestamp > this.desiredBufferPublishPeriod.get()) {
            this.sharedBuffer.prepareLinkedBuffersForPull();
            this.lastPublishedBufferTimestamp = currentTimestamp;
        }
        this.publishBufferProperties(this.sharedBuffer.getProperties());
    }

    protected void publishBufferProperties(YoBufferPropertiesReadOnly bufferProperties) {
        for (Consumer<YoBufferPropertiesReadOnly> listener : this.currentBufferPropertiesListeners) {
            listener.accept(bufferProperties.copy());
        }
    }

    protected boolean processBufferRequests(boolean bufferChangesPermitted) {
        boolean hasBufferBeenUpdated = false;
        CropBufferRequest newCropRequest = this.pendingCropBufferRequest.poll();
        if (bufferChangesPermitted && newCropRequest != null) {
            this.sharedBuffer.cropBuffer(newCropRequest);
            hasBufferBeenUpdated = true;
            bufferChangesPermitted = false;
        }
        Integer newIndex = this.pendingBufferIndexRequest.poll();
        Integer newInPoint = this.pendingBufferInPointIndexRequest.poll();
        Integer newOutPoint = this.pendingBufferOutPointIndexRequest.poll();
        Integer incStepSize = this.pendingIncrementBufferIndexRequest.poll();
        Integer decStepSize = this.pendingDecrementBufferIndexRequest.poll();
        Integer newSize = this.pendingBufferSizeRequest.poll();
        FillBufferRequest fillBufferRequest = this.pendingFillBufferRequest.poll();
        SessionDataExportRequest dataExportRequest = this.pendingDataExportRequest.poll();
        if (bufferChangesPermitted) {
            if (newIndex != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setCurrentIndex(newIndex.intValue());
            }
            if (newInPoint != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setInPoint(newInPoint.intValue());
            }
            if (newOutPoint != null) {
                hasBufferBeenUpdated |= this.sharedBuffer.setOutPoint(newOutPoint.intValue());
            }
            if (incStepSize != null) {
                this.sharedBuffer.incrementBufferIndex(false, incStepSize.intValue());
                hasBufferBeenUpdated = true;
            }
            if (decStepSize != null) {
                this.sharedBuffer.decrementBufferIndex(decStepSize.intValue());
                hasBufferBeenUpdated = true;
            }
            if (fillBufferRequest != null) {
                this.sharedBuffer.fillBuffer(fillBufferRequest);
                hasBufferBeenUpdated = true;
            }
            if (dataExportRequest != null) {
                try {
                    SessionIOTools.exportSessionData(this, dataExportRequest);
                }
                catch (IOException | URISyntaxException | JAXBException e) {
                    e.printStackTrace();
                }
            }
        }
        if (newSize != null) {
            hasBufferBeenUpdated |= this.sharedBuffer.resizeBuffer(newSize.intValue());
        }
        return hasBufferBeenUpdated;
    }

    public YoDouble getTime() {
        return this.time;
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public boolean hasSessionStarted() {
        return this.sessionThreadStarted;
    }

    public boolean isSessionShutdown() {
        return this.isSessionShutdown;
    }

    public SessionMode getActiveMode() {
        return this.activeMode.get();
    }

    public boolean getRunAtRealTimeRate() {
        return this.runAtRealTimeRate.get();
    }

    public double getPlaybackRealTimeRate() {
        return this.playbackRealTimeRate.get();
    }

    public int getBufferRecordTickPeriod() {
        return this.bufferRecordTickPeriod.get();
    }

    public double getBufferRecordTimePeriod() {
        return (double)this.getBufferRecordTickPeriod() * this.getSessionDTSeconds();
    }

    public double getSessionDTSeconds() {
        return (double)this.sessionDTNanoseconds.get() * 1.0E-9;
    }

    public long getSessionDTNanoseconds() {
        return this.sessionDTNanoseconds.get();
    }

    public long getDesiredBufferPublishPeriod() {
        return this.desiredBufferPublishPeriod.get();
    }

    public abstract String getSessionName();

    public final ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public abstract List<RobotDefinition> getRobotDefinitions();

    public abstract List<TerrainObjectDefinition> getTerrainObjectDefinitions();

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return Collections.emptyList();
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return null;
    }

    public YoSharedBuffer getBuffer() {
        return this.sharedBuffer;
    }

    public YoBufferPropertiesReadOnly getBufferProperties() {
        return this.sharedBuffer.getProperties();
    }

    public LinkedYoVariableFactory getLinkedYoVariableFactory() {
        return this.sharedBuffer;
    }

    protected class SessionUserField<T> {
        private final AtomicReference<T> nonBlockingRequest;
        private final ConcurrentLinkedQueue<BlockingRequest> blockingRequests = new ConcurrentLinkedQueue();
        private T currentValue;

        public SessionUserField() {
            this(null);
        }

        public SessionUserField(T initialValue) {
            this.currentValue = initialValue;
            this.nonBlockingRequest = new AtomicReference<T>(initialValue);
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public void submit(T newValue) {
            this.nonBlockingRequest.set(newValue);
        }

        public void submitAndWait(T newValue) {
            BlockingRequest blockingRequest = new BlockingRequest(newValue);
            this.blockingRequests.add(blockingRequest);
            try {
                blockingRequest.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public T poll() {
            if (this.blockingRequests.isEmpty()) {
                return this.nonBlockingRequest.getAndSet(null);
            }
            return this.blockingRequests.poll().process();
        }

        private class BlockingRequest {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final T requestedValue;

            public BlockingRequest(T requestedValue) {
                this.requestedValue = requestedValue;
            }

            public T process() {
                try {
                    Object t = this.requestedValue;
                    return t;
                }
                finally {
                    this.latch.countDown();
                }
            }
        }
    }

    public static class PeriodicTaskWrapper
    implements Runnable {
        private static final int ONE_MILLION = 1000000;
        private final Runnable task;
        private final long periodInNanos;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private final AtomicBoolean isDone = new AtomicBoolean(false);
        private final CountDownLatch startedLatch = new CountDownLatch(1);
        private final CountDownLatch doneLatch = new CountDownLatch(1);
        private Thread owner;

        public PeriodicTaskWrapper(Runnable task, long period, TimeUnit timeUnit) {
            this.task = task;
            this.periodInNanos = timeUnit.toNanos(period);
        }

        public void stop() {
            this.running.set(false);
        }

        public boolean isDone() {
            return this.isDone.get();
        }

        public void stopAndWait() {
            this.stop();
            if (Thread.currentThread() == this.owner) {
                return;
            }
            try {
                this.doneLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void waitUntilFirstTickDone() {
            if (Thread.currentThread() == this.owner) {
                return;
            }
            try {
                this.startedLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            if (this.owner == null) {
                this.owner = Thread.currentThread();
            }
            block4: while (true) {
                try {
                    while (this.running.get()) {
                        long timeElapsed = System.nanoTime();
                        this.task.run();
                        timeElapsed = System.nanoTime() - timeElapsed;
                        this.startedLatch.countDown();
                        if (timeElapsed >= this.periodInNanos) continue;
                        long nanos = this.periodInNanos - timeElapsed;
                        long millis = nanos / 1000000L;
                        nanos -= millis * 1000000L;
                        try {
                            Thread.sleep(millis, (int)nanos);
                            continue block4;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            this.running.set(false);
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    break;
                }
            }
            this.isDone.set(true);
            this.doneLatch.countDown();
        }
    }

    public static interface SessionModeChangeListener {
        public void onChange(SessionMode var1, SessionMode var2);
    }

    public static interface SessionModeTransition {
        public SessionMode getNextMode();

        public boolean isDone();

        default public void notifyTransitionComplete() {
        }

        public static SessionModeTransition newTransition(final BooleanSupplier doneCondition, final SessionMode nextMode) {
            return new SessionModeTransition(){

                @Override
                public boolean isDone() {
                    return doneCondition.getAsBoolean();
                }

                @Override
                public SessionMode getNextMode() {
                    return nextMode;
                }
            };
        }
    }

    private class SessionTopicListenerManager {
        private final Messager messager;
        private final TopicListener<CropBufferRequest> cropRequestListener = Session.this::submitCropBufferRequest;
        private final TopicListener<FillBufferRequest> fillRequestListener = Session.this::submitFillBufferRequest;
        private final TopicListener<Integer> currentIndexListener = Session.this::submitBufferIndexRequest;
        private final TopicListener<Integer> inPointIndexListener = Session.this::submitBufferInPointIndexRequest;
        private final TopicListener<Integer> outPointIndexListener = Session.this::submitBufferOutPointIndexRequest;
        private final TopicListener<Integer> incrementCurrentIndexListener = Session.this::submitIncrementBufferIndexRequest;
        private final TopicListener<Integer> decrementCurrentIndexListener = Session.this::submitDecrementBufferIndexRequest;
        private final TopicListener<Integer> currentBufferSizeListener = Session.this::submitBufferSizeRequest;
        private final TopicListener<Integer> initializeBufferSizeListener = Session.this::initializeBufferSize;
        private final TopicListener<SessionState> sessionCurrentStateListener = state -> {
            if (state == SessionState.ACTIVE) {
                Session.this.startSessionThread();
            } else if (state == SessionState.INACTIVE) {
                Session.this.shutdownSession();
            }
        };
        private final TopicListener<SessionMode> sessionCurrentModeListener = Session.this::setSessionMode;
        private final TopicListener<Long> sessionDTNanosecondsListener = Session.this::setSessionDTNanoseconds;
        private final TopicListener<Boolean> runAtRealTimeRateListener = Session.this::submitRunAtRealTimeRate;
        private final TopicListener<Double> playbackRealTimeRateListener = Session.this::submitPlaybackRealTimeRate;
        private final TopicListener<Integer> bufferRecordTickPeriodListener = Session.this::setBufferRecordTickPeriod;
        private final TopicListener<Integer> initializeBufferRecordTickPeriodListener = Session.this::initializeBufferRecordTickPeriod;
        private final TopicListener<SessionDataExportRequest> sessionDataExportRequestListener = Session.this::submitSessionDataExportRequest;
        private final Consumer<YoBufferPropertiesReadOnly> bufferPropertiesListener = this.createBufferPropertiesListener();
        private final Consumer<SessionProperties> sessionPropertiesListener = this.createSessionPropertiesListener();

        private SessionTopicListenerManager(Messager messager) {
            this.messager = messager;
            Session.this.addCurrentBufferPropertiesListener(this.bufferPropertiesListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CropRequest, this.cropRequestListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.FillRequest, this.fillRequestListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CurrentIndexRequest, this.currentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.InPointIndexRequest, this.inPointIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.OutPointIndexRequest, this.outPointIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.IncrementCurrentIndexRequest, this.incrementCurrentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.DecrementCurrentIndexRequest, this.decrementCurrentIndexListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.CurrentBufferSizeRequest, this.currentBufferSizeListener);
            messager.registerTopicListener(YoSharedBufferMessagerAPI.InitializeBufferSize, this.initializeBufferSizeListener);
            Session.this.addSessionPropertiesListener(this.sessionPropertiesListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionCurrentState, this.sessionCurrentStateListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionCurrentMode, this.sessionCurrentModeListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionDTNanoseconds, this.sessionDTNanosecondsListener);
            messager.registerTopicListener(SessionMessagerAPI.RunAtRealTimeRate, this.runAtRealTimeRateListener);
            messager.registerTopicListener(SessionMessagerAPI.PlaybackRealTimeRate, this.playbackRealTimeRateListener);
            messager.registerTopicListener(SessionMessagerAPI.BufferRecordTickPeriod, this.bufferRecordTickPeriodListener);
            messager.registerTopicListener(SessionMessagerAPI.InitializeBufferRecordTickPeriod, this.initializeBufferRecordTickPeriodListener);
            messager.registerTopicListener(SessionMessagerAPI.SessionDataExportRequest, this.sessionDataExportRequestListener);
        }

        private void detachFromMessager() {
            if (this.messager == null) {
                return;
            }
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CropRequest, this.cropRequestListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.FillRequest, this.fillRequestListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CurrentIndexRequest, this.currentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.InPointIndexRequest, this.inPointIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.OutPointIndexRequest, this.outPointIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.IncrementCurrentIndexRequest, this.incrementCurrentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.DecrementCurrentIndexRequest, this.decrementCurrentIndexListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.CurrentBufferSizeRequest, this.currentBufferSizeListener);
            this.messager.removeTopicListener(YoSharedBufferMessagerAPI.InitializeBufferSize, this.initializeBufferSizeListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionCurrentState, this.sessionCurrentStateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionCurrentMode, this.sessionCurrentModeListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionDTNanoseconds, this.sessionDTNanosecondsListener);
            this.messager.removeTopicListener(SessionMessagerAPI.RunAtRealTimeRate, this.runAtRealTimeRateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.PlaybackRealTimeRate, this.playbackRealTimeRateListener);
            this.messager.removeTopicListener(SessionMessagerAPI.BufferRecordTickPeriod, this.bufferRecordTickPeriodListener);
            this.messager.removeTopicListener(SessionMessagerAPI.InitializeBufferRecordTickPeriod, this.initializeBufferRecordTickPeriodListener);
            this.messager.removeTopicListener(SessionMessagerAPI.SessionDataExportRequest, this.sessionDataExportRequestListener);
        }

        private Consumer<YoBufferPropertiesReadOnly> createBufferPropertiesListener() {
            return bufferProperties -> {
                if (!this.messager.isMessagerOpen()) {
                    return;
                }
                this.messager.submitMessage(YoSharedBufferMessagerAPI.CurrentBufferProperties, bufferProperties);
            };
        }

        private Consumer<SessionProperties> createSessionPropertiesListener() {
            return sessionProperties -> {
                if (!this.messager.isMessagerOpen()) {
                    return;
                }
                this.messager.submitMessage(SessionMessagerAPI.SessionCurrentMode, (Object)sessionProperties.getActiveMode());
                this.messager.submitMessage(SessionMessagerAPI.SessionDTNanoseconds, (Object)sessionProperties.getSessionDTNanoseconds());
                this.messager.submitMessage(SessionMessagerAPI.PlaybackRealTimeRate, (Object)sessionProperties.getPlaybackRealTimeRate());
                this.messager.submitMessage(SessionMessagerAPI.RunAtRealTimeRate, (Object)sessionProperties.isRunAtRealTimeRate());
                this.messager.submitMessage(SessionMessagerAPI.BufferRecordTickPeriod, (Object)sessionProperties.getBufferRecordTickPeriod());
            };
        }
    }
}

