/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000ButtonController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000KnobController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class BCF2000SliderboardController {
    public static final String BCF2000 = "BCF2000";
    public static boolean DEBUG = true;
    private final Receiver midiOut;
    private final Transmitter midiIn;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadTools.createNamedDaemonThreadFactory((String)this.getClass().getSimpleName()));
    private ScheduledFuture<?> currentTask;
    private final BCF2000SliderController[] sliderControllers = new BCF2000SliderController[8];
    private final BCF2000ButtonController[] buttonControllers = new BCF2000ButtonController[16];
    private final BCF2000KnobController[] knobControllers = new BCF2000KnobController[8];
    private final Receiver receiver = new Receiver(){

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (!(message instanceof ShortMessage)) {
                return;
            }
            ShortMessage shortMessage = (ShortMessage)message;
            Slider slider = Slider.fromChannel(shortMessage.getData1());
            if (slider != null && BCF2000SliderboardController.this.sliderControllers[slider.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            Button button = Button.fromChannel(shortMessage.getData1());
            if (button != null && BCF2000SliderboardController.this.buttonControllers[button.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
            Knob knob = Knob.fromChannel(shortMessage.getData1());
            if (knob != null && BCF2000SliderboardController.this.knobControllers[knob.ordinal()].handleMessage(shortMessage, timeStamp)) {
                return;
            }
        }

        @Override
        public void close() {
        }
    };

    private BCF2000SliderboardController(Receiver midiOut, Transmitter midiIn) {
        this.midiOut = midiOut;
        this.midiIn = midiIn;
        midiIn.setReceiver(this.receiver);
        for (Slider slider : Slider.values()) {
            this.sliderControllers[slider.ordinal()] = new BCF2000SliderController(slider, midiOut);
        }
        for (Enum enum_ : Button.values()) {
            this.buttonControllers[enum_.ordinal()] = new BCF2000ButtonController((Button)enum_, midiOut);
        }
        for (Enum enum_ : Knob.values()) {
            this.knobControllers[enum_.ordinal()] = new BCF2000KnobController((Knob)enum_, midiOut);
        }
    }

    public SliderboardVariable getSlider(Slider slider) {
        return this.sliderControllers[slider.ordinal()].getControlVariable();
    }

    public SliderboardVariable getButton(Button button) {
        return this.buttonControllers[button.ordinal()].getControlVariable();
    }

    public SliderboardVariable getKnob(Knob knob) {
        return this.knobControllers[knob.ordinal()].getControlVariable();
    }

    public void update() {
        int i;
        for (i = 0; i < this.sliderControllers.length; ++i) {
            this.sliderControllers[i].update();
        }
        for (i = 0; i < this.buttonControllers.length; ++i) {
            this.buttonControllers[i].update();
        }
        for (i = 0; i < this.knobControllers.length; ++i) {
            this.knobControllers[i].update();
        }
    }

    public void start() {
        this.currentTask = this.executor.scheduleAtFixedRate(this::update, 0L, 20L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.currentTask != null) {
            this.currentTask.cancel(false);
        }
    }

    public void closeAndDispose() {
        this.stop();
        this.executor.shutdown();
        if (this.midiOut != null) {
            this.midiOut.close();
        }
        if (this.midiIn != null) {
            this.midiIn.close();
        }
    }

    public static boolean isBCF2000Sliderboard(MidiDevice.Info info) {
        String name = info.getName();
        String description = info.getDescription();
        return name.contains(BCF2000) || description.contains(BCF2000);
    }

    public static BCF2000SliderboardController searchAndConnectToDevice() {
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        Receiver out = null;
        Transmitter in = null;
        for (MidiDevice.Info info : infos) {
            if (out != null && in != null) break;
            if (!BCF2000SliderboardController.isBCF2000Sliderboard(info) || out == null && (out = BCF2000SliderboardController.connectToMidiOutDevice(info)) != null || in != null) continue;
            in = BCF2000SliderboardController.connectToMidiInDevice(info);
        }
        if (out != null && in != null) {
            return new BCF2000SliderboardController(out, in);
        }
        return null;
    }

    private static Transmitter connectToMidiInDevice(MidiDevice.Info info) {
        MidiDevice midiDevice = BCF2000SliderboardController.getDevice(info);
        if (midiDevice == null) {
            return null;
        }
        if (midiDevice.getMaxTransmitters() == 0 && DEBUG) {
            LogTools.error((String)("Cannot add transmitter to the device: " + midiDevice));
            return null;
        }
        if (!BCF2000SliderboardController.openDevice(midiDevice)) {
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)"Device is Now open trying to obtain the transmitter.");
        }
        Transmitter midiIn = null;
        try {
            midiIn = midiDevice.getTransmitter();
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            midiIn = null;
            if (DEBUG) {
                LogTools.error((String)"Error getting the device's transmitter.");
                e.printStackTrace();
            }
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)("Obtained a handle to the device transmitter: " + info.getName() + ", description: " + info.getDescription() + ", class name: " + midiDevice.getClass().getSimpleName()));
        }
        return midiIn;
    }

    private static Receiver connectToMidiOutDevice(MidiDevice.Info info) {
        MidiDevice midiDevice = BCF2000SliderboardController.getDevice(info);
        if (midiDevice == null) {
            return null;
        }
        if (midiDevice.getMaxReceivers() == 0 && DEBUG) {
            LogTools.error((String)("Cannot add receiver to the device: " + midiDevice));
            return null;
        }
        if (!BCF2000SliderboardController.openDevice(midiDevice)) {
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)"Device is Now open trying to obtain the receiver.");
        }
        Receiver midiOut = null;
        try {
            midiOut = midiDevice.getReceiver();
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            midiOut = null;
            if (DEBUG) {
                LogTools.error((String)"Error getting the device's receiver.");
                e.printStackTrace();
            }
            return null;
        }
        if (DEBUG) {
            LogTools.info((String)("Obtained a handle to the devices receiver: " + info.getName() + ", description: " + info.getDescription()));
        }
        return midiOut;
    }

    private static boolean openDevice(MidiDevice midiDevice) {
        if (midiDevice.isOpen()) {
            return true;
        }
        if (DEBUG) {
            LogTools.info((String)("Opening Device: " + midiDevice));
        }
        try {
            midiDevice.open();
            return true;
        }
        catch (MidiUnavailableException e) {
            midiDevice = null;
            if (DEBUG) {
                LogTools.error((String)("Unable to open device: " + midiDevice));
                e.printStackTrace();
            }
            return false;
        }
    }

    private static MidiDevice getDevice(MidiDevice.Info info) {
        MidiDevice midiDevice;
        try {
            midiDevice = MidiSystem.getMidiDevice(info);
        }
        catch (MidiUnavailableException e) {
            if (DEBUG) {
                LogTools.error((String)"Unable to get a handle to this Midi Device.");
                e.printStackTrace();
            }
            return null;
        }
        return midiDevice;
    }

    public static enum KnobButton {
        BUTTON_1,
        BUTTON_2,
        BUTTON_3,
        BUTTON_4,
        BUTTON_5,
        BUTTON_6,
        BUTTON_7,
        BUTTON_8;

        private static final int CHANNEL_OFFSET = 32;
        private final int channel = this.ordinal() + 32;

        public int getChannel() {
            return this.channel;
        }

        public static KnobButton fromChannel(int channel) {
            if (channel < 32 || channel > 39) {
                return null;
            }
            return KnobButton.values()[channel - 32];
        }
    }

    public static enum Button {
        BUTTON_1,
        BUTTON_2,
        BUTTON_3,
        BUTTON_4,
        BUTTON_5,
        BUTTON_6,
        BUTTON_7,
        BUTTON_8,
        BUTTON_9,
        BUTTON_10,
        BUTTON_11,
        BUTTON_12,
        BUTTON_13,
        BUTTON_14,
        BUTTON_15,
        BUTTON_16;

        private static final int CHANNEL_OFFSET = 65;
        private final int channel = this.ordinal() + 65;

        public int getChannel() {
            return this.channel;
        }

        public static Button fromChannel(int channel) {
            if (channel < 65 || channel > 80) {
                return null;
            }
            return Button.values()[channel - 65];
        }
    }

    public static enum Slider {
        SLIDER_1,
        SLIDER_2,
        SLIDER_3,
        SLIDER_4,
        SLIDER_5,
        SLIDER_6,
        SLIDER_7,
        SLIDER_8;

        private static final int CHANNEL_OFFSET = 81;
        private final int channel = this.ordinal() + 81;

        public int getChannel() {
            return this.channel;
        }

        public int getMin() {
            return 0;
        }

        public int getMax() {
            return 127;
        }

        public static Slider fromChannel(int channel) {
            if (channel < 81 || channel > 88) {
                return null;
            }
            return Slider.values()[channel - 81];
        }
    }

    public static enum Knob {
        KNOB_1,
        KNOB_2,
        KNOB_3,
        KNOB_4,
        KNOB_5,
        KNOB_6,
        KNOB_7,
        KNOB_8;

        private static final int CHANNEL_OFFSET = 1;
        private final int channel = this.ordinal() + 1;

        public int getChannel() {
            return this.channel;
        }

        public int getMin() {
            return 0;
        }

        public int getMax() {
            return 127;
        }

        public static Knob fromChannel(int channel) {
            if (channel < 1 || channel > 8) {
                return null;
            }
            return Knob.values()[channel - 1];
        }
    }
}

