/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.sliderboard;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public abstract class BCF2000ChannelController {
    protected final SliderboardVariable controlVariable;
    protected final Receiver midiOut;
    protected final int channel;
    private boolean enable;
    private int currentDeviceValue = -1;
    private int newDeviceValue = -1;

    public BCF2000ChannelController(SliderboardVariable controlVariable, int channel, Receiver midiOut) {
        this.controlVariable = controlVariable;
        this.channel = channel;
        this.midiOut = midiOut;
    }

    public boolean handleMessage(ShortMessage message, long timestamp) {
        if (!this.enable) {
            return false;
        }
        if (this.channel != message.getData1()) {
            return false;
        }
        this.newDeviceValue = MathTools.clamp((int)message.getData2(), (int)this.controlVariable.getMin(), (int)this.controlVariable.getMax());
        return true;
    }

    public void enable() {
        if (this.enable) {
            return;
        }
        this.enable = true;
        this.pushControlVariableToDevice();
        this.newDeviceValue = -1;
    }

    public void disable() {
        if (!this.enable) {
            return;
        }
        this.enable = false;
        this.newDeviceValue = -1;
    }

    public void update() {
        if (this.newDeviceValue != -1) {
            this.currentDeviceValue = this.newDeviceValue;
            this.controlVariable.setValue(this.currentDeviceValue);
            this.newDeviceValue = -1;
        } else if (this.controlVariable.getValue() != this.currentDeviceValue) {
            this.pushControlVariableToDevice();
        }
    }

    public void pushControlVariableToDevice() {
        this.pushValueToDevice(this.controlVariable.getValue());
    }

    public void pushValueToDevice(int value) {
        if (!this.enable || value == -1) {
            return;
        }
        this.currentDeviceValue = value;
        try {
            int msgData;
            ShortMessage message = new ShortMessage();
            if (this.controlVariable.getMax() - this.controlVariable.getMin() == 127) {
                msgData = value - this.controlVariable.getMin();
            } else if (this.controlVariable.getMax() - this.controlVariable.getMin() == 1) {
                msgData = value - this.controlVariable.getMin() == 0 ? 0 : 127;
            } else {
                int alpha = (value - this.controlVariable.getMin()) / (this.controlVariable.getMax() - this.controlVariable.getMax());
                msgData = (int)Math.round(EuclidCoreTools.interpolate((double)0.0, (double)127.0, (double)alpha));
            }
            message.setMessage(176, 0, this.channel, msgData);
            this.midiOut.send(message, -1L);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public SliderboardVariable getControlVariable() {
        return this.controlVariable;
    }
}

