/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import com.jfoenix.controls.JFXTextField;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicPolynomial3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeListEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoPolynomialFX3D;

public class YoPolynomialFX3DEditorController
extends YoGraphicFX3DEditorController<YoPolynomialFX3D> {
    @FXML
    private YoCompositeListEditorPaneController coefficientsXListEditorController;
    @FXML
    private YoCompositeListEditorPaneController coefficientsYListEditorController;
    @FXML
    private YoCompositeListEditorPaneController coefficientsZListEditorController;
    @FXML
    private JFXTextField startTimeTextField;
    @FXML
    private JFXTextField endTimeTextField;
    @FXML
    private JFXTextField sizeTextField;
    @FXML
    private ImageView startTimeValidImageView;
    @FXML
    private ImageView endTimeValidImageView;
    @FXML
    private ImageView sizeValidImageView;
    private YoGraphicPolynomial3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoPolynomialFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolynomial3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupDoublePropertyListEditor(this.coefficientsXListEditorController, "Coefficent X", "Coefficients X", yoGraphicToEdit::setNumberOfCoefficientsX, yoGraphicToEdit::setCoefficientsX);
        this.setupDoublePropertyListEditor(this.coefficientsYListEditorController, "Coefficent Y", "Coefficients Y", yoGraphicToEdit::setNumberOfCoefficientsY, yoGraphicToEdit::setCoefficientsY);
        this.setupDoublePropertyListEditor(this.coefficientsZListEditorController, "Coefficent Z", "Coefficients Z", yoGraphicToEdit::setNumberOfCoefficientsZ, yoGraphicToEdit::setCoefficientsZ);
        this.setupDoublePropertyEditor((TextField)this.startTimeTextField, this.startTimeValidImageView, YoPolynomialFX3D::setStartTime);
        this.setupDoublePropertyEditor((TextField)this.endTimeTextField, this.endTimeValidImageView, YoPolynomialFX3D::setEndTime);
        this.setupDoublePropertyEditor((TextField)this.sizeTextField, this.sizeValidImageView, YoPolynomialFX3D::setSize);
        this.coefficientsXListEditorController.setPrefHeight(4);
        this.coefficientsYListEditorController.setPrefHeight(4);
        this.coefficientsZListEditorController.setPrefHeight(4);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicPolynomial3DDefinition((YoPolynomialFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.coefficientsXListEditorController.setInputSingletonComposites(this.definitionBeforeEdits.getCoefficientsX());
        this.coefficientsYListEditorController.setInputSingletonComposites(this.definitionBeforeEdits.getCoefficientsY());
        this.coefficientsZListEditorController.setInputSingletonComposites(this.definitionBeforeEdits.getCoefficientsZ());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.startTimeTextField.setText(this.definitionBeforeEdits.getStartTime());
        this.endTimeTextField.setText(this.definitionBeforeEdits.getEndTime());
        this.sizeTextField.setText(this.definitionBeforeEdits.getSize());
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoPolynomialFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicPolynomial3DDefinition((YoPolynomialFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

