/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableDatabase;
import us.ihmc.scs2.sharedMemory.LinkedBufferProperties;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoEnum;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.sharedMemory.interfaces.LinkedYoVariableFactory;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoManager
extends ObservedAnimationTimer
implements Manager {
    private final LongProperty rootRegistryChangeCounter = new SimpleLongProperty((Object)this, "rootRegistryChangeCounter", 0L);
    private final YoRegistryChangedListener counterUpdater = changer -> this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
    private YoRegistry rootRegistry;
    private LinkedYoRegistry linkedRootRegistry;
    private LinkedBufferProperties linkedBufferProperties;
    private LinkedYoVariableFactory linkedYoVariableFactory;
    private boolean updatingYoVariables = true;
    private YoVariableDatabase rootRegistryDatabase = null;

    @Override
    public void handleImpl(long now) {
        if (this.linkedRootRegistry != null && !this.updatingYoVariables) {
            this.linkedRootRegistry.pull();
        }
    }

    @Override
    public void startSession(Session session) {
        LogTools.info((String)"Linking YoVariables");
        this.rootRegistry = new YoRegistry("root");
        this.linkedYoVariableFactory = session.getLinkedYoVariableFactory();
        this.linkedRootRegistry = this.linkedYoVariableFactory.newLinkedYoRegistry(this.rootRegistry);
        this.linkedBufferProperties = this.linkedYoVariableFactory.newLinkedBufferProperties();
        this.updatingYoVariables = true;
        this.rootRegistry.addListener(this.counterUpdater);
        this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
        this.rootRegistryDatabase = new YoVariableDatabase(this.rootRegistry, this.linkedRootRegistry);
        this.updatingYoVariables = false;
        LogTools.info((String)"UI linked YoVariables created");
        this.start();
    }

    @Override
    public void stopSession() {
        this.rootRegistryDatabase.dispose();
        this.rootRegistryDatabase = null;
        this.linkedYoVariableFactory = null;
        this.linkedRootRegistry = null;
        this.linkedBufferProperties = null;
        this.rootRegistry.removeListener(this.counterUpdater);
        this.rootRegistry.clear();
        this.rootRegistry = null;
        this.rootRegistryChangeCounter.set(this.rootRegistryChangeCounter.get() + 1L);
    }

    @Override
    public boolean isSessionLoaded() {
        return this.linkedRootRegistry != null && !this.updatingYoVariables;
    }

    public LinkedYoRegistry newLinkedYoRegistry(YoRegistry registry) {
        return this.linkedYoVariableFactory.newLinkedYoRegistry(registry);
    }

    public LinkedYoVariable<?> newLinkedYoVariable(YoVariable yoVariable) {
        return this.linkedYoVariableFactory.newLinkedYoVariable(yoVariable);
    }

    public YoRegistry getRootRegistry() {
        return this.rootRegistry;
    }

    public YoVariableDatabase getRootRegistryDatabase() {
        return this.rootRegistryDatabase;
    }

    public boolean isUpdatingYoVariables() {
        return this.updatingYoVariables;
    }

    public LinkedYoRegistry getLinkedRootRegistry() {
        return this.linkedRootRegistry;
    }

    public LinkedBufferProperties newLinkedBufferProperties() {
        if (this.linkedYoVariableFactory == null) {
            return null;
        }
        return this.linkedYoVariableFactory.newLinkedBufferProperties();
    }

    public LongProperty rootRegistryChangeCounter() {
        return this.rootRegistryChangeCounter;
    }

    public int getBufferSize() {
        if (this.linkedBufferProperties == null) {
            return -1;
        }
        if (this.linkedBufferProperties.peekCurrentBufferProperties() == null) {
            return -1;
        }
        return this.linkedBufferProperties.peekCurrentBufferProperties().getSize();
    }

    public YoDoubleProperty newYoDoubleProperty(String variableName) {
        if (this.rootRegistry == null) {
            LogTools.error((String)"No active session.");
            return null;
        }
        YoDouble variable = this.findYoVariable(YoDouble.class, variableName);
        if (variable == null) {
            LogTools.error((String)"Could not find variable from name: {}", (Object)variableName);
            return null;
        }
        YoDoubleProperty property = new YoDoubleProperty(variable);
        property.setLinkedBuffer((LinkedYoDouble)this.linkedRootRegistry.linkYoVariable((YoVariable)variable));
        return property;
    }

    public YoIntegerProperty newYoIntegerProperty(String variableName) {
        if (this.rootRegistry == null) {
            LogTools.error((String)"No active session.");
            return null;
        }
        YoInteger variable = this.findYoVariable(YoInteger.class, variableName);
        if (variable == null) {
            LogTools.error((String)"Could not find variable from name: {}", (Object)variableName);
            return null;
        }
        YoIntegerProperty property = new YoIntegerProperty(variable);
        property.setLinkedBuffer((LinkedYoInteger)this.linkedRootRegistry.linkYoVariable((YoVariable)variable));
        return property;
    }

    public YoLongProperty newYoLongProperty(String variableName) {
        if (this.rootRegistry == null) {
            LogTools.error((String)"No active session.");
            return null;
        }
        YoLong variable = this.findYoVariable(YoLong.class, variableName);
        if (variable == null) {
            LogTools.error((String)"Could not find variable from name: {}", (Object)variableName);
            return null;
        }
        YoLongProperty property = new YoLongProperty(variable);
        property.setLinkedBuffer((LinkedYoLong)this.linkedRootRegistry.linkYoVariable((YoVariable)variable));
        return property;
    }

    public YoBooleanProperty newYoBooleanProperty(String variableName) {
        if (this.rootRegistry == null) {
            LogTools.error((String)"No active session.");
            return null;
        }
        YoBoolean variable = this.findYoVariable(YoBoolean.class, variableName);
        if (variable == null) {
            LogTools.error((String)"Could not find variable from name: {}", (Object)variableName);
            return null;
        }
        YoBooleanProperty property = new YoBooleanProperty(variable);
        property.setLinkedBuffer((LinkedYoBoolean)this.linkedRootRegistry.linkYoVariable((YoVariable)variable));
        return property;
    }

    public <E extends Enum<E>> YoEnumAsStringProperty<E> newYoEnumProperty(String variableName) {
        if (this.rootRegistry == null) {
            LogTools.error((String)"No active session.");
            return null;
        }
        YoEnum variable = this.findYoVariable(YoEnum.class, variableName);
        if (variable == null) {
            LogTools.error((String)"Could not find variable from name: {}", (Object)variableName);
            return null;
        }
        YoEnumAsStringProperty property = new YoEnumAsStringProperty(variable);
        property.setLinkedBuffer((LinkedYoEnum)this.linkedRootRegistry.linkYoVariable((YoVariable)variable));
        return property;
    }

    private <T extends YoVariable> T findYoVariable(Class<T> type, String variableName) {
        int separatorIndex = variableName.lastIndexOf(YoTools.NAMESPACE_SEPERATOR_STRING);
        String namespaceEnding = separatorIndex == -1 ? null : variableName.substring(0, separatorIndex);
        String name = separatorIndex == -1 ? variableName : variableName.substring(separatorIndex + 1);
        return (T)YoSearchTools.findFirstVariable((String)namespaceEnding, (String)name, type::isInstance, (YoRegistry)this.rootRegistry);
    }
}

