/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoInteger;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoIntegerSlider
implements YoVariableSlider {
    private final YoIntegerProperty yoIntegerProperty;
    private final IntegerProperty minProperty = new SimpleIntegerProperty((Object)this, "min", 0);
    private final IntegerProperty maxProperty = new SimpleIntegerProperty((Object)this, "max", 1);
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public YoIntegerSlider(YoInteger yoInteger, LinkedYoRegistry linkedYoRegistry) {
        this.yoIntegerProperty = new YoIntegerProperty(yoInteger, this);
        this.yoIntegerProperty.setLinkedBuffer((LinkedYoInteger)linkedYoRegistry.linkYoVariable((YoVariable)yoInteger));
    }

    @Override
    public void bindMinTextField(JFXTextField minTextField) {
        TextFormatter minTextFormatter = new TextFormatter((StringConverter)new IntegerStringConverter());
        minTextFormatter.setValue((Object)(this.yoIntegerProperty.get() - 1));
        minTextField.setTextFormatter(minTextFormatter);
        this.minProperty.bind((ObservableValue)minTextFormatter.valueProperty());
        minTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.minProperty.unbind();
            minTextField.setDisable(true);
        });
    }

    @Override
    public void bindMaxTextField(JFXTextField maxTextField) {
        TextFormatter maxTextFormatter = new TextFormatter((StringConverter)new IntegerStringConverter());
        maxTextFormatter.setValue((Object)(this.yoIntegerProperty.get() + 1));
        maxTextField.setTextFormatter(maxTextFormatter);
        this.maxProperty.bind((ObservableValue)maxTextFormatter.valueProperty());
        maxTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.maxProperty.unbind();
            maxTextField.setDisable(true);
        });
    }

    @Override
    public void bindVirtualSlider(Slider virtualSlider) {
        virtualSlider.minProperty().bind((ObservableValue)this.minProperty);
        virtualSlider.maxProperty().bind((ObservableValue)this.maxProperty);
        ChangeListener majorTickUnitUpdater = (o, oldValue, newValue) -> {
            double range = this.maxProperty.get() - this.minProperty.get();
            if (range <= 0.0) {
                return;
            }
            virtualSlider.setMajorTickUnit((double)Math.max(1L, Math.round(range / 25.0)));
        };
        this.minProperty.addListener(majorTickUnitUpdater);
        this.maxProperty.addListener(majorTickUnitUpdater);
        MutableBoolean updating = new MutableBoolean(false);
        virtualSlider.setValue((double)this.yoIntegerProperty.get());
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            virtualSlider.valueProperty().set((double)this.yoIntegerProperty.get());
            updating.setFalse();
        };
        ChangeListener yoIntegerUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoIntegerProperty.set(virtualSlider.valueProperty().getValue().intValue());
                updating.setFalse();
            });
        };
        this.yoIntegerProperty.addListener(sliderUpdater);
        virtualSlider.valueProperty().addListener(yoIntegerUpdater);
        this.cleanupTasks.add(() -> {
            this.yoIntegerProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(majorTickUnitUpdater);
            this.maxProperty.removeListener(majorTickUnitUpdater);
            virtualSlider.valueProperty().removeListener(yoIntegerUpdater);
            virtualSlider.minProperty().unbind();
            virtualSlider.maxProperty().unbind();
        });
    }

    @Override
    public void bindVirtualKnob(JFXSpinner virtualKnob) {
        ChangeListener knobUpdater = (o, oldValue, newValue) -> {
            double value = (this.yoIntegerProperty.doubleValue() - this.minProperty.doubleValue()) / (this.maxProperty.doubleValue() - this.minProperty.doubleValue());
            virtualKnob.setProgress(value);
        };
        knobUpdater.changed(null, null, null);
        this.yoIntegerProperty.addListener(knobUpdater);
        this.minProperty.addListener(knobUpdater);
        this.maxProperty.addListener(knobUpdater);
        this.cleanupTasks.add(() -> {
            this.yoIntegerProperty.removeListener(knobUpdater);
            this.minProperty.removeListener(knobUpdater);
            this.maxProperty.removeListener(knobUpdater);
        });
    }

    @Override
    public void bindSliderVariable(SliderboardVariable sliderVariable) {
        MutableBoolean updating = new MutableBoolean(false);
        if (!this.minProperty.isBound()) {
            this.minProperty.set(this.yoIntegerProperty.get() - 1);
        }
        if (!this.maxProperty.isBound()) {
            this.maxProperty.set(this.yoIntegerProperty.get() + 1);
        }
        sliderVariable.setValue(SliderboardVariable.doubleToInt((double)this.yoIntegerProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax()));
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int sliderPosition = SliderboardVariable.doubleToInt((double)this.yoIntegerProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            updating.setTrue();
            sliderVariable.setValue(sliderPosition);
            updating.setFalse();
        };
        ChangeListener yoIntegerUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int yoIntegerValue = SliderboardVariable.doubleToInt((double)newValue.intValue(), (double)sliderVariable.getMin(), (double)sliderVariable.getMax(), (int)this.minProperty.get(), (int)this.maxProperty.get());
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoIntegerProperty.set(yoIntegerValue);
                updating.setFalse();
            });
        };
        this.yoIntegerProperty.addListener(sliderUpdater);
        this.minProperty.addListener(sliderUpdater);
        this.maxProperty.addListener(sliderUpdater);
        sliderVariable.valueProperty().addListener(yoIntegerUpdater);
        this.cleanupTasks.add(() -> {
            this.yoIntegerProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(sliderUpdater);
            this.maxProperty.removeListener(sliderUpdater);
            sliderVariable.valueProperty().removeListener(yoIntegerUpdater);
        });
    }

    public YoInteger getYoVariable() {
        return this.yoIntegerProperty.getYoVariable();
    }

    @Override
    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = new YoSliderDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = new YoKnobDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public void dispose() {
        this.yoIntegerProperty.dispose();
        this.cleanupTasks.forEach(Runnable::run);
    }
}

