/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.scs2.definition.DefinitionIOTools;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoEntry.YoEntryListDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.CameraObjectTrackingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.MainWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MultiSessionManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MultiViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.Plotter2D;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoBooleanProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoEnumAsStringProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoIntegerProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXApplicationCreator;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class SessionVisualizer {
    public static final String NO_ACTIVE_SESSION_TITLE = "No Active Session";
    private final boolean shutdownSessionOnClose;
    private final SessionVisualizerToolkit toolkit;
    private final MultiSessionManager multiSessionManager;
    private final Group view3DRoot;
    private final Plotter2D plotter2D = new Plotter2D();
    private final MainWindowController mainWindowController;
    private final MultiViewport3DManager viewport3DManager;
    private final BufferedJavaFXMessager messager;
    private final SessionVisualizerTopics topics;
    private final SessionVisualizerControlsImpl sessionVisualizerControls = new SessionVisualizerControlsImpl();
    private final List<Runnable> stopListeners = new ArrayList<Runnable>();
    private final Stage primaryStage;
    private boolean hasTerminated = false;

    public SessionVisualizer(Stage primaryStage, boolean shutdownSessionOnClose) throws Exception {
        this.primaryStage = primaryStage;
        this.shutdownSessionOnClose = shutdownSessionOnClose;
        primaryStage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, this::stop);
        SessionVisualizerIOTools.addSCSIconToWindow((Window)primaryStage);
        primaryStage.setTitle(NO_ACTIVE_SESSION_TITLE);
        Scene3DBuilder scene3DBuilder = new Scene3DBuilder();
        scene3DBuilder.addDefaultLighting();
        this.view3DRoot = scene3DBuilder.getRoot();
        this.viewport3DManager = new MultiViewport3DManager(this.view3DRoot);
        this.viewport3DManager.createMainViewport();
        this.toolkit = new SessionVisualizerToolkit(primaryStage, this.viewport3DManager.getMainViewport().getSubScene(), this.view3DRoot);
        this.messager = this.toolkit.getMessager();
        this.topics = this.toolkit.getTopics();
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.MAIN_WINDOW_URL);
        Parent mainPane = (Parent)loader.load();
        this.mainWindowController = (MainWindowController)loader.getController();
        this.mainWindowController.initialize(new SessionVisualizerWindowToolkit(primaryStage, this.toolkit));
        scene3DBuilder.addNodeToView((Node)this.toolkit.getYoRobotFXManager().getRootNode());
        scene3DBuilder.addNodeToView((Node)this.toolkit.getEnvironmentManager().getRootNode());
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getCameraTrackObject(), request -> {
            if (request.getNode() != null) {
                this.viewport3DManager.getMainViewport().setCameraNodeToTrack(request.getNode());
            }
        });
        this.toolkit.getEnvironmentManager().addWorldCoordinateSystem(0.3);
        this.toolkit.getEnvironmentManager().addSkybox((Camera)this.viewport3DManager.getMainViewport().getCamera());
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getSessionVisualizerCloseRequest(), m -> this.stop());
        this.mainWindowController.setupPlotter2D(this.plotter2D);
        scene3DBuilder.addNodeToView(this.toolkit.getYoGraphicFXManager().getRootNode3D());
        this.mainWindowController.setupViewport3D(this.viewport3DManager.getPane());
        Group clonedLightGroup = new Group();
        Scene3DBuilder.setupLigthCloneList((ObservableList<? super LightBase>)clonedLightGroup.getChildren(), scene3DBuilder.getAllLights());
        StackPane mainPaneWithLights = new StackPane(new Node[]{mainPane});
        mainPaneWithLights.getChildren().add((Object)clonedLightGroup);
        mainPaneWithLights.getStylesheets().setAll((Collection)mainPane.getStylesheets());
        Scene mainScene = new Scene((Parent)mainPaneWithLights);
        this.toolkit.getSnapshotManager().registerRecordable(mainScene);
        primaryStage.setScene(mainScene);
        this.multiSessionManager = new MultiSessionManager(this.toolkit, this.mainWindowController);
        this.mainWindowController.start();
        this.toolkit.start();
        this.initializeStageWithPrimaryScreen();
        primaryStage.show();
        this.initializeStageWithPrimaryScreen();
    }

    public void initializeStageWithPrimaryScreen() {
        SessionVisualizer.initializeStageWithScreen(0.75, Screen.getPrimary(), this.primaryStage);
    }

    public static void initializeStageWithScreen(double sizeRatio, Screen screen, Stage stage) {
        Rectangle2D bounds = screen.getVisualBounds();
        double width = sizeRatio * bounds.getWidth();
        double height = sizeRatio * bounds.getHeight();
        stage.setWidth(width);
        stage.setHeight(height);
        double centerX = bounds.getMinX() + (bounds.getWidth() - width) * 0.5;
        double centerY = bounds.getMinY() + (bounds.getHeight() - height) * 1.0 / 3.0;
        stage.setX(centerX);
        stage.setY(centerY);
    }

    public void startSession(Session session) {
        Runnable sessionLoadedCallback = () -> this.sessionVisualizerControls.visualizerReadyLatch.countDown();
        this.multiSessionManager.startSession(session, sessionLoadedCallback);
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(WindowEvent event) {
        boolean saveConfiguration = false;
        if (this.toolkit.hasActiveSession()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to save the default configuration?", new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
            SessionVisualizerIOTools.addSCSIconToDialog(alert);
            alert.initOwner((Window)this.primaryStage);
            JavaFXMissingTools.centerDialogInOwner(alert);
            alert.setOnShown(e -> JavaFXMissingTools.runLater(this.getClass(), () -> JavaFXMissingTools.centerDialogInOwner(alert)));
            Optional result = alert.showAndWait();
            if (!result.isPresent() || result.get() == ButtonType.CANCEL) {
                if (event != null) {
                    event.consume();
                }
                return;
            }
            saveConfiguration = result.get() == ButtonType.YES;
        }
        this.stopNow(saveConfiguration);
    }

    private void stopNow(boolean saveConfiguration) {
        if (this.hasTerminated) {
            return;
        }
        this.hasTerminated = true;
        try {
            this.viewport3DManager.dispose();
            this.multiSessionManager.stopSession(saveConfiguration, this.shutdownSessionOnClose);
            this.multiSessionManager.shutdown();
            this.mainWindowController.stop();
            this.toolkit.stop();
            if (this.primaryStage.isShowing()) {
                this.primaryStage.close();
            }
            this.primaryStage.setScene(null);
            this.view3DRoot.getChildren().clear();
            this.stopListeners.forEach(Runnable::run);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sessionVisualizerControls.visualizerShutdownLatch.countDown();
        }
    }

    public AnchorPane getSceneAnchorPane() {
        return this.mainWindowController.getSceneAnchorPane();
    }

    public SessionVisualizerToolkit getToolkit() {
        return this.toolkit;
    }

    public static void main(String[] args) {
        SessionVisualizerControls controls = SessionVisualizer.startSessionVisualizer(null, true);
        controls.addVisualizerShutdownListener(() -> System.exit(0));
    }

    public static SessionVisualizerControls startSessionVisualizer() {
        return SessionVisualizer.startSessionVisualizer(null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session) {
        return SessionVisualizer.startSessionVisualizer(session, null);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session, Boolean javaFXThreadImplicitExit) {
        return SessionVisualizer.startSessionVisualizer(session, javaFXThreadImplicitExit, true);
    }

    public static SessionVisualizerControls startSessionVisualizer(Session session, Boolean javaFXThreadImplicitExit, boolean shutdownSessionOnClose) {
        SessionVisualizer sessionVisualizer = SessionVisualizer.startSessionVisualizerExpert(session, javaFXThreadImplicitExit, shutdownSessionOnClose);
        if (sessionVisualizer != null) {
            return sessionVisualizer.getSessionVisualizerControls();
        }
        return null;
    }

    public static SessionVisualizer startSessionVisualizerExpert(Session session, Boolean javaFXThreadImplicitExit) {
        return SessionVisualizer.startSessionVisualizerExpert(session, javaFXThreadImplicitExit, true);
    }

    public static SessionVisualizer startSessionVisualizerExpert(Session session, Boolean javaFXThreadImplicitExit, boolean shutdownSessionOnClose) {
        JavaFXApplicationCreator.spawnJavaFXMainApplication();
        return JavaFXMissingTools.runAndWait(SessionVisualizer.class, () -> {
            try {
                SessionVisualizer sessionVisualizer = new SessionVisualizer(new Stage(), shutdownSessionOnClose);
                if (session != null) {
                    sessionVisualizer.startSession(session);
                }
                JavaFXApplicationCreator.attachStopListener(sessionVisualizer::stop);
                if (javaFXThreadImplicitExit != null && Platform.isImplicitExit() != javaFXThreadImplicitExit) {
                    Platform.setImplicitExit((boolean)javaFXThreadImplicitExit);
                }
                return sessionVisualizer;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public SessionVisualizerControls getSessionVisualizerControls() {
        return this.sessionVisualizerControls;
    }

    static {
        DefinitionIOTools.loadResources();
        YoGraphicFXControllerTools.loadResources();
    }

    private class SessionVisualizerControlsImpl
    implements SessionVisualizerControls {
        private final CountDownLatch visualizerReadyLatch = new CountDownLatch(1);
        private final CountDownLatch visualizerShutdownLatch = new CountDownLatch(1);

        @Override
        public void waitUntilVisualizerFullyUp() {
            try {
                this.visualizerReadyLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void waitUntilVisualizerDown() {
            try {
                this.visualizerShutdownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setCameraOrientation(double latitude, double longitude) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.viewport3DManager.getMainViewport().setCameraOrientation(latitude, longitude, 0.0);
        }

        @Override
        public void setCameraPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.viewport3DManager.getMainViewport().setCameraPosition(x, y, z);
        }

        @Override
        public void setCameraFocusPosition(double x, double y, double z) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.viewport3DManager.getMainViewport().setCameraFocusPosition(x, y, z);
        }

        @Override
        public void setCameraZoom(double distanceFromFocus) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.viewport3DManager.getMainViewport().setCameraZoom(distanceFromFocus);
        }

        @Override
        public void requestCameraRigidBodyTracking(String robotName, String rigidBodyName) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getCameraTrackObject(), new CameraObjectTrackingRequest(robotName, rigidBodyName));
        }

        @Override
        public void showOverheadPlotter2D(boolean show) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            this.submitMessage(this.getTopics().getShowOverheadPlotter(), true);
        }

        @Override
        public void addStaticVisual(VisualDefinition visualDefinition) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getEnvironmentManager().addStaticVisual(visualDefinition);
        }

        @Override
        public void removeStaticVisual(VisualDefinition visualDefinition) {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            SessionVisualizer.this.toolkit.getEnvironmentManager().removeStaticVisual(visualDefinition);
        }

        @Override
        public void addYoGraphic(YoGraphicDefinition yoGraphicDefinition) {
            this.submitMessage(this.getTopics().getAddYoGraphicRequest(), yoGraphicDefinition);
        }

        @Override
        public void addYoEntry(String groupName, Collection<String> variableNames) {
            this.submitMessage(this.getTopics().getYoEntryListAdd(), YoEntryListDefinition.newYoVariableEntryList((String)groupName, variableNames));
        }

        @Override
        public void exportVideo(SceneVideoRecordingRequest request) {
            this.checkVisualizerRunning();
            this.checkSessionThreadRunning();
            CountDownLatch latch = new CountDownLatch(1);
            Runnable callback = request.getRecordingEndedCallback();
            request.setRecordingEndedCallback(() -> {
                latch.countDown();
                if (callback != null) {
                    callback.run();
                }
            });
            SessionVisualizer.this.messager.submitMessage(SessionVisualizer.this.topics.getSceneVideoRecordingRequest(), request);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void disableGUIControls() {
            this.submitMessage(this.getTopics().getDisableUserControls(), true);
        }

        @Override
        public void enableGUIControls() {
            this.submitMessage(this.getTopics().getDisableUserControls(), false);
        }

        SessionVisualizerTopics getTopics() {
            return SessionVisualizer.this.topics;
        }

        <T> void submitMessage(MessagerAPIFactory.Topic<T> topic, T messageContent) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.messager.submitMessage(topic, messageContent);
        }

        @Override
        public Window getPrimaryGUIWindow() {
            this.checkVisualizerRunning();
            this.waitUntilVisualizerFullyUp();
            return SessionVisualizer.this.primaryStage;
        }

        @Override
        public void addCustomGUIControl(Node control) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().addControl(control);
        }

        @Override
        public boolean removeCustomGUIControl(Node control) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.mainWindowController.getUserSidePaneController().removeControl(control);
        }

        @Override
        public void loadCustomGUIPane(String name, URL fxmlResource) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().loadCustomPane(name, fxmlResource);
        }

        @Override
        public void addCustomGUIPane(String name, Pane pane) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.mainWindowController.getUserSidePaneController().addCustomPane(name, pane);
        }

        @Override
        public boolean removeCustomGUIPane(String name) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.mainWindowController.getUserSidePaneController().removeCustomPane(name);
        }

        @Override
        public YoDoubleProperty newYoDoubleProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoDoubleProperty(variableName);
        }

        @Override
        public YoIntegerProperty newYoIntegerProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoIntegerProperty(variableName);
        }

        @Override
        public YoBooleanProperty newYoBooleanProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoBooleanProperty(variableName);
        }

        @Override
        public YoLongProperty newYoLongProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoLongProperty(variableName);
        }

        @Override
        public <E extends Enum<E>> YoEnumAsStringProperty<E> newYoEnumProperty(String variableName) {
            this.checkVisualizerRunning();
            return SessionVisualizer.this.toolkit.getYoManager().newYoEnumProperty(variableName);
        }

        @Override
        public void addSessionChangedListener(SessionChangeListener listener) {
            SessionVisualizer.this.toolkit.addSessionChangedListener(listener);
        }

        @Override
        public boolean removeSessionChangedListener(SessionChangeListener listener) {
            return SessionVisualizer.this.toolkit.removeSessionChangedListener(listener);
        }

        @Override
        public void requestVisualizerShutdown() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stop());
        }

        @Override
        public void shutdownSession() {
            JavaFXMissingTools.runAndWait(this.getClass(), () -> SessionVisualizer.this.stopNow(false));
        }

        @Override
        public void addVisualizerShutdownListener(Runnable listener) {
            this.checkVisualizerRunning();
            SessionVisualizer.this.stopListeners.add(listener);
        }

        @Override
        public boolean isVisualizerShutdown() {
            return SessionVisualizer.this.hasTerminated;
        }

        private void checkVisualizerRunning() {
            if (SessionVisualizer.this.hasTerminated) {
                throw new IllegalOperationException("Unable to perform operation, visualizer has terminated.");
            }
        }

        private void checkSessionThreadRunning() {
            if (SessionVisualizer.this.toolkit.getSession() == null) {
                throw new IllegalOperationException("No active session.");
            }
            if (!SessionVisualizer.this.toolkit.getSession().hasSessionStarted()) {
                throw new IllegalOperationException("Session thread is not running.");
            }
        }
    }
}

