/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.plotter;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.plotter.PlotterGrid2D;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXToEuclidConversions;

public class Plotter2D
extends Region {
    private final Group root = new Group();
    private final PlotterGrid2D grid2D = new PlotterGrid2D((ReadOnlyObjectProperty<Transform>)this.root.localToSceneTransformProperty());
    private final Translate rootTranslation = new Translate();
    private final ObjectProperty<MouseButton> mouseButtonForTranslation = new SimpleObjectProperty((Object)this, "mouseButtonForTranslation", (Object)MouseButton.PRIMARY);
    private final Scale rootScale = new Scale(1.0, -1.0);
    private final DoubleProperty scaleModifier = new SimpleDoubleProperty((Object)this, "scaleModifier", -0.0025);
    private final DoubleProperty minScale = new SimpleDoubleProperty((Object)this, "minScale", 0.01);
    private final Point2D center = new Point2D();

    public Plotter2D() {
        this.getChildren().add((Object)this.grid2D.getRoot());
        this.getChildren().add((Object)this.root);
        this.root.getTransforms().addAll((Object[])new Transform[]{this.rootTranslation, this.rootScale});
        this.addEventHandler(MouseEvent.ANY, this.createTranslationEventHandler());
        this.addEventHandler(ScrollEvent.ANY, this.createScaleEventHandler());
        this.requestParentLayout();
        this.setManaged(false);
    }

    public void setScale(double scale) {
        this.rootScale.setX(scale);
        this.rootScale.setY(-scale);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY) {
        this.setFieldOfView(centerX, centerY, rangeX, rangeY, true);
    }

    public void setFieldOfView(double centerX, double centerY, double rangeX, double rangeY, boolean axisEquals) {
        double top = this.snappedTopInset();
        double left = this.snappedLeftInset();
        double bottom = this.snappedBottomInset();
        double right = this.snappedRightInset();
        double contentWidth = this.getWidth() - (left + right);
        double contentHeight = this.getHeight() - (top + bottom);
        double scaleX = contentWidth / rangeX;
        double scaleY = contentHeight / rangeY;
        if (axisEquals) {
            double scale;
            scaleX = scale = Math.min(scaleX, scaleY);
            scaleY = scale;
        }
        this.rootScale.setX(scaleX);
        this.rootScale.setY(-scaleY);
        this.rootTranslation.setX(0.5 * contentWidth - centerX * this.rootScale.getX());
        this.rootTranslation.setY(0.5 * contentHeight - centerY * this.rootScale.getY());
    }

    public EventHandler<MouseEvent> createTranslationEventHandler() {
        return new EventHandler<MouseEvent>(){
            Point2D oldMouseLocation;

            public void handle(MouseEvent event) {
                if (event.getButton() != Plotter2D.this.mouseButtonForTranslation.get()) {
                    return;
                }
                if (event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation = new Point2D(event.getX(), event.getY());
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D newMouseLocation = new Point2D(event.getX(), event.getY());
                if (this.oldMouseLocation != null) {
                    Vector2D drag = new Vector2D();
                    drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                    JavaFXMissingTools.addEquals(Plotter2D.this.rootTranslation, (Tuple2DReadOnly)drag);
                    Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                    Plotter2D.this.updateGrid();
                }
                this.oldMouseLocation = newMouseLocation;
            }
        };
    }

    public EventHandler<ScrollEvent> createScaleEventHandler() {
        return new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double verticalDrag = event.getDeltaY();
                double oldScale = Plotter2D.this.rootScale.getX();
                double newScale = oldScale * (1.0 - Plotter2D.this.scaleModifier.get() * verticalDrag);
                newScale = Math.max(Plotter2D.this.minScale.get(), newScale);
                javafx.geometry.Point2D preScaleLocation = Plotter2D.this.root.sceneToLocal(event.getX(), event.getY());
                Plotter2D.this.rootScale.setX(newScale);
                Plotter2D.this.rootScale.setY(-newScale);
                javafx.geometry.Point2D postScaleLocation = Plotter2D.this.root.sceneToLocal(event.getX(), event.getY());
                Plotter2D.this.rootTranslation.setX(Plotter2D.this.rootTranslation.getX() + Plotter2D.this.rootScale.getX() * (postScaleLocation.getX() - preScaleLocation.getX()));
                Plotter2D.this.rootTranslation.setY(Plotter2D.this.rootTranslation.getY() + Plotter2D.this.rootScale.getY() * (postScaleLocation.getY() - preScaleLocation.getY()));
                Plotter2D.this.center.set(Plotter2D.this.computeCenterLocal());
                Plotter2D.this.updateGrid();
            }
        };
    }

    private Point2D computeCenterLocal() {
        double top = this.snappedTopInset();
        double left = this.snappedLeftInset();
        double bottom = this.snappedBottomInset();
        double right = this.snappedRightInset();
        double contentWidth = this.getWidth() - (left + right);
        double contentHeight = this.getHeight() - (top + bottom);
        Point2D newCenter = JavaFXToEuclidConversions.convertPoint2D(this.root.sceneToLocal(0.5 * contentWidth, 0.5 * contentHeight));
        return newCenter;
    }

    public void updateGrid() {
        double top = this.snappedTopInset();
        double left = this.snappedLeftInset();
        double bottom = this.snappedBottomInset();
        double right = this.snappedRightInset();
        double contentWidth = this.getWidth() - (left + right);
        double contentHeight = this.getHeight() - (top + bottom);
        this.grid2D.update(top, left, contentWidth, contentHeight);
    }

    protected void layoutChildren() {
        this.recenter();
        this.updateGrid();
    }

    private void recenter() {
        Vector2D translation = new Vector2D();
        translation.sub((Tuple2DReadOnly)this.computeCenterLocal(), (Tuple2DReadOnly)this.center);
        translation.scale(this.rootScale.getX(), this.rootScale.getY());
        JavaFXMissingTools.addEquals(this.rootTranslation, (Tuple2DReadOnly)translation);
    }

    public ObjectProperty<MouseButton> mouseButtonForTranslationProperty() {
        return this.mouseButtonForTranslation;
    }

    public Group getRoot() {
        return this.root;
    }

    public PlotterGrid2D getGrid2D() {
        return this.grid2D;
    }
}

