/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import com.jfoenix.controls.JFXTextField;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabPaneTools {
    public static Label editableTabHeader(Tab tab) {
        Label headerLabel = new Label();
        JFXTextField headerEditor = new JFXTextField();
        headerLabel.setText(tab.getText());
        tab.setGraphic((Node)headerLabel);
        tab.setText(null);
        headerLabel.setOnMouseClicked(e -> {
            if (e.getClickCount() != 2) {
                return;
            }
            headerEditor.setText(headerLabel.getText());
            headerEditor.setPrefWidth(2.0 * headerLabel.getWidth());
            tab.setGraphic((Node)headerEditor);
            headerEditor.selectAll();
            headerEditor.requestFocus();
        });
        headerEditor.setOnAction(e -> {
            headerLabel.setText(headerEditor.getText());
            tab.setGraphic((Node)headerLabel);
        });
        headerEditor.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                return;
            }
            headerLabel.setText(headerEditor.getText());
            tab.setGraphic((Node)headerLabel);
        });
        return headerLabel;
    }

    public static Function<TabPane, MenuItem> removeMenuItemFactory() {
        return tabPane -> {
            FontAwesomeIconView removeIcon = new FontAwesomeIconView();
            removeIcon.getStyleClass().add((Object)"remove-icon-view");
            MenuItem removeMenuItem = new MenuItem("Remove", (Node)removeIcon);
            Tab selectedItem = (Tab)tabPane.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            removeMenuItem.setOnAction(e2 -> tabPane.getTabs().remove((Object)selectedItem));
            return removeMenuItem;
        };
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory() {
        return TabPaneTools.removeAllMenuItemFactory(false);
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory(boolean removeOnlyClosableTabs) {
        return TabPaneTools.removeAllMenuItemFactory("Remove all", removeOnlyClosableTabs);
    }

    public static Function<TabPane, MenuItem> removeAllMenuItemFactory(String text, boolean removeOnlyClosableTabs) {
        return tabPane -> {
            FontAwesomeIconView removeAllIcon = new FontAwesomeIconView();
            removeAllIcon.getStyleClass().add((Object)"remove-icon-view");
            MenuItem removeMenuItem = new MenuItem(text, (Node)removeAllIcon);
            if (tabPane.getTabs().isEmpty()) {
                return null;
            }
            Object tabsToclose = removeOnlyClosableTabs ? tabPane.getTabs().stream().filter(Tab::isClosable).collect(Collectors.toList()) : tabPane.getTabs();
            if (tabsToclose.isEmpty()) {
                return null;
            }
            removeMenuItem.setOnAction(arg_0 -> TabPaneTools.lambda$removeAllMenuItemFactory$5(tabPane, (List)tabsToclose, arg_0));
            return removeMenuItem;
        };
    }

    public static Function<TabPane, MenuItem> addBeforeMenuItemFactory(Supplier<Tab> addAction) {
        return TabPaneTools.addBeforeMenuItemFactory((int i) -> (Tab)addAction.get());
    }

    public static Function<TabPane, MenuItem> addBeforeMenuItemFactory(IntFunction<Tab> addAction) {
        return tabPane -> {
            ObservableList tabs = tabPane.getTabs();
            int selectedIndex = tabPane.getSelectionModel().getSelectedIndex();
            FontAwesomeIconView addBeforeIcon = new FontAwesomeIconView();
            addBeforeIcon.getStyleClass().add((Object)"add-icon-view");
            MenuItem addBefore = new MenuItem("Add before", (Node)addBeforeIcon);
            addBefore.setOnAction(e2 -> {
                Tab newTab = (Tab)addAction.apply(selectedIndex);
                if (newTab != null) {
                    tabs.add(selectedIndex, (Object)newTab);
                }
            });
            return addBefore;
        };
    }

    public static Function<TabPane, MenuItem> addAfterMenuItemFactory(Supplier<Tab> addAction) {
        return TabPaneTools.addAfterMenuItemFactory((int i) -> (Tab)addAction.get());
    }

    public static Function<TabPane, MenuItem> addAfterMenuItemFactory(IntFunction<Tab> addAction) {
        return tabPane -> {
            ObservableList tabs = tabPane.getTabs();
            int selectedIndex = tabPane.getSelectionModel().getSelectedIndex();
            FontAwesomeIconView addAfterIcon = new FontAwesomeIconView();
            addAfterIcon.getStyleClass().add((Object)"add-icon-view");
            MenuItem addAfter = new MenuItem("Add after", (Node)addAfterIcon);
            addAfter.setOnAction(e2 -> {
                Tab newTab = (Tab)addAction.apply(selectedIndex + 1);
                if (newTab != null) {
                    tabs.add(selectedIndex + 1, (Object)newTab);
                }
            });
            return addAfter;
        };
    }

    private static /* synthetic */ void lambda$removeAllMenuItemFactory$5(TabPane tabPane, List tabsToclose, ActionEvent e2) {
        tabPane.getTabs().removeAll((Collection)tabsToclose);
    }
}

