/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.chart.InvisibleNumberAxis;
import javafx.scene.shape.Line;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarkerType;

public final class ChartMarker
extends Line {
    private static final StyleablePropertyFactory<ChartMarker> FACTORY = new StyleablePropertyFactory(ChartMarker.getClassCssMetaData());
    private static final CssMetaData<ChartMarker, ChartMarkerType> MARKER_TYPE = FACTORY.createEnumCssMetaData(ChartMarkerType.class, "-marker-type", s -> s.typeProperty, (Enum)ChartMarkerType.HORIZONTAL);
    private final StyleableObjectProperty<ChartMarkerType> typeProperty = new StyleableObjectProperty<ChartMarkerType>(ChartMarkerType.HORIZONTAL){

        public String getName() {
            return "markerType";
        }

        public Object getBean() {
            return ChartMarker.this;
        }

        public CssMetaData<? extends Styleable, ChartMarkerType> getCssMetaData() {
            return MARKER_TYPE;
        }
    };
    private final DoubleProperty coordinate;
    private final ObservableList<ChangeListener<Object>> listeners = FXCollections.observableArrayList();

    public ChartMarker(DoubleProperty coordinate) {
        this.coordinate = coordinate;
        this.listeners.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(arg_0 -> ((DoubleProperty)coordinate).addListener(arg_0));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(arg_0 -> ((DoubleProperty)coordinate).removeListener(arg_0));
            }
        });
    }

    public ChartMarker(ChartMarkerType type, DoubleProperty coordinate) {
        this(coordinate);
        this.typeProperty.set((Object)type);
    }

    public void setCoordinate(double coordinate) {
        this.coordinate.set(coordinate);
    }

    public double getCoordinate() {
        return this.coordinate.get();
    }

    public DoubleProperty coordinateProperty() {
        return this.coordinate;
    }

    public void addListener(ChangeListener<Object> listener) {
        this.listeners.add(listener);
    }

    public void updateMarker(InvisibleNumberAxis xAxis, InvisibleNumberAxis yAxis) {
        if (this.typeProperty.get() == ChartMarkerType.HORIZONTAL) {
            this.setStartX(0.0);
            this.setEndX(xAxis.getWidth());
            this.setStartY(Math.ceil(yAxis.getDisplayPosition(this.coordinate.get())));
            this.setEndY(this.getStartY());
            this.toFront();
        } else if (this.typeProperty.get() == ChartMarkerType.VERTICAL) {
            this.setStartY(0.0);
            this.setEndY(yAxis.getHeight());
            this.setStartX(Math.ceil(xAxis.getDisplayPosition(this.coordinate.get())));
            this.setEndX(this.getStartX());
            this.toFront();
        }
    }

    public void destroy() {
        this.listeners.clear();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

