/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import com.sun.javafx.application.PlatformImpl;
import java.util.concurrent.CountDownLatch;
import java.util.function.BooleanSupplier;
import javafx.animation.AnimationTimer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;

public class JavaFXMissingTools {
    public static void addEquals(Translate translateToModify, Tuple2DReadOnly offset) {
        translateToModify.setX(translateToModify.getX() + offset.getX());
        translateToModify.setY(translateToModify.getY() + offset.getY());
    }

    public static void runLater(Class<?> caller, Runnable task) {
        Platform.runLater(task::run);
    }

    public static void runLaterIfNeeded(Class<?> caller, Runnable task) {
        if (Platform.isFxApplicationThread()) {
            task.run();
        } else {
            try {
                JavaFXMissingTools.runLater(caller, task);
            }
            catch (IllegalStateException e) {
                task.run();
            }
        }
    }

    public static void runNFramesLater(final int numberOfFramesToWait, final Runnable runnable) {
        new AnimationTimer(){
            int counter = 0;

            public void handle(long now) {
                if (this.counter++ > numberOfFramesToWait) {
                    runnable.run();
                    this.stop();
                }
            }
        }.start();
    }

    public static void runAndWait(Class<?> caller, Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                System.err.println("Exception in runnable");
                t.printStackTrace();
            }
        } else {
            CountDownLatch doneLatch = new CountDownLatch(1);
            JavaFXMissingTools.runLater(caller, () -> {
                try {
                    runnable.run();
                }
                finally {
                    doneLatch.countDown();
                }
            });
            try {
                doneLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void runLaterWhen(Class<?> caller, final BooleanSupplier condition, final Runnable runnable) {
        new ObservedAnimationTimer(caller.getSimpleName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleImpl(long now) {
                if (condition.getAsBoolean()) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.stop();
                    }
                }
            }
        }.start();
    }

    public static void setAnchorConstraints(Node child, double allSides) {
        JavaFXMissingTools.setAnchorConstraints(child, allSides, allSides, allSides, allSides);
    }

    public static void setAnchorConstraints(Node child, double top, double right, double bottom, double left) {
        AnchorPane.setTopAnchor((Node)child, (Double)top);
        AnchorPane.setRightAnchor((Node)child, (Double)right);
        AnchorPane.setBottomAnchor((Node)child, (Double)bottom);
        AnchorPane.setLeftAnchor((Node)child, (Double)left);
    }

    public static Application splashScreen(final Image image) {
        Application splashScreenApplication = new Application(){
            private Stage primaryStage;

            public void start(Stage primaryStage) throws Exception {
                this.primaryStage = primaryStage;
                primaryStage.initStyle(StageStyle.TRANSPARENT);
                ImageView imageView = new ImageView(image);
                imageView.setOpacity(0.0);
                Scene scene = new Scene((Parent)new Pane(new Node[]{imageView}));
                scene.setFill((Paint)Color.TRANSPARENT);
                primaryStage.setScene(scene);
                SessionVisualizerIOTools.addSCSIconToWindow((Window)primaryStage);
                primaryStage.show();
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)imageView.opacityProperty(), (Object)1.0)})});
                timeline.playFromStart();
            }

            public void stop() throws Exception {
                super.stop();
                if (this.primaryStage == null) {
                    return;
                }
                this.primaryStage.close();
                this.primaryStage = null;
            }
        };
        JavaFXMissingTools.runApplication(splashScreenApplication);
        return splashScreenApplication;
    }

    public static void runApplication(Application application) {
        JavaFXMissingTools.runApplication(application, null);
    }

    public static void runApplication(Application application, Runnable initialize) {
        Runnable runnable = () -> {
            try {
                application.start(new Stage());
                if (initialize != null) {
                    initialize.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        PlatformImpl.startup(() -> JavaFXMissingTools.runLater(application.getClass(), runnable));
        PlatformImpl.setImplicitExit((boolean)false);
    }
}

