/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.plotter;

import java.awt.Toolkit;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import us.ihmc.commons.FormattingTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXToEuclidConversions;

public class PlotterGrid2D {
    private static final int SIGNIFICANT_FIGURES = 4;
    private final Canvas canvas = new Canvas(300.0, 500.0);
    private final ReadOnlyObjectProperty<Transform> localToSceneTransformProperty;
    private final DoubleProperty lineWidthProperty = new SimpleDoubleProperty((Object)this, "lineWidthProperty", 0.125);
    private final ObjectProperty<Color> colorProperty = new SimpleObjectProperty((Object)this, "colorProperty", (Object)Color.BLACK);
    private final ObjectProperty<Font> fontProperty = new SimpleObjectProperty((Object)this, "fontProperty", (Object)Font.font((String)"Verdana", (double)10.0));

    public PlotterGrid2D(ReadOnlyObjectProperty<Transform> localToSceneTransformProperty) {
        this.localToSceneTransformProperty = localToSceneTransformProperty;
    }

    public void update(double top, double left, double width, double height) {
        int i;
        int i2;
        Point2D topLeftScene = new Point2D(left, top);
        Point2D bottomRightScene = new Point2D(left + width, top + height);
        Point2D topLeftLocal = this.sceneToLocal((Point2DReadOnly)topLeftScene);
        Point2D bottomRightLocal = this.sceneToLocal((Point2DReadOnly)bottomRightScene);
        Point2D startLocal = new Point2D();
        Point2D endLocal = new Point2D();
        if (topLeftLocal.getX() < bottomRightLocal.getX()) {
            startLocal.setX(topLeftLocal.getX());
            endLocal.setX(bottomRightLocal.getX());
        } else {
            startLocal.setX(bottomRightLocal.getX());
            endLocal.setX(topLeftLocal.getX());
        }
        if (topLeftLocal.getY() < bottomRightLocal.getY()) {
            startLocal.setY(topLeftLocal.getY());
            endLocal.setY(bottomRightLocal.getY());
        } else {
            startLocal.setY(bottomRightLocal.getY());
            endLocal.setY(topLeftLocal.getY());
        }
        Vector2D rangeLocal = new Vector2D();
        rangeLocal.sub((Tuple2DReadOnly)endLocal, (Tuple2DReadOnly)startLocal);
        Vector2D gridSizeLocal = new Vector2D(PlotterGrid2D.calculateGridSize(width / rangeLocal.getX()), PlotterGrid2D.calculateGridSize(height / rangeLocal.getY()));
        Point2D gridStartLocal = new Point2D();
        gridStartLocal.setX(Math.ceil(startLocal.getX() / gridSizeLocal.getX()) * gridSizeLocal.getX());
        gridStartLocal.setY(Math.ceil(startLocal.getY() / gridSizeLocal.getY()) * gridSizeLocal.getY());
        int gridCountX = (int)Math.ceil(rangeLocal.getX() / gridSizeLocal.getX());
        int gridCountY = (int)Math.ceil(rangeLocal.getY() / gridSizeLocal.getY());
        Vector2D gridSizeScene = this.localToScene((Vector2DReadOnly)gridSizeLocal);
        Point2D gridStartScene = this.localToScene((Point2DReadOnly)gridStartLocal);
        this.canvas.setWidth(width);
        this.canvas.setHeight(height);
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, width, height);
        gc.setStroke((Paint)this.colorProperty.get());
        gc.setLineWidth(this.lineWidthProperty.get());
        for (i2 = 0; i2 < gridCountX; ++i2) {
            double gridX = gridStartScene.getX() + (double)i2 * gridSizeScene.getX();
            gc.strokeLine(gridX, top, gridX, top + height);
        }
        for (i2 = 0; i2 < gridCountY; ++i2) {
            double gridY = gridStartScene.getY() + (double)i2 * gridSizeScene.getY();
            gc.strokeLine(left, gridY, left + width, gridY);
        }
        gc.setFont((Font)this.fontProperty.get());
        double fontSize = ((Font)this.fontProperty.get()).getSize();
        for (i = 0; i < gridCountX; ++i) {
            double gridX = gridStartScene.getX() + (double)i * gridSizeScene.getX();
            double localX = gridStartLocal.getX() + (double)i * gridSizeLocal.getX();
            gc.fillText(FormattingTools.getFormattedToSignificantFigures((double)localX, (int)4), gridX, top + fontSize);
        }
        for (i = 0; i < gridCountY; ++i) {
            double gridY = gridStartScene.getY() + (double)i * gridSizeScene.getY();
            double localY = gridStartLocal.getY() + (double)i * gridSizeLocal.getY();
            gc.fillText(FormattingTools.getFormattedToSignificantFigures((double)localY, (int)4), left, gridY - 2.0);
        }
    }

    public Point2D sceneToLocal(Point2DReadOnly pointInScene) {
        Transform transform = (Transform)this.localToSceneTransformProperty.get();
        try {
            return JavaFXToEuclidConversions.convertPoint2D(transform.inverseTransform(pointInScene.getX(), pointInScene.getY()));
        }
        catch (NonInvertibleTransformException e) {
            return null;
        }
    }

    public Point2D localToScene(Point2DReadOnly pointInLocal) {
        Transform transform = (Transform)this.localToSceneTransformProperty.get();
        return JavaFXToEuclidConversions.convertPoint2D(transform.transform(pointInLocal.getX(), pointInLocal.getY()));
    }

    public Vector2D sceneToLocal(Vector2DReadOnly pointInScene) {
        Transform transform = (Transform)this.localToSceneTransformProperty.get();
        try {
            return JavaFXToEuclidConversions.convertVector2D(transform.inverseDeltaTransform(pointInScene.getX(), pointInScene.getY()));
        }
        catch (NonInvertibleTransformException e) {
            return null;
        }
    }

    public Vector2D localToScene(Vector2DReadOnly pointInLocal) {
        Transform transform = (Transform)this.localToSceneTransformProperty.get();
        return JavaFXToEuclidConversions.convertVector2D(transform.deltaTransform(pointInLocal.getX(), pointInLocal.getY()));
    }

    private static double calculateGridSize(double pixelsPerMeter) {
        double decimalPlace;
        double orderOfMagnitude;
        double nextOrderOfMagnitude;
        double medianGridWidthInPixels = Toolkit.getDefaultToolkit().getScreenResolution();
        double desiredMeters = medianGridWidthInPixels / pixelsPerMeter;
        double percentageToNextOrderOfMagnitude = desiredMeters / (nextOrderOfMagnitude = Math.pow(10.0, (orderOfMagnitude = Math.floor(decimalPlace = Math.log10(desiredMeters))) + 1.0));
        double remainder = percentageToNextOrderOfMagnitude % 0.5;
        double roundToNearestPoint5 = remainder >= 0.25 ? percentageToNextOrderOfMagnitude + (0.5 - remainder) : percentageToNextOrderOfMagnitude - remainder;
        double gridSizeMeters = roundToNearestPoint5 > 0.0 ? nextOrderOfMagnitude * roundToNearestPoint5 : Math.pow(10.0, orderOfMagnitude);
        return gridSizeMeters;
    }

    public Node getRoot() {
        return this.canvas;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidthProperty.set(lineWidth);
    }

    public double getLineWidth() {
        return this.lineWidthProperty.get();
    }

    public DoubleProperty lineWidthProperty() {
        return this.lineWidthProperty;
    }

    public void setColor(Color color) {
        this.colorProperty.set((Object)color);
    }

    public Color getColor() {
        return (Color)this.colorProperty.get();
    }

    public ObjectProperty<Color> colorProperty() {
        return this.colorProperty;
    }

    public void setFont(Font font) {
        this.fontProperty.set((Object)font);
    }

    public Font getFont() {
        return (Font)this.fontProperty.get();
    }

    public ObjectProperty<Font> fontProperty() {
        return this.fontProperty;
    }
}

